/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Bitwise logical operators          */
/*                          Section - 4.1.3.3.1                              */
/*  Product and Revision :  1.3                                              */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.41331.c                              */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          04/04/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added test for spr0245.                       */
/*                                                                           */
/*  Date :                  4/23/84                                                  */
/*  Description :           Verify that the bitwise AND &, OR |, and XOR ^   */
/*                          operators result in the correct operation on     */
/*                          integral types.                                  */
/*                          This program only test the bitwise AND, the rest */
/*                          of the tests are on expr.41332.c and expr.41333.c*/
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE  1
int fail;
main ()
{              
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
/* Bitwise AND */
  { /*Test 1 */
    register int a,b;
    int          c;
    a = c =  2 ; b  = 3;                        /* a = 010   b = 011        */
    a = a & b;                                  /* a = 010 & 011 = 010      */
    c = c & 3;
    if ( a != 2 || b != 3 || c != 2 )
       {  fail = TRUE;
          fprintf(fp,"  ** expression, bitwise AND 4.1.3.3.1-1 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
          printf("  ** expression, bitwise AND 4.1.3.3.1-1 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  {/* Test 2 */
    unsigned a,b,c;
    a = c = 2 ; b = 3;
    a = a & b;
    c = c & 3;
    if ( a != 2 || b != 3 || c != 2 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise AND 4.1.3.3.1-2 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
         printf("  ** expression, bitwise AND 4.1.3.3.1-2 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  {/* Test 3 */
    short  a,b,c;
    a = c =  2 ; b = 3;
    a = a & b;
    c = c & 3;
    if ( a != 2 || b != 3 || c != 2 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise AND 4.1.3.3.1-3 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
         printf("  ** expression, bitwise AND 4.1.3.3.1-3 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  {/* Test 4 */
   int a,b;
   a = -2; b = 3;
   a = a & b;
   if ( a != 2 )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, bitwise AND 4.1.3.3.1-4 class 1 fail -  exit return code : %d%d\n",a,b);
            printf("  ** expression, bitwise AND 4.1.3.3.1-4 class 1 fail -  exit return code : %d%d\n",a,b);
         }
  }
 
  {/* Test 5 */
     unsigned a,b ;
     a = 0x0f0f0f0f;
     b = 0xf0f0f0f0;
     a = a & b;
     if ( a != 0 )
        { fail = TRUE;
          fprintf(fp," ** expressions, bitwise AND 4.1.3.3.1-5 class 1 fail -  exit return code : %x%x\n",a,b);
          printf(" ** expressions, bitwise AND 4.1.3.3.1-5 class 1 fail -  exit return code : %x%x\n",a,b);
        }
  }
 
  {/* Test 6 */
     int a,b,c,d;
     a =  1 & 1 & 0  &  1 & 1  ;
     b =  1 & ( 1 & 0 ) & ( 1 & 1 );
     c =  ( 1 & 1 ) & ( 0 & 1 ) & 1;
     if ( a != 0 || b != 0 || c != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** expression, bitwise AND 4.1.3.3.1-6 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
          printf("  ** expression, bitwise AND 4.1.3.3.1-6 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
        }
  }
 
  {/* Test 7 */
   /*        using AND, OR and complement operator */
     int a,b ;
     a = ~ ( 0177 | 0611 | 0100 );
     b = ~ 0177 & ~ 0611 & ~ 0100 ;
     if ( a != b)
        { fail = TRUE;
          fprintf(fp,"  ** expression, bitwise operators 4.1.3.3.1-7 class 1 fail -  exit return code : %x%x\n",a,b);
          printf("  ** expression, bitwise operators 4.1.3.3.1-7 class 1 fail -  exit return code : %x%x\n",a,b);
        }
   }
/*   Test 8   */
/*   This test was originally spr0245 written against UTX Release 2.0.        */
/*   Problem description:  The following statement does not "and" correctly.  */
 {
     char a, b, c2, c3, c4;
     a  = 0;
     b  = 0;
     c2 = 0;
     c3 = 4;
     c4 = 4;
 
     a = ( c4 & ( ~c2 ) );
     b = ( ( c2 | c3 ) == ( c4 & ( ~c2 ) ) );
 
     if ( a != 4 || b != 1 )
        { fail = TRUE;
          fprintf(fp,"  ** expression, bitwise operators 4.1.3.3.1-8 class 1 fail -  exit return code : %x%x\n",a,b);
          printf("  ** expression, bitwise operators 4.1.3.3.1-8 class 1 fail -  exit return code : %x%x\n",a,b);
        }
 }
if (!fail)
       {fprintf(fp,"  .. expression, bitwise AND 4.1.3.3.1 class 1 pass\n");
        printf("  .. expression, bitwise AND 4.1.3.3.1 class 1 pass\n");}
fclose(fp);
 
 
}
 
