/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions, Arithmetic Operators,               */
/*                          Pointer Arithmetic, Pointer Subtraction          */
/*                          Section  4.1.2.6                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/expr.41264.c                              */
/*  Revisions :             03/26/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that two pointers to the same object      */
/*                          can be subtracted, and that the result is        */
/*                          converted to an integer and represents the       */
/*                          number of objects separating the pointed to      */
/*                          objects.                                         */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      Test 1 was originally qar128 written against UTX Release 2.0.        */
/*      Problem description:  The following program generates incorrect      */
/*              code indicating a compiler problem with pointer arithmetic.  */
 
#include <stdio.h>
#define TRUE 1
int fail;
 
FILE *fp;
main()
{
        char buf[40], *b, *c;
 
        c = buf;
        b = buf - 1;
        fp=fopen("expr_res bloc=y","a");
 
        if ( b != ( c - 1 ) )
        {  fail = TRUE;
           fprintf(fp,"  ** expression, pointer arithmetic 4.1.2.6.4 class 1 fail  -  exit return code : %d\n", b );
           printf("  ** expression, pointer arithmetic 4.1.2.6.4 class 1 fail  -  exit return code : %d\n", b );
        }
 
        if ( !fail )
          {fprintf(fp," .. expression, pointer arithmetic 4.1.2.6.4 class 1 pass\n");
           printf(" .. expression, pointer arithmetic 4.1.2.6.4 class 1 pass\n");}
        fclose(fp);
}
