/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Sizeof operator                    */
/*                          Section - 4.1.1.7                                */
/*  Product and Revision :  Unix 1.9                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.4117.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          03/05/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          --  Added Test 9 to test the size of long float. */
/*                          --  Modified comparison in test 8.  When one     */
/*                              operand is float and the other is double     */
/*                              the result is double.                        */
/*                          03/26/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          --  Added comment and printf statement in test 3 */
/*                              to indicate that float is 4 bytes for this   */
/*                              release.                                     */
/*                          06/14/84    T. Aleksa    UTX-32 1.0 Release      */
/*                          --  Added test for qar398.                       */
/*                          07/30/84    T. Aleksa    UTX-32 1.0 Release      */
/*                          --  Updated test 10.                             */
/*                          09/28/85    T. Aleksa    UTX-32 1.2 Releae       */
/*                          --  Updated test 10.                             */
/*  Date :                  9/28/85                                          */
/*  Description :           Verify sizeof<variable> yields the number of     */
/*                          bytes of the size of a variable.                 */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define   STRUCTSIZE    8
#define   TABSIZE       40
#define   TRUE          1
 
struct key {
             char *keyword;
             int  keycount;
           }  keytab[] = { {"auto",0},   /* initialize keyword and its  */
                           {"break",0},  /*  count                      */
                           {"case",0},
                           {"char",0},
                           {"continue",0}};
 
main()
{
      FILE *fp;
      int a,b;
      int fail=0;
 
fp=fopen("expr_res bloc=y","a");          /* OPEN FILE FOR WRITTING RESULTS */
      /* Test 1 : sizeof ( sturcture variable ) */
      if ( (a=sizeof(struct key)) != STRUCTSIZE ||
           (b=sizeof(keytab))     != TABSIZE       )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-1 class 1 fail exit return code : %d%d\n",a,b);
            printf("  ** expression, sizeof operator 4.1.1.7-1 class 1 fail exit return code : %d%d\n",a,b);
         }
 
      /* Test 2 : sizeof ( integer variable ) */
      {  int c,sc ;
         c =   1;
         sc = sizeof(c);
         if ( sc != 4  )
            { fail = TRUE;
              fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-2 class 1 fail exit return code : %d\n",sc);
              printf("  ** expression, sizeof operator 4.1.1.7-2 class 1 fail exit return code : %d\n",sc);
            }
      }
 
 
      /* Test 3 : sizeof ( floating point variable ) */
      /*          For UTX-32 1.0 Release, all floating point arithmetic is
                  done in single precision.  Therefore, sizeof float is
                  4 bytes. */
      /* Spr 102 written against UTX Release 2.0 reports that sizeof float
                 returns the incorrect value of 4 bytes rather than 8 bytes.*/
      { float e;
        int  se;
        se = sizeof(e);
        if ( se == 4  ) {
           fprintf(fp,"  !! expression 4.1.1.7-3 sizeof (float) is 4 bytes.\n    \Single precision arithmetic.  Check documentation.\n");
           printf("  !! expression 4.1.1.7-3 sizeof (float) is 4 bytes.\n    \Single precision arithmetic.  Check documentation.\n");
           }
        else if ( se == 8 ) {
           fprintf(fp,"  !! expression 4.1.1.7-3 sizeof (float) is 8 bytes.\n    \Double precision arithmetic.  Check documentation.\n");
           printf("  !! expression 4.1.1.7-3 sizeof (float) is 8 bytes.\n    \Double precision arithmetic.  Check documentation.\n");
           }
        else
           {
             fail = TRUE;
             fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-3 class 1 fail exit return code : %d\n",se);
             printf("  ** expression, sizeof operator 4.1.1.7-3 class 1 fail exit return code : %d\n",se);
           }
      }
 
      /* Test 4 : sizeof ( double variable ) */
      { double d;
        int sd;
        sd = sizeof (d);
        if ( sd != 8 )
           { fail = TRUE;
             fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-4 class 1 fail exit return code : %d\n",sd);
             printf("  ** expression, sizeof operator 4.1.1.7-4 class 1 fail exit return code : %d\n",sd);
           }
      }
 
      /* Test 5 : sizeof ( integer constant )  */
      { int s1 ;
        s1 = sizeof(1);
        if ( s1 != 4 )
           {
             fail = TRUE;
             fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-5 class 1 fail exit return code : %d\n",s1);
             printf("  ** expression, sizeof operator 4.1.1.7-5 class 1 fail exit return code : %d\n",s1);
           }
      }
 
      /* Test 6 : sizeof ( double constant ) */
      { int sd;
        sd = sizeof(1.5e-1);
        if ( sd != 8 )
           {
             fail = TRUE;
             fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-6 class 1 fail exit return code : %d\n",sd);
             printf("  ** expression, sizeof operator 4.1.1.7-6 class 1 fail exit return code : %d\n",sd);
           }
      }
      /* Test 7 : sizeof ( float constant ) */
      /*          floating constant is taken to be double-precision,p181
                  "The C Programming language" by Kernighan and Ritchie".*/
      {
        int sf;
        sf = sizeof ( 1.13 );
        /* value 1.13 is treated as long float which has an unsigned 55-bis
           fraction with approximately 16 decimal digits of precision .
        */
        if ( sf != 8 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-7 class 3 fail exit return code : %d\n",sf);
           printf("  ** expression, sizeof operator 4.1.1.7-7 class 3 fail exit return code : %d\n",sf);
          }
      }
 
      /* Test 8 : sizeof ( expression ) */
      {
        float x;
        int  sx,sa,sb;
        sx = sizeof ( 1.5 + x );
 
        sa = sizeof ( 1.5 + 1.5 );      /* floating constant is treated as
                                           long float which is 8 bytes */
        if ( sx != 8 || sa != 8  )
           {
             fail = TRUE;
             fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-8 class 3 fail exit return code : %d%d\n",sx,sa);
             printf("  ** expression, sizeof operator 4.1.1.7-8 class 3 fail exit return code : %d%d\n",sx,sa);
           }
      }
 
      /* Test 9 : sizeof ( long float ) */
      /*          long float is taken to be double.   */
      {
        long float x;
        int sx;
 
        sx = sizeof ( x );
 
        if ( sx != 8 )
           {
             fail = TRUE;
             fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-9 class 3 fail exit return code : %d\n",sx);
             printf("  ** expression, sizeof operator 4.1.1.7-9 class 3 fail exit return code : %d\n",sx);
           }
      }
 
      /* Test 10 : sizeof "string"           */
 
      /* This test is qar398 written against UTX-32 (1.0).
         Problem Description:  The sizeof operator does not handle string
                 constants properly.
      */
      {
       int i, j, k;
       static char l[] = "this is a long string";
 
       /*  The compiler considers a string to be represented by a pointer
           to char.  In the following example, i has the value of the
           length of the string which is 22 bytes.
       */
 
       i = sizeof("this is a long string");
 
       /*  In the following example, j = 1.  The size of what the pointer
           points to is evaluated, which is a char so the value is 1 byte.
       */
 
       j = sizeof( * "this is a long string");
 
       /*  In the following example, k = 22 since the compiler considers
           l to be a type array of char rather than as pointer to char.
       */
 
       k = sizeof(l);
 
       if ( i != 22 || j != 1 || k != 22 )
          {
            fail = TRUE;
            fprintf(fp,"  ** expression, sizeof operator 4.1.1.7-10 class 3 fail exit return code : %d%d%d\n", i,j,k );
            printf("  ** expression, sizeof operator 4.1.1.7-10 class 3 fail exit return code : %d%d%d\n", i,j,k );
          }
       }
 
      if (!fail) {
         fprintf(fp,"  .. expression, sizeof operator 4.1.1.7 class 1 pass\n");
         printf("  .. expression, sizeof operator 4.1.1.7 class 1 pass\n");
         }
         fclose(fp);
}
