/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Unary operator                     */
/*                          Section - 4.1.1.5                                */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.4115.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          07/02/84    T. Aleksa    UTX-32  1.0 Release     */
/*                          -- Added cast to unsigned in test 1.             */
/*  Date :                  7/2/84                                           */
/*  Description :           Verify the unary ~ operators yields one's        */
/*                          complement of its operand.                       */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define   TRUE   1
#define   FALSE  0
 
main()
{
  FILE *fp;
  int fail=0;                                     /* will be turned on if one */
                                                /* of the tests fails       */
 
  /* Test 1 : verify that the complement of integer ival is all 0 ,
              and the complement of unsigned uval is all 1.
  */
  int ival = 0xffffffff;
  unsigned uval = 0x0;
  fp=fopen("expr_res bloc=y","a");      /* OPEN FILE FOR WRITTING RESULTS */
  if ( ~ival != 0  || ~ uval != (unsigned) 0xffffffff )
     {
        fail = TRUE;
        fprintf(fp,"  ** expression, unary operator 4.1.1.5-1 class 1 fail exit return code : %x%x\n",~ival,~uval);
        printf("  ** expression, unary operator 4.1.1.5-1 class 1 fail exit return code : %x%x\n",~ival,~uval);
     }
 
 
   /* Test 2 : verify that the complement of long lval is all 0,
               and short sval is with its lower 2 bytes changed to 1.
   */
   {long lval = 0xffffffff;
    short sval= 0xffff0000;
    if ( ~lval != 0  || ~sval != 0xffffffff )
      {
        fail = TRUE;
        fprintf(fp,"  ** expression, unary operator 4.1.1.5-2 class 1 fail exit return code : %x%x\n",~lval,~sval);
        printf("  ** expression, unary operator 4.1.1.5-2 class 1 fail exit return code : %x%x\n",~lval,~sval);
      }
   }
 
   { unsigned k,l;
     k = 1;
     l = ~ k;
     if ( k != ~~k || l != ~~l )
        { fail = TRUE;
          fprintf(fp,"  ** expression, unary operator 4.1.1.5-3 class 1 fail exit return code : %x%x\n",k,~~k);
          printf("  ** expression, unary operator 4.1.1.5-3 class 1 fail exit return code : %x%x\n",k,~~k);
        }
   }
   if (!fail){
      fprintf(fp,"  .. expression, unary operator 4.1.1.5 class 1 pass\n");
      printf("  .. expression, unary operator 4.1.1.5 class 1 pass\n");
      }
      fclose(fp);
}
