/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expression, Operators                            */
/*                          Unary Operators                                  */
/*                          Section  4.1.1                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/expr.4114.c                               */
/*  Revisions :             04/04/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description:            Verify that the result of the logical negation   */
/*                          operator ! is 1 if the value of its operand is   */
/*                          0, 0 otherwise.  This is applicable to all       */
/*                          arithmetic operands and pointers.                */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
 
main()
{
FILE *fp;
 
/*      Test 1 was originally spr0009 written against UTX Release 2.0.       */
/*      Problem Description:  The negation operator sometimes produces       */
/*              incorrect results when either operand is of type "unsigned"  */
/*              short.                                                       */
 
/*      Test 1          */
 
        int a;
        unsigned short b;
        fp=fopen("expr_res bloc=y","a");
 
        a = 1;
        b = 1;
 
        if ( a != b )
         { fail = TRUE;
           fprintf(fp,"  ** expression, unary ! operator 4.1.1.4-1 class 1 fail exit return code : %d\n",b );
           printf("  ** expression, unary ! operator 4.1.1.4-1 class 1 fail exit return code : %d\n",b );
         }
 
        if (!fail){
           fprintf(fp,"  .. expression, unary ! operator 4.1.1.4 class 1 pass\n");
           printf("  .. expression, unary ! operator 4.1.1.4 class 1 pass\n");
           }
           fclose(fp);
}
