/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initializations and Variable       */
/*                          Reference  -  Compound Statements                */
/*                          Section  - 2.9                                   */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.294.c                                */
/*  Revisions :             03/15/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  3/21/85                                          */
/*  Descriptions :          For all basic types, arrays, structures, unions  */
/*                          and fields in block declarations :               */
/*                          Verify that the variables can be correctly       */
/*                          referenced.                                      */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.29.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  Test Method  -  declare and initialize variables of the same name both
                    external and within a compound statement/block ( {} ).
                    By verifying that the variable within the block contains
                    the proper value,  it is verified that it can be correctly
                    referenced without confusion from the external variable.
*/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
int       in = 1, inx[2][2] = { 1, 2, 3, 4 };
short     sh = 2, shx[2][3] = { 5, 6, 7, 8, 9, 10 };
short int si = 3, six[2][4] = { 11, 12, 13, 14, 15, 16, 17, 18 };
long      lg = 4, lgx[2][5] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };
long int  li = 5, lix[3][2] = { -1, -2, -3, -4, -5, -6 };
char      ch = 'a', chx[11] = "decl.294.c";
 
unsigned           un = 6; unx[20] = { 10, 20, 30, 40, 50, 60 };
unsigned int       ui = 7; uix[15] = { 21, 22, 23, 24, 25, 26, 27 };
unsigned short     us = 8; usx[30] = { 18, 17, 16, 15, 14, 13, 12, 10, 9 };
unsigned short int usi = 9; usix[35] = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
unsigned long      ul = 10; ulx[40] = { 0, -5, -10, -15, -20, -25, -30, -35 };
unsigned long int  uli = 11; ulix[45] = { -1, -2, -3, -4, -5, -6, -7, -8, -9 };
unsigned char      uc  = 'b', ucx[14] = "unsigned char";
 
float      fl = 12.0, flx[10] = { 1.0, 2.0, 3.0, 4.0, 5.0,
                                  6.0, 7.0, 8.0, 9.0, 10.0 };
long float lf = 13.0, lfx[4][4] = { 1.2, 2.2, 3.2, 4.2, 5.2, 6.2,
                                    7.2, 8.2, 9.2, 10.2, 11.2, 12.2 };
double     db = 14.0, dbx[20] = { 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9,
                                  2.1, 2.2, 2.3, 2.4 };
 
struct comp {
                int a;
                short b[2];
                char c;
                float d;
} str_1 = { 10, 2, 'a','b', 7.0 },
  str_2[2] = { 9, 1, 'b','c', 6.0, 8, 3, 'c', 'd', 5.0 };
 
/*  it is not permitted to initialize unions  */
 
union compx {
                int a;
                int ary[2];
                char c;
                float d;
} unio_1, unio_2[4];
 
struct fill {
                unsigned f1 : 1;
                unsigned f2 : 2;
                unsigned f3 : 4;
                unsigned f4 : 1;
                unsigned f5 : 6;
}a_int = { 1, 0, 15, 1, 33 },
 b_int[2] = { { 1, 2, 4, 1, 20 }, { 1, 3, 5, 1, 30 } };
 
main()
{
FILE *fp;
 
/*  Test 1  -  verify that scalars can be correctly referenced     */
{
        int       in = 2;
        short     sh = 3;
        short int si = 4;
        long      lg = 5;
        long int  li = 6;
        char      ch = 'b';
 
        unsigned           un = 7;
        unsigned int       ui = 8;
        unsigned short     us = 9;
        unsigned short int usi = 10;
        unsigned long      ul = 11;
        unsigned long int  uli = 12;
        unsigned char      uc  = 'c';
 
        float      fl = 13.0;
        long float lf = 14.0;
        double     db = 15.0;
 
        register     r  = 8;
        register int ri = 9;
 
fp=fopen("decl_res bloc=y","a");    /* OPEN FILE FOR WRITTING RESULTS */
 
        if ( in != 2 || sh != 3 || si != 4 ||
             lg != 5 || li != 6 || ch != 'b'  )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-1 class 1 fail exit return code : %d%d%d%d%d%c\n", in,sh,si,lg,li,ch );
             printf("  ** declaration, compound 2.9.4-1 class 1 fail exit return code : %d%d%d%d%d%c\n", in,sh,si,lg,li,ch );
           }
 
        if ( un != 7  || ui != 8    || us != 9 || usi != 10 ||
             ul != 11 || uli != 12  || uc != 'c'              )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-2 class 1 fail exit return code : %u%u%u%u%u%u%c\n",un, ui, us, usi, ul, uli, uc );
             printf("  ** declaration, compound 2.9.4-2 class 1 fail exit return code : %u%u%u%u%u%u%c\n",un, ui, us, usi, ul, uli, uc );
           }
 
        if ( fl != 13.0 || lf != 14.0  || db != 15.0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-3 class 1 fail exit return code : %f%f%f\n", fl, lf, db );
             printf("  ** declaration, compound 2.9.4-3 class 1 fail exit return code : %f%f%f\n", fl, lf, db );
           }
 
        if ( r != 8 || ri != 9 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-4 class 1 fail exit return code : %d%d\n", r, ri );
             printf("  ** declaration, compound 2.9.4-4 class 1 fail exit return code : %d%d\n", r, ri );
           }
}
/*  Test 2  -  verify that arrays can be correctly referenced       */
{
 
        int       inx[2][2];
        short     shx[2][3];
        short int six[2][4];
        long      lgx[2][5];
        long int  lix[3][2];
        char      chx[11];
 
        unsigned           unx[20];
        unsigned int       uix[15];
        unsigned short     usx[30];
        unsigned short int usix[35];
        unsigned long      ulx[40];
        unsigned long int  ulix[45];
        unsigned char      ucx[14];
 
        float flx[10];
        long float lfx[4][4];
        double dbx[20];
 
    /*  initialize specific elements in the arrays  */
 
        inx[1][1] = -4;
        shx[1][2] = -10;
        six[0][3] = -14;
        lgx[0][4] = -5;
        lix[2][1] =  6;
        chx[10] = 'x';
 
        unx[5] = 20;
        uix[14] = 28;
        usx[27] = 19;
        usix[33] = (-100);
        ulx[37] = 75;
        ulix[41] = 333;
        ucx[4] = 'T';
 
        flx[5] = 20.0;
        lfx[2][2] = 6.7;
        dbx[18] = 8.3;
 
    /*  verify that values can be referenced  */
 
        if ( inx[1][1] != -4  || shx [1][2] != -10 ||
             six[0][3] != -14 || lgx[0][4] != -5   ||
             lix[2][1] != 6   || chx[10] != 'x'     )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-5 class 1 fail exit return code : %d%d%d%d%d%c\n", inx[1][1],shx[1][2], six[0][3], lgx[0][4], lix[2][1], chx[10] );
             printf("  ** declaration, compound 2.9.4-5 class 1 fail exit return code : %d%d%d%d%d%c\n", inx[1][1],shx[1][2], six[0][3], lgx[0][4], lix[2][1], chx[10] );
           }
 
        if ( unx[5] != 20     || uix[14] != 28      ||
             usx[27] != 19    || usix[33] != 65436  ||
             ulx[37] != 75    || ulix[41] != 333    ||
             ucx[4] != 'T' )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-6 class 1 failexit return code : %u%u%u%u%u%u%c\n", unx[5], uix[14],usx[27], usix[33], ulx[37], ulix[41], ucx[4] );
             printf("  ** declaration, compound 2.9.4-6 class 1 failexit return code : %u%u%u%u%u%u%c\n", unx[5], uix[14],usx[27], usix[33], ulx[37], ulix[41], ucx[4] );
           }
 
        if ( flx[5] != 20.0 || lfx[2][2] != 6.7 || dbx[18] != 8.3 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-7 class 1 fail exit return code : %f%f%f\n", flx[5], lfx[2][2],dbx[18] );
             printf("  ** declaration, compound 2.9.4-7 class 1 fail exit return code : %f%f%f\n", flx[5], lfx[2][2],dbx[18] );
           }
}
/*  Test 3  -  verify that structures can be correctly referenced  */
{
        struct comp {
                int a;
                short b[2];
                char c;
                float d;
        } str_1, str_2[2];
 
        /*  initialize structure elements  */
 
        str_1.a = 12;
        str_1.b[0] = 2;
        str_2[0].b[1] = 4;
        str_2[1].d = 4.0;
        str_2[1].c = 'e';
 
        /*  verify values                  */
 
        if ( str_1.a != 12     || str_1.b[0] != 2 || str_2[0].b[1] != 4 ||
             str_2[1].d != 4.0 || str_2[1].c != 'e' )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-8 class 1 fail exit return code : %d%d%d%f%c\n", str_1.a, str_1.b[0],str_2[0].b[1], str_2[1].d, str_2[1].c );
             printf("  ** declaration, compound 2.9.4-8 class 1 fail exit return code : %d%d%d%f%c\n", str_1.a, str_1.b[0],str_2[0].b[1], str_2[1].d, str_2[1].c );
           }
}
/*  Test 4  -  verify that unions can be correctly referenced      */
{
        union compx {
                int a;
                int ary[2];
                char c;
                float d;
        } unio_1, unio_2[4];
 
        /*  initialize union members  */
 
        unio_1.a = 50;
        unio_2[0].a = 100;
        unio_2[1].ary[0] = 10;
        unio_2[1].ary[1] = 20;
        unio_2[2].c = 'b';
        unio_2[3].d = 1.0;
 
        /*  verify values             */
 
        if ( unio_1.a != 50         || unio_2[0].a != 100     ||
             unio_2[1].ary[0] != 10 || unio_2[1].ary[1] != 20 ||
             unio_2[2].c != 'b'     || unio_2[3].d != 1.0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-9 class 1 fail exit return code : %d%d%d%d%c%f\n", unio_1.a,unio_2[0].a, unio_2[1].ary[0], unio_2[1].ary[1],unio_2[2].c, unio_2[3].d );
             printf("  ** declaration, compound 2.9.4-9 class 1 fail exit return code : %d%d%d%d%c%f\n", unio_1.a,unio_2[0].a, unio_2[1].ary[0], unio_2[1].ary[1],unio_2[2].c, unio_2[3].d );
           }
}
/*  Test 5  -  verify that fields can be correctly referenced      */
{
        struct fill {
                unsigned f1 : 1;
                unsigned f2 : 2;
                unsigned f3 : 4;
                unsigned f4 : 1;
                unsigned f5 : 6;
        } a_int, b_int[2];
 
        /*  initialize bit fields  */
 
        a_int.f1 = 0;
        a_int.f5 = 10;
        b_int[0].f2 = 1;
        b_int[0].f4 = 0;
        b_int[1].f3 = 9;
 
        /*  verify  values         */
 
        if ( a_int.f1 != 0    || a_int.f5 != 10   ||
             b_int[0].f2 != 1 || b_int[0].f4 != 0 || b_int[1].f3 != 9 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.4-10 class 1 fail exit return code : %u%u%u%u%u\n", a_int.f1, a_int.f5,b_int[0].f2, b_int[0].f4, b_int[1].f3 );
             printf("  ** declaration, compound 2.9.4-10 class 1 fail exit return code : %u%u%u%u%u\n", a_int.f1, a_int.f5,b_int[0].f2, b_int[0].f4, b_int[1].f3 );
           }
}
        if ( !fail ){
           fprintf(fp,"  .. declaration, compound 2.9.4 class 1 pass\n");
           printf("  .. declaration, compound 2.9.4 class 1 pass\n");
           }
           fclose(fp);
}
