/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations - Pointer Reference                 */
/*                          Section - 2.8.3                                  */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.283.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/09/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Cast buf to type struct model *.              */
/*                                                                           */
/*  Date :                  3/15/84                                          */
/*  Description :           Verify that members of structures and unions     */
/*                          can be referenced by using:                      */
/*                             structure_pointer->member_name and            */
/*                             union_pointer->member_name                    */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.28.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/* Test method : define a higher hierarchic structure record,
                 and then initialize each element.
                 Reference each element and print the pass message.
                 The compiler fails if this program cannot be compiled.
*/
 
#include <stdio.h>
 
main()
{
FILE *fp;
        char buf[256];
        /* define a structure record */
        struct model {
                        int     no;
                        char    *type;
                        char    *descript;
                        struct  {
                                        int     serial_no;
                                        struct  {
                                                        char *repair_type;
                                                        char *date;
                                                        char *operator;
                                                 } repair;
                                        union    {      char *test_type;
                                                        int  testse;
                                                 } test;
                                 } board;
                     } ;
 
        struct model *model_ = ( struct model *) buf;
 
        ( *model_).no = 283;                    /* model_->no = 283      */
        ( *model_).type = "declaration";        /* model_->type="declaration"*/
        model_->descript = "pointer ref. 2.8.3";
        model_->board.serial_no = 1;
        model_->board.repair.repair_type =
             "repair_type can be replaced by type in system V";
        model_->board.repair.date = "83/09/20";
        model_->board.repair.operator = "IQ master";
        model_->board.test.test_type  = "pointer ref.";
 
fp=fopen("decl_res bloc=y","a");           /* OPEN FILE FOR WRITTING RESULTS */
        if ( model_->no == 283  ){
        fprintf(fp,"  .. %s, %s class %d pass\n",model_->type, model_->descript, model_->board.serial_no);
        printf("  .. %s, %s class %d pass\n",model_->type, model_->descript, model_->board.serial_no);
        }
        else
        {
        fprintf(fp,"  ** %s, %s class %d fail\n",model_->type, model_->descript, model_->board.serial_no);
        printf("  ** %s, %s class %d fail\n",model_->type, model_->descript, model_->board.serial_no);
        }
         fclose(fp);
 
}
