/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - Pointer Reference                  */
/*                          Section  - 2.8                                   */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.2814.c                               */
/*  Revisions :             03/06/85    Sqa     Original UTX 1.2 Release     */
/*                                                                           */
/*  Date :                  10/1/85                                          */
/*  Descriptions :          For a pointer to all of the basic types, arrays  */
/*                          structures and unions:                           */
/*                          Verify that an array of static pointers can be   */
/*                          initialized on the declaration and that the      */
/*                          value of the pointers can be referenced.         */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.28.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
/*  declare external static arrays and pointer arrays
    of all types and initialize on the declaration.
*/
 
static int aa[2][2] = {{ 10, 21 },{ 2, 9 }};
static int ab[2][2] = {{ 9, 8 },{ 7, 6 }};
static int (*pa[2])[2] = { aa, ab };
 
/*  In the above declaration and assignment, pa is a pointer
    to an array of two integers, and is an array in itself.
    For example, pa[0] and pa[1].
*/
 
static short int ba[5] = { 10, 20, 30, 40, 50 };
static short int bb[7] = { 5, 10, 15, 20, 25, 30, 35 };
static short int *pb[2] = { ba, bb };
 
static short ca[20] = { 0, 2, 4, 6, 8, 10 };
static short cb[3] = { 1, 2, 3 };
static short *pc[2] = { ca, cb };
 
static long int xa[5] = { 10, 20, 30, 40, 50 };
static long int xb[7] = { 5, 10, 15, 20, 25, 30, 35 };
static long int *px[2] = { xa, xb };
 
static long ya[20] = { 0, 2, 4, 6, 8, 10 };
static long yb[3] = { 1, 2, 3 };
static long *py[2] = { ya, yb };
 
static float da[100] = { 0.5, 1.5, 2.5, 3.5, 4.5 };
static float db[200] = { 5.5, 6.5, 7.5, 8.5, 9.5 };
static float *pd[5] = { da, db };
 
static long float ea[20] = { 0.2, 1.2, 2.2, 3.2, 4.2, 5.2 };
static long float eb[40] = { 2.2, 4.2, 6.2, 8.2, 10.2, 12.2 };
static long float *pe[5] = { ea, eb };
 
static double fa[5] = { 1.0, 2.0, 3.0, 4.0, 5.0 };
static double fb[3] = { 6.0, 7.0, 8.0 };
static double *pf[2] = { fa, fb };
 
static char ga[25] = "this is test decl.2814.c";
static char gb[5] = { 'a','b','c','d','e'};
static char *pg[2] = { ga, gb };
 
static unsigned ha[10] = { 0, 25, 50, 75, 100, 125, 150, 175, 200, 225 };
static unsigned hb[5] = { 2, 4, 6, 8, 10 };
static unsigned *ph[2] = { ha, hb };
 
static unsigned int ia[2][2] = {{ 3, 2 },{ 1, 0 }};
static unsigned int ib[2][2] = {{ 9, 8 },{ 7, 6 }};
static unsigned int (*pi[2])[2] = { ia, ib };
 
static unsigned short int ja[5] = { 10, 20, 30, 40, 50 };
static unsigned short int jb[7] = { 5, 10, 15, 20, 25, 30, 35 };
static unsigned short int *pj[2] = { ja, jb };
 
static unsigned short ka[20] = { 0, 2, 4, 6, 8, 10 };
static unsigned short kb[3] = { 1, 2, 3 };
static unsigned short *pk[2] = { ka, kb };
 
static unsigned long int la[5] = { 10, 20, 30, 40, 50 };
static unsigned long int lb[7] = { 5, 10, 15, 20, 25, 30, 35 };
static unsigned long int *pl[2] = { la, lb };
 
static unsigned long ma[20] = { 0, 2, 4, 6, 8, 10 };
static unsigned long mb[3] = { 1, 2, 3 };
static unsigned long *pm[2] = { ma, mb };
 
static unsigned char na[10] = "abcdefghi";
static unsigned char nb[5] = {'z','y','x','w','v'};
static unsigned char *pn[2] = { na, nb };
 
static struct class {
              int a;
              float b;
} key[3] = { { 1, 2.0 }, { 2, 3.0 }, { 3, 4.0 } };
 
static struct class key1[2] = { { 4, 5.0 }, { 5, 6.0 } };
static struct class *ptr[2] = { key, key1 };
 
static union class2 {
             int a;
             float b;
} key2[2];
 
static union class2 key3[2];
static union class2 *pt[2] = { key2, key3 };
 
main ()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
/*  Test 1  -  int    */
 
if ( (*pa[0])[3]  != aa[1][1] || (*pa[1])[2] != ab[1][0] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-1 class 1 fail exit return code : %d%d%d%d\n", (*pa[0])[3], aa[1][1],(*pa[1])[2], ab[1][0]);
     printf("  ** declaration, pointer 2.8.1.4-1 class 1 fail exit return code : %d%d%d%d\n", (*pa[0])[3], aa[1][1],(*pa[1])[2], ab[1][0]);
   }
 
/*  Test 2  -  short int */
 
if ( *pb[0] != ba[0] || *pb[1] != bb[0] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-2 class 1 fail exit return code : %d%d%d%d\n", *pb[0], ba[0], *pb[1], bb[0] );
     printf("  ** declaration, pointer 2.8.1.4-2 class 1 fail exit return code : %d%d%d%d\n", *pb[0], ba[0], *pb[1], bb[0] );
   }
 
/*  Test 3  -  short  */
 
if ( *(pc[0] + 1) != ca[1] || *(pc[1] + 1) != cb[1] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-3 class 1 fail exit return code : %d%d%d%d\n",*(pc[0]+1), ca[1], *(pc[1]+1), cb[1] );
     printf("  ** declaration, pointer 2.8.1.4-3 class 1 fail exit return code : %d%d%d%d\n",*(pc[0]+1), ca[1], *(pc[1]+1), cb[1] );
   }
 
/*  Test 4  -  long int  */
 
if ( *(px[0] + 4) != xa[4] || *(px[1] + 3) != xb[3] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-4 class 1 fail exit return code : %d%d%d%d\n",*(px[0]+4), xa[4], *(px[1]+3), xb[3] );
     printf("  ** declaration, pointer 2.8.1.4-4 class 1 fail exit return code : %d%d%d%d\n",*(px[0]+4), xa[4], *(px[1]+3), xb[3] );
   }
 
/*  Test 5  -  long  */
 
if ( *(py[0] + 3) != ya[3] || *(py[1] + 2) != yb[2] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-5 class 1 fail exit return code : %d%d%d%d\n",*(py[0]+3), ya[3], *(py[1]+2), yb[2] );
     printf("  ** declaration, pointer 2.8.1.4-5 class 1 fail exit return code : %d%d%d%d\n",*(py[0]+3), ya[3], *(py[1]+2), yb[2] );
   }
 
/*  Test 6  -  float  */
 
if ( *(pd[0] + 20) != da[20] || *(pd[1] + 100) != db[100] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-6 class 1 fail exit return code : %f%f%f%f\n",*(pd[0]+20), da[20], *(pd[1]+100), db[100] );
     printf("  ** declaration, pointer 2.8.1.4-6 class 1 fail exit return code : %f%f%f%f\n",*(pd[0]+20), da[20], *(pd[1]+100), db[100] );
   }
 
/*  Test 7  -  long float  */
 
if ( *(pe[0] + 5 ) != ea[5] || *(pe[1] + 5 ) != eb[5] )
   { fail =  TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-7 class 1 fail exit return code : %f%f%f%f\n",*(pe[0]+5), ea[5], *(pe[1]+5), eb[5] );
     printf("  ** declaration, pointer 2.8.1.4-7 class 1 fail exit return code : %f%f%f%f\n",*(pe[0]+5), ea[5], *(pe[1]+5), eb[5] );
   }
 
/*  Test 8  -  double  */
 
if ( (pf[0][3]) != fa[3] || (pf[1][2]) != fb[2] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-8 class 1 fail exit return code : %f%f%f%f\n",(pf[0][3]), fa[3], (pf[1][2]), fb[2] );
     printf("  ** declaration, pointer 2.8.1.4-8 class 1 fail exit return code : %f%f%f%f\n",(pf[0][3]), fa[3], (pf[1][2]), fb[2] );
   }
 
/*  Test 9   -  char  */
 
if ( pg[0][20] != ga[20] || *(pg[1] + 4) != gb[4] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-9 class 1 fail exit return code : %c%c%c%c\n",pg[0][20], ga[20], *(pg[1] + 4), gb[4] );
     printf("  ** declaration, pointer 2.8.1.4-9 class 1 fail exit return code : %c%c%c%c\n",pg[0][20], ga[20], *(pg[1] + 4), gb[4] );
   }
 
/*  Test 10  -  unsigned  */
 
if ( *(ph[0] + 10 ) != *hb || *(ph[1] - 2 ) != ha[8] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-10 class 1 fail exit return code : %d%d%d%d\n",*(ph[0]+10), *hb, *(ph[1] - 2 ), ha[8] );
     printf("  ** declaration, pointer 2.8.1.4-10 class 1 fail exit return code : %d%d%d%d\n",*(ph[0]+10), *hb, *(ph[1] - 2 ), ha[8] );
   }
 
/*  Test 11 -  unsigned int  */
 
if ( (*pi[0])[1] != ia[0][1] || (*pi[1])[2] != ib[1][0] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-11 class 1 fail exit return code : %d%d%d%d\n",(*pi[0])[1], ia[0][1], (*pi[1])[2], ib[1][0] );
     printf("  ** declaration, pointer 2.8.1.4-11 class 1 fail exit return code : %d%d%d%d\n",(*pi[0])[1], ia[0][1], (*pi[1])[2], ib[1][0] );
   }
 
/*  Test 12  -  unsigned short int  */
 
if ( *(pj[0] + 1 ) != ja[1] || *(pj[1] + 7 ) != jb[7] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-12 class 1 fail exit return code : %d%d%d%d\n",*(pj[0]+1), ja[1], *(pj[1]+7), jb[7] );
     printf("  ** declaration, pointer 2.8.1.4-12 class 1 fail exit return code : %d%d%d%d\n",*(pj[0]+1), ja[1], *(pj[1]+7), jb[7] );
   }
 
/*  Test 13  -  unsigned short  */
 
if ( *(pk[0] + 5 ) != ka[5] || *(pk[1] + 1 ) != kb[1] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-13 class 1 fail exit return code : %d%d%d%d\n",*(pk[0] + 5 ), ka[5], *(pk[1] + 1), kb[1] );
     printf("  ** declaration, pointer 2.8.1.4-13 class 1 fail exit return code : %d%d%d%d\n",*(pk[0] + 5 ), ka[5], *(pk[1] + 1), kb[1] );
   }
 
/*  Test 14  -  unsigned long int  */
 
if ( *(pl[0] + 3) != la[3] || *(pl[1] + 6 ) != lb[6] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-14 class 1 fail6 exit return code : %d%d%d%d\n",*(pl[0]+3), la[3], *(pl[1]+6), lb[6] );
     printf("  ** declaration, pointer 2.8.1.4-14 class 1 fail6 exit return code : %d%d%d%d\n",*(pl[0]+3), la[3], *(pl[1]+6), lb[6] );
   }
 
/*  Test 15  -  unsigned long  */
 
if ( *(pm[0] + 19 ) != 0 || *(pm[1] + 2 ) != mb[2] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-15 class 1 fail exit return code : %d%d%d\n",*(pm[0]+19), *(pm[1]+2), mb[2] );
     printf("  ** declaration, pointer 2.8.1.4-15 class 1 fail exit return code : %d%d%d\n",*(pm[0]+19), *(pm[1]+2), mb[2] );
   }
 
/*  Test 16  -  unsigned char  */
 
if ( *(pn[0] + 9 ) != '\0' || *(pn[1] + 4 ) != nb[4] )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-16 class 1 fail exit return code : %c%c%c\n", *(pn[0]+9), *(pn[1]+4), nb[4] );
     printf("  ** declaration, pointer 2.8.1.4-16 class 1 fail exit return code : %c%c%c\n", *(pn[0]+9), *(pn[1]+4), nb[4] );
   }
 
/*  Test 17  -  structures  */
 
if ( (ptr[0] + 1)->a != key[1].a ||
      ptr[1]->b != key1[0].b      )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-17 class 1 fail exit return code : %d%d%f%f\n", (ptr[0] + 1)->a,key[1].a, ptr[1]->b, key1[0].b );
     printf("  ** declaration, pointer 2.8.1.4-17 class 1 fail exit return code : %d%d%f%f\n", (ptr[0] + 1)->a,key[1].a, ptr[1]->b, key1[0].b );
   }
 
/*  Test 18  -  unions  */
 
key2[0].a = 1;
key3[1].b = 5.0;
 
if ( pt[0]->a != key2[0].a || (pt[1] + 1)->b != key3[1].b  )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, pointer 2.8.1.4-18 class 1 fail exit return code : %d%d%f%f\n", pt[0]->a,key2[0].a, (pt[1] + 1)->b, key3[1].b );
     printf("  ** declaration, pointer 2.8.1.4-18 class 1 fail exit return code : %d%d%f%f\n", pt[0]->a,key2[0].a, (pt[1] + 1)->b, key3[1].b );
   }
 
 
   if (!fail) {
        fprintf(fp,"  .. declaration, pointer 2.8.1.4 class 1 pass\n");
        printf("  .. declaration, pointer 2.8.1.4 class 1 pass\n");
        }
        fclose(fp);
 
}
