/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Type Declarations                    */
/*                          Section  2.7                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  11/9/84                                          */
/*  Source File :           source/decl.276.c                                */
/*  Revisions :             04/05/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          07/30/84    T. Aleksa     UTX-32  1.0  Release   */
/*                          11/09/84    T. Aleksa     UTX/32  1.1  Release   */
/*                                                                           */
/*  Description :           Verify that a variable name can be identical     */
/*                          to a typedef type.                               */
/*                          The compiler fails if the program does not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.27.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  The UTX/32 C compiler does not permit redeclaration of a type name       */
/*  except with the following exception:  a type name can be redeclared      */
/*  when it appears as an argument in a function definition.  In this case,  */
/*  the typedef is hidden throughout the function, and the name refers to    */
/*  ordinary variable which is the declared argument.                        */
/*****************************************************************************/
 
#include <stdio.h>
 
typedef char string;
FILE *fp;
main()
{
        string xx;
        fp=fopen("decl_res bloc=y","a");
        xx = 'b';
        foo( xx );
        fclose(fp);
}
foo(string)
char string;
{
        if ( string != 'b' ) {
          fprintf(fp,"  ** declaration, typdef 2.7.6 class 2 fail exit return code : %c\n", string );
          printf("  ** declaration, typdef 2.7.6 class 2 fail exit return code : %c\n", string );
          }
        else
         {
          fprintf(fp,"  .. declaration, typdef 2.7.6 class 2 pass\n");
          printf("  .. declaration, typdef 2.7.6 class 2 pass\n");
          }
}
