/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Enumerations                         */
/*                          Section  2.5                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.254.c                                */
/*  Revisions :             05/30/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that enumeration constants can be used    */
/*                          with switch, if, for, while and do...while       */
/*                          statements.                                      */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.25.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
enum test { TRUE, FALSE };
enum test fail;
 
enum continent { Asia, Africa, NoAmerica, SoAmerica, Europe,
                 Australia, Antartica };
enum continent LAND, *ptr;
 
main()
{
        FILE *fp;
        int i;
        int count0, count1, count2, count3, count4, count5, count6, other;
        fp=fopen("decl_res bloc=y","a");
 
        fail = FALSE;  /*  initialize enumeration constant to FALSE  */
 
/*  Verify that enumerations can be used with the if statement
*/
        ptr = &LAND;
        LAND = Australia;
 
        if ( LAND != Australia || *ptr != Australia )
           { fail = TRUE;
            fprintf(fp,"  ** declaration, enumeration 2.5.4-1 class 3 fail exit return code : %d%d\n", LAND, *ptr );
            printf("  ** declaration, enumeration 2.5.4-1 class 3 fail exit return code : %d%d\n", LAND, *ptr );
           }
 
        if ( ( LAND == Antartica ? 1 : 0 ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, enumeration 2.5.4-2 class 3 fail exit return code : %d\n", LAND );
             printf("  ** declaration, enumeration 2.5.4-2 class 3 fail exit return code : %d\n", LAND );
           }
 
 
/*  Verify that enumerations can be used with while and do...while
    statements.
*/
        LAND = Antartica;
        i = 0;
        while ( LAND == Antartica ) {
              if ( i == 7 ) LAND = Europe;
              i++;
        }
 
        if ( LAND != Europe || i != 8 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, enumeration 2.5.4-3 class 3 fail exit return code : %d%d\n", LAND, i );
             printf("  ** declaration, enumeration 2.5.4-3 class 3 fail exit return code : %d%d\n", LAND, i );
           }
 
/*  Do...while
*/
        i = 0;
        *ptr = Asia;
        do {
           if ( i == 3 ) *ptr = SoAmerica;
           i++;
        }  while ( *ptr == Asia );
 
        if ( *ptr != SoAmerica || i != 4 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, enumeration 2.5.4-4 class 3 fail exit return code : %d%d\n", *ptr, i );
             printf("  ** declaration, enumeration 2.5.4-4 class 3 fail exit return code : %d%d\n", *ptr, i );
           }
 
/*  Verify that enumerations can be used with switch statements.
*/
        count0 = 0; count1 = 0; count2 = 0; count3 = 0;
        count4 = 0; count5 = 0; count6 = 0; other = 0;
 
        LAND = Africa;
        while ( LAND != Asia )  {
          if ( LAND == Africa ) LAND = NoAmerica;
           else if ( LAND == NoAmerica ) LAND = SoAmerica;
            else if ( LAND == SoAmerica ) LAND = Europe;
             else if ( LAND == Europe ) LAND = Antartica;
              else if ( LAND == Antartica ) LAND = Australia;
               else  LAND = Asia;
 
          switch ( LAND ) {
                 case (int) Asia      : count0++;
                                        break;
                 case (int) Africa    : count1++;
                                        break;
                 case (int) NoAmerica : count2++;
                                        break;
                 case (int) SoAmerica : count3++;
                                        break;
                 case (int) Europe    : count4++;
                                        break;
                 case (int) Antartica : count5++;
                                        break;
                 case (int) Australia : count6++;
                                        break;
                 default              : other++;
                                        break;
          }
        }
 
        if ( count0 != 1 || count1 != 0 || count2 != 1 ||
             count3 != 1 || count4 != 1 || count5 != 1 ||
             count6 != 1 || other  != 0  )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, enumeration 2.5.4-5 class 3 fail exit return code : %d%d%d%d%d%d%d%d\n",count0,count1,count2,count3,count4,count5,count6,other );
             printf("  ** declaration, enumeration 2.5.4-5 class 3 fail exit return code : %d%d%d%d%d%d%d%d\n",count0,count1,count2,count3,count4,count5,count6,other );
 
           }
 
/*  Verify that enumerations can be used with for statements.
*/
        for ( i = 0, LAND = Asia; LAND != Australia; i++ )
        {
                if ( i == 10 ) LAND = Australia;
        }
 
        if ( LAND != Australia || i != 11 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, enumeration 2.5.4-5 class 3 fail exit return code : %d%d\n", LAND, i );
             printf("  ** declaration, enumeration 2.5.4-5 class 3 fail exit return code : %d%d\n", LAND, i );
           }
 
        if ( fail == FALSE ){
           fprintf(fp,"  .. declaration, enumeration 2.5.4 class 3 pass\n");
           printf("  .. declaration, enumeration 2.5.4 class 3 pass\n");
           fclose(fp);
}
}  /*END OF MAIN*/
