/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Enumerations                         */
/*                          Section  2.5                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.251.c                                */
/*  Revisions :             05/29/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that each constant in an enumeration      */
/*                          list has a value beginning at 0 and increasing   */
/*                          by 1 as the declaration is read from left to     */
/*                          right.
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.25.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
/*  Syntax:     enum identifier { enum-list }
                enum identifier { enum-list }
*/
 
enum test  { TRUE, FALSE };
enum test fail;
 
enum color { red, blue, green, orange, yellow };
 
main()
{
FILE *fp;
 
enum language { french, spanish, english, german, italian, russian };
 
fp=fopen("decl_res bloc=y","a");
fail = FALSE;  /*  initialize enumeration constant to FALSE  */
 
if ( red != 0 || blue != 1 || green != 2 ||
     orange != 3 || yellow != 4 )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.1-1 class 3 fail exit return code : %d%d%d%d%d\n", red, blue, green, orange, yellow );
     printf("  ** declaration, enumeration 2.5.1-1 class 3 fail exit return code : %d%d%d%d%d\n", red, blue, green, orange, yellow );
   }
 
if ( french != 0 || spanish != 1 || english != 2 ||
     german != 3 || italian != 4 || russian != 5 )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration, 2.5.1-2 class 3 fail exit return code : %d%d%d%d%d%d\n",french, spanish, english, german, italian, russian );
     printf("  ** declaration, enumeration, 2.5.1-2 class 3 fail exit return code : %d%d%d%d%d%d\n",french, spanish, english, german, italian, russian );
   }
 
if ( fail == FALSE ){
   fprintf(fp,"  .. declaration, enumeration 2.5.1 class 3 pass\n" );
   printf("  .. declaration, enumeration 2.5.1 class 3 pass\n" );
   }
   fclose(fp);
 
}
