/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - Unions                             */
/*                          Section  - 2.4                                   */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.2435.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Descriptions :          Verify that union members of a union within a    */
/*                          structure can be referenced.                     */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
/* Unions */
#define    INT   01
#define    FLOAT 02
#define    CHAR  03
/* global variables for 2.4.3.5 */
#define    SIZE  4
 
struct TABLE{
           char *command;
           int  id;
           int  type;
           union  {
                    int ival;
                    float fval;
                    char *sval;
                  } val;
       } MBT[SIZE] ;
main()
{
FILE *fp;
 /* local variables used */
       int   error;
       int   i;
       char  *TEST;
       TEST  ="TEST 2.4.3.5";
 
fp=fopen("decl_res bloc=y","a");
/* Test 1 : verify members of structure can be referenced */
       /* Initialize structure variables */
       for ( i = 0; i < SIZE ; i++ )
       {
         MBT[i].type = INT;
         MBT[i].command = TEST;
         MBT[i].id      = i;
       }
       /* Ensure all variables are initialized */
       /* and can be referenced.               */
       for ( i = 0; i <SIZE ; i++ )
       {
         if ( MBT[i].type == INT && MBT[i].id == i &&
              MBT[i].command == TEST )
            { error = 0;
              continue;
            }
 
         else
            { error = 1;
              fprintf(fp,"  ** declaration, unions 2.4.3.5-1 class 2 fail exit return code : %d\n",error);
              printf("  ** declaration, unions 2.4.3.5-1 class 2 fail exit return code : %d\n",error);
              break;
            }
       }
 
/* Test 2 : verify union members of a union within a structure
            can be referenced.
*/
    for ( i = 0; i < SIZE; i++ )        /* initialize the members */
    {
      MBT[i].val.ival = i ;
    }
 
    for ( i = 0; i < SIZE; i++ )        /* reference each member  */
    {
      if ( MBT[i].val.ival != i )
         { error = 1;                                   /* set error bit */
           fprintf(fp,"  ** declaration, unions 2.4.3.5-2 class 2 fail exit return code : %d\n",error );
           printf("  ** declaration, unions 2.4.3.5-2 class 2 fail exit return code : %d\n",error );
           break;
         }
    }
    if ( !error){
        fprintf(fp,"  .. declaration, unions 2.4.3.5 class 2 pass\n");
        printf("  .. declaration, unions 2.4.3.5 class 2 pass\n");
        }
        fclose(fp);
}
 
 
