/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Union Reference                      */
/*                          Section  2.4.3                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.2434.c                               */
/*  Revisions :             05/25/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that union members of an array of unions  */
/*                          can be referenced.                               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
 
union utype {
        int a;
        float b;
        char c;
} buf[10];
 
main()
{
        FILE *fp;
 
        int i;
        char j;
        fp=fopen("decl_res bloc=y","a");
 
/* Fill up buf which is a 10 element array of union utype */
 
        for ( i = 0; i < 7; i += 3 )
            buf[i].a = i;
        for ( i = 1; i < 8; i += 3 )
            buf[i].b = i;
        for ( i = 2, j = 'a'; i < 9; i += 3, j++ )
            buf[i].c = j;
        buf[9].c = j;
 
/* Reference the array of unions */
 
if ( buf[0].a != 0 || buf[3].a != 3 || buf[6].a != 6 )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, unions 2.4.3.4-1 class 2 fail exit return code : %d%d%d\n",
             buf[0].a, buf[3].a, buf[6].a );
     printf("  ** declaration, unions 2.4.3.4-1 class 2 fail exit return code : %d%d%d\n",
             buf[0].a, buf[3].a, buf[6].a );
 
              }
 
if ( buf[1].b != 1.0 || buf[4].b != 4.0 || buf[7].b != 7.0 )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, unions 2.4.3.4-2 class 2 fail exit return code : %f%f%f\n",
             buf[1].b, buf[4].b, buf[7].b );
     printf("  ** declaration, unions 2.4.3.4-2 class 2 fail exit return code : %f%f%f\n",
             buf[1].b, buf[4].b, buf[7].b );
   }
 
if ( buf[2].c != 'a' || buf[5].c != 'b' || buf[8].c != 'c' || buf[9].c != 'd' )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, unions 2.4.3.4-3 class 2 fail exit return code : %c%c%c%c\n",
           buf[2].c, buf[5].c, buf[8].c, buf[9].c );
     printf("  ** declaration, unions 2.4.3.4-3 class 2 fail exit return code : %c%c%c%c\n",
           buf[2].c, buf[5].c, buf[8].c, buf[9].c );
   }
 
if ( !fail ) {
   fprintf(fp,"  .. declaration, unions 2.4.3.4 class 2 pass\n");
   printf("  .. declaration, unions 2.4.3.4 class 2 pass\n");
   }
   fclose(fp);
 
}
