/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Unions                               */
/*                          Section  2.4.2                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/23/84                                          */
/*  Source File :           source/decl.2423.c                               */
/*  Revisions :             05/22/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that an automatic union can be correctly  */
/*                          initialized.                                     */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      Page 198 of "The C Programming Language" by Kernighan and Ritchie
        states that it is not permitted to initialize unions.  However,
        unions may be initialized by arbitrary expressions involving
        constants, and previously declared variables and functions.
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
 
main()
{
FILE *fp;
 
union table {
        short key1;
        long key2;
        double key3;
} key;
 
fp=fopen("decl_res bloc=y","a");
        key.key1 = 1;
        if ( key.key1 != 1 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.2.3-1 class 1 fail exit return code : %d\n", key.key1 );
             printf("  ** declaration, unions 2.4.2.3-1 class 1 fail exit return code : %d\n", key.key1 );
           }
 
        key.key2 = 2;
        if ( key.key2 != 2 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.2.3-2 class 1 fail exit return code : %d\n", key.key2 );
             printf("  ** declaration, unions 2.4.2.3-2 class 1 fail exit return code : %d\n", key.key2 );
           }
 
        key.key3 = 3.3;
        if ( key.key3 != 3.3 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.2.3-3 class 1 fail exit return code : %f\n", key.key3 );
             printf("  ** declaration, unions 2.4.2.3-3 class 1 fail exit return code : %f\n", key.key3 );
           }
 
        if ( !fail ) {
           fprintf(fp,"  .. declaration, unions 2.4.2.3 class 1 pass\n");
           printf("  .. declaration, unions 2.4.2.3 class 1 pass\n");
           }
           fclose(fp);
}
