/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3                                   */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.236.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          03/01/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          --  Removed unsigned   : 0 which was forcing     */
/*                              alignment to the next word boundry, in order */
/*                              to test the default condition.               */
/*                          07/02/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          --  Added cast to unsigned in test 2.            */
/*                                                                           */
/*  Date :                  7/2/84                                           */
/*  Descriptions :          Verify that  a field which is too large to fit   */
/*                          the remainder of a word is aligned on the next   */
/*                          word boundary.                                   */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/* global data for test  2.3.6                                          */
/* define words more than 32 bits but less than 64 bits                 */
#include <stdio.h>
 
int    WSIZE = 8;
struct {
         unsigned  bit1    : 1;
         unsigned  bit4    : 4;
         unsigned  bit5    : 5;
         unsigned  bit32   : 32;
       } words;
 
 
 
main()
{
   FILE *fp;
 /* local variables used */
         int error;
 
 
   /* Fields 2.3.6 */
   /* verify that a field which is too large to fit the remainder of
      a word is aligned on the next word boundary.                      */
      fp=fopen("decl_res bloc=y","a");
 
 
   if ( (error = sizeof(words)) != WSIZE ){
        fprintf(fp,"  ** declaration, fields 2.3.6 class 2 fail exit return code : %d\n",error);
        printf("  ** declaration, fields 2.3.6 class 2 fail exit return code : %d\n",error);
        }
   else
   {
        /* verify bit1, bit4, and bit5 will not be affected */
        words.bit1 = 0x1;               /* will occupy one bit */
        words.bit4 = 0x10;              /* turn off all the bits */
        words.bit5 = 0x100;             /* turn off all the bits */
        words.bit32 = 0xffffffff;
        if ( words.bit1 != 1 || words.bit4 != 0 || words.bit5 != 0) {
                fprintf(fp,"  ** declaration, fields 2.3.6-1 class 2 fail exit return code : %x\n",words);
                printf("  ** declaration, fields 2.3.6-1 class 2 fail exit return code : %x\n",words);
                }
        else
        if (    words.bit32 != (unsigned) 0xffffffff){
                fprintf(fp,"  ** declaration, fields 2.3.6-2 class 2 fail exit return code : %x\n",words.bit32);
                printf("  ** declaration, fields 2.3.6-2 class 2 fail exit return code : %x\n",words.bit32);
                }
        else
              {
                fprintf(fp,"  .. declaration, fields 2.3.6   class 2 pass\n");
                printf("  .. declaration, fields 2.3.6   class 2 pass\n");
                }
    }
    fclose(fp);
}
 
