/* The following test has been removed from the CCVS suite.  It tests
   whether variables are signed or unsigned.  However, since it uses
   a bitfield structure, the variables are always unsigned.  Kernighan
   and Ritchie state "fields are unsigned; they may be stored only in
   int's (or, equivalently, unsigned's)".  Since signed variables
   cannot be assigned, this test is invalid.
 
   Mindy Pheterson
   Nov. 21, 1989
 
*/
 
/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Fields                               */
/*                          Section  2.3                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/decl.2310. c                              */
/*  Revisions :             05/03/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify whether the compiler treats bitfields     */
/*                          as signed or unsigned.                           */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      This test includes qar331 written against UTX-32 1.0 Release.
        Problem description:  When a 32-bitfield declared as unsigned is
                compared with a signed constant, a true result is returned
                when a false is expected.  When a 32-bitfield declared as
                int is compared with an unsigned constant, the test returns
                a false result when a true result is expected. For UTX-32
                Release 1.0  bitfields are unsigned.
*/
 
#include <stdio.h>
#define TRUE 1
 
struct {
        int             bit32_in        :  32;
        unsigned        bit32_un        :  32;
} word;
main()
{        FILE *fp;
        int     a, b, c, d;
        int     sign=0, unsign=0;
        fp=fopen("decl_res bloc=y","a");
 
        word.bit32_in = 0xffffffff;
        word.bit32_un = 0xffffffff;
 
        /*  bitfields are compared to signed values to test
           if bitfields are signed.                          */
 
        a = word.bit32_in == 0xffffffff;
        c = word.bit32_un == 0xffffffff;     /* qar331 */
 
        /*  bitfields are compared to unsigned values to test
           if bitfields are unsigned.                        */
 
        b = word.bit32_in == ( unsigned ) 0xffffffff;  /* qar331 */
        d = word.bit32_un == ( unsigned ) 0xffffffff;
 
        if ( a && !c ) /*  if bitfields are signed */
                sign = TRUE;
 
        if (!b && d ) /*  if bitfields are unsigned */
                unsign = TRUE;
 
        if ( sign && !unsign )
        {
                fprintf(fp,"  !! declaration, fields 2.3.10 class 2\n");
                printf("  !! declaration, fields 2.3.10 class 2\n");
                fprintf(fp,"     Bitfields are signed.  Check documentation.\n");
                printf("     Bitfields are signed.  Check documentation.\n");
        }
        else
                if ( unsign && !sign )
                {
                        fprintf(fp,"  !! declaration, fields 2.3.10 class 2\n");
                        printf("  !! declaration, fields 2.3.10 class 2\n");
                        fprintf(fp,"     Bitfields are unsigned.  Check documenation.\n");
                        printf("     Bitfields are unsigned.  Check documenation.\n");
                }
                else
                {
                        fprintf(fp,"  ** declaration, fields 2.3.10 class 2 fail exit return code : %d%d%d%d\n",a, c, b, d );
                        printf("  ** declaration, fields 2.3.10 class 2 fail exit return code : %d%d%d%d\n",a, c, b, d );
 
                 }
 
}
