/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.2219.c                               */
/*  Revisions :             04/03/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the compiler will detect syntax      */
/*                          errors in structure declarations.                */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*       The following test was originally spr0219 written against UTX       */
/*       Release 2.0.  Problem description:  The compiler does not complain  */
/*                             when a semicolon is missing in a structure    */
/*                             declaration.                                  */
/*       This test is currently qar180 written against UTX-32 1.0 Release.   */
/*       Resolution:  The compiler overlooks the missing semicolon and       */
/*                    correctly interperts the user's meaning by interpert-  */
/*                    ing the right closing brace.  No compiler error is     */
/*                    returned and the program compiles correctly.  This     */
/*                    qar was resolved as an Enhancement Request (ER) due to */
/*                    the fact that the compiler should issue a warning      */
/*                    flagging the missing semicolon if it can correctly     */
/*                    interpert the program .                                */
/*****************************************************************************/
 
#include <stdio.h>
 
typedef struct {
        int tx_x;
        int tx_y;
        int tx_size;
} TXFIELD;
 
typedef struct {
        TXFIELD tr_file, tr_x, tr_y, tr_xsize, tr_ysize } TXRECT;
                                  /* missing semicolon ^ */
TXRECT r;
 
main ()
{
        FILE *fp;
        int i;
        fp=fopen("decl_res bloc=y","a");
        fprintf(fp,"declaration 2.2.1.9, warning should be issued\n");
        printf("declaration 2.2.1.9, warning should be issued\n");
        i = r.tr_ysize.tx_size ;
        fclose(fp);
}
