/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1.6                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  8/15/85                                          */
/*  Source File :           source/decl.22164.c                              */
/*  Revisions :             05/17/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          08/15/85    T. Aleksa     UTX-32 (1.2) Release   */
/*                          -- modified test due to protect bit violation    */
/*                                                                           */
/*  Description :           For an automatic structure that has a structure  */
/*                          as a member, verify that the members of the      */
/*                          member structure can be referenced.              */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      syntax          struct { type-specifier declarator;
                               struct { type-specifier declarator;
                                      }
                               struct { type-specifier declarator;
                                      }
                               struct { type-specifier declarator;
                                      struct { type-specifier declarator;
                                             struct { type-specifier declarator;
                                                    }
                                              }
                                      }
                        }
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail = 0;
 
main()
{
 FILE *fp;
 
        struct employee{
                int emp_no;
 
                struct name {
                        char *last;
                        char *first;
                        char mi;
                }emp_name;
 
                struct addr {
                        char *street;
                        char *city;
                        char *state;
                        int zip;
                }emp_adr;
 
                struct payroll {
                        int ss_number;
 
                        struct salary {
                                float payrate;
 
                                struct deductions {
                                        float fed;
                                        float FICA;
                                        float ins;
                                }emp_ded;
 
                                float hour_rate;
                        }emp_sal;
                }emp_pay;
        }emp_rec;
 
        struct employee *ptr;
 fp=fopen("decl_res bloc=y","a");
 
        ptr = &emp_rec;       /*  set up a pointer to the structure */
 
        /*  assign values to members  */
 
        emp_rec.emp_no = 2001;
 
        emp_rec.emp_name.last =  "Doe";
        emp_rec.emp_name.first = "John";
        emp_rec.emp_name.mi = 'A';
 
        emp_rec.emp_adr.street = "6901 West Sunrise Blvd";
        emp_rec.emp_adr.city = "Ft. Lauderdale";
        emp_rec.emp_adr.state = "FL";
        emp_rec.emp_adr.zip = 33313;
 
        emp_rec.emp_pay.ss_number = 137846901;
        emp_rec.emp_pay.emp_sal.payrate = 24000.00;
 
        emp_rec.emp_pay.emp_sal.emp_ded.fed = 236.50;
        emp_rec.emp_pay.emp_sal.emp_ded.FICA = 172.50;
        emp_rec.emp_pay.emp_sal.emp_ded.ins = 18.50;
 
        emp_rec.emp_pay.emp_sal.hour_rate = 12.50;
 
        /* Test 1 */
 
        if ( emp_rec.emp_no != 2001 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-1 class 2 fail exit return code : %d\n",emp_rec.emp_no );
                printf("  ** declaration, structures 2.2.1.6.4-1 class 2 fail exit return code : %d\n",emp_rec.emp_no );
        }
 
        /* Test 2 */
 
        if ( compare( ptr->emp_name.last, "Doe" ) )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-2 class 2 fail exit return code : %s\n",ptr->emp_name.last );
                printf("  ** declaration, structures 2.2.1.6.4-2 class 2 fail exit return code : %s\n",ptr->emp_name.last );
        }
 
        /* Test 3 */
 
        if ( compare( ptr->emp_name.first, "John" ) )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-3 class 2 fail exit return code : %s\n",ptr->emp_name.first );
                printf("  ** declaration, structures 2.2.1.6.4-3 class 2 fail exit return code : %s\n",ptr->emp_name.first );
        }
 
        /* Test 4 */
 
        if ( ptr->emp_name.mi != 'A' )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-4 class 2 fail exit return code : %s\n",ptr->emp_name.mi );
                printf("  ** declaration, structures 2.2.1.6.4-4 class 2 fail exit return code : %s\n",ptr->emp_name.mi );
        }
 
        /* Test 5 */
 
        if ( compare( ptr->emp_adr.street, "6901 West Sunrise Blvd" ) )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-5 class 2 fail exit return code : %s\n",ptr->emp_adr.street );
                printf("  ** declaration, structures 2.2.1.6.4-5 class 2 fail exit return code : %s\n",ptr->emp_adr.street );
        }
 
        /* Test 6 */
 
        if ( compare( ptr->emp_adr.city, "Ft. Lauderdale" ) )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-6 class 2 fail exit return code : %s\n",ptr->emp_adr.city );
                printf("  ** declaration, structures 2.2.1.6.4-6 class 2 fail exit return code : %s\n",ptr->emp_adr.city );
        }
 
        /* Test 7 */
 
        if ( compare( ptr->emp_adr.state, "FL" ) )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-7 class 2 fail exit return code : %s\n",ptr->emp_adr.state );
                printf("  ** declaration, structures 2.2.1.6.4-7 class 2 fail exit return code : %s\n",ptr->emp_adr.state );
        }
 
        /* Test 8 */
 
        if ( emp_rec.emp_adr.zip != 33313 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-8 class 2 fail exit return code : %d\n",emp_rec.emp_adr.zip );
                printf("  ** declaration, structures 2.2.1.6.4-8 class 2 fail exit return code : %d\n",emp_rec.emp_adr.zip );
        }
 
        /* Test 9 */
 
        if ( emp_rec.emp_pay.ss_number != 137846901 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-9 class 2 fail exit return code : %d\n",emp_rec.emp_pay.ss_number );
                printf("  ** declaration, structures 2.2.1.6.4-9 class 2 fail exit return code : %d\n",emp_rec.emp_pay.ss_number );
        }
 
        /* Test 10 */
 
        if ( emp_rec.emp_pay.emp_sal.payrate != 24000.00 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-10 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.payrate );
                printf("  ** declaration, structures 2.2.1.6.4-10 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.payrate );
        }
 
        /* Test 11 */
 
        if ( emp_rec.emp_pay.emp_sal.emp_ded.fed != 236.50 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-11 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.emp_ded.fed );
                printf("  ** declaration, structures 2.2.1.6.4-11 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.emp_ded.fed );
        }
 
        /* Test 12 */
 
        if ( emp_rec.emp_pay.emp_sal.emp_ded.FICA != 172.50 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-12 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.emp_ded.FICA);
                printf("  ** declaration, structures 2.2.1.6.4-12 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.emp_ded.FICA);
        }
 
        /* Test 13 */
 
        if ( emp_rec.emp_pay.emp_sal.emp_ded.ins != 18.50 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-13 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.emp_ded.ins );
                printf("  ** declaration, structures 2.2.1.6.4-13 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.emp_ded.ins );
        }
 
        /* Test 14 */
 
        if ( emp_rec.emp_pay.emp_sal.hour_rate != 12.50 )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.6.4-14 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.hour_rate );
                printf("  ** declaration, structures 2.2.1.6.4-14 class 2 fail exit return code : %f\n",emp_rec.emp_pay.emp_sal.hour_rate );
        }
 
        if ( !fail ){
                fprintf(fp,"  .. declaration, structures 2.2.1.6.4 class 2 pass\n");
                printf("  .. declaration, structures 2.2.1.6.4 class 2 pass\n");
                }
                fclose(fp);
}
 
/*      COMPARE:  function - compare two given strings
                  inputs   - two strings, s1 and s2
                  outputs  - == 0, if s1 is equal to s2
                              > 0, if s1 is greater than s2
                              < 0, if s1 is less than s2
*/
 
compare( s1, s2 )
 
char *s1, *s2;
{
        for( ; *s1 == *s2 ; s1++, s2++ )
                if ( *s1 == '\0' )
                        return 0;
        return( *s1 - *s2 );
}
