/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1.6                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.4                                         */
/*  Date :                  8/15/85                                          */
/*  Source File :           source/decl.22163.c                              */
/*                                                                           */
/*  Revisions :             05/16/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          05/18/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Added internal static structure.              */
/*                          08/15/85    T. Aleksa     UTX-32 1.2 Release     */
/*                          -- Modified test due to protect bit violation    */
/*                                                                           */
/*  Description :           For a structure that has a structure as a        */
/*                          member, verify  for static and external          */
/*                          structures that the members of the member        */
/*                          structure that are not explicitly initialized    */
/*                          are initialized to zero.                         */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      syntax          struct { type-specifier declarator;
                               struct { type-specifier declarator;
                                      }
                               struct { type-specifier declarator;
                                      }
                               }
 
                        struct { type-specifier declarator;
                               struct { type-specifier declarator;
                                      struct { type-specifier declarator;
                                             }
                                      }
                               }
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail= 0;
 
struct employee{
 
       int emp_no;
       struct name {
                char *last;
                char *first;
                char mi;
       }emp_name;
       struct addr {
                char *street;
                char *city;
                char *state;
                int zip;
        }emp_adr;
 
}emp_rec;
 
static struct payroll {         /* external static structure */
 
              int ss_number;
              struct salary {
                     float payrate;
                     struct deductions {
                            float fed;
                            float FICA;
                            float ins;
                     }emp_ded;
                     float hour_rate;
              }emp_salary;
 
}emp_pay;
 
struct employee *ptr;
 
main()
{
 FILE *fp;
 
static struct other {           /*  internal static structure */
              int phone;
              struct hiredate {
                     int mo;
                     int day;
                     int yr;
              }emp_hire;
              float vacation;
}emp_oth;
 
        ptr = &emp_rec;
 fp=fopen("decl_res bloc=y","a");
 
/* Test 1       -       Testing external structure emp_rec      */
 
        if ( emp_rec.emp_no != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-1 class 2 fail exit return code : %d\n", emp_rec.emp_no );
             printf("  ** declaration, structures 2.2.1.6.3-1 class 2 fail exit return code : %d\n", emp_rec.emp_no );
           }
 
/* Test 2 */
 
        if ( ptr->emp_name.last != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-2 class 2 fail exit return code : %d\n", ptr->emp_name.last );
             printf("  ** declaration, structures 2.2.1.6.3-2 class 2 fail exit return code : %d\n", ptr->emp_name.last );
           }
 
/* Test 3 */
 
        if ( ptr->emp_name.first != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-3 class 2 fail exit return code : %d\n", ptr->emp_name.first );
             printf("  ** declaration, structures 2.2.1.6.3-3 class 2 fail exit return code : %d\n", ptr->emp_name.first );
           }
 
/* Test 4 */
 
        if ( ptr->emp_name.mi != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-4 class 2 fail exit return code : %d\n", ptr->emp_name.mi );
             printf("  ** declaration, structures 2.2.1.6.3-4 class 2 fail exit return code : %d\n", ptr->emp_name.mi );
           }
 
/* Test 5 */
 
        if ( ptr->emp_adr.street != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-5 class 2 fail exit return code : %d\n", ptr->emp_adr.street );
             printf("  ** declaration, structures 2.2.1.6.3-5 class 2 fail exit return code : %d\n", ptr->emp_adr.street );
           }
 
/* Test 6 */
 
        if ( ptr->emp_adr.city != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-6 class 2 fail exit return code : %d\n", ptr->emp_adr.city );
             printf("  ** declaration, structures 2.2.1.6.3-6 class 2 fail exit return code : %d\n", ptr->emp_adr.city );
           }
 
/* Test 7 */
 
        if ( ptr->emp_adr.state != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-7 class 2 fail exit return code : %d\n", ptr->emp_adr.state );
             printf("  ** declaration, structures 2.2.1.6.3-7 class 2 fail exit return code : %d\n", ptr->emp_adr.state );
           }
 
/* Test 8 */
 
        if ( emp_rec.emp_adr.zip != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-8 class 2 fail exit return code : %d\n", emp_rec.emp_adr.zip );
             printf("  ** declaration, structures 2.2.1.6.3-8 class 2 fail exit return code : %d\n", emp_rec.emp_adr.zip );
           }
 
/* Test 9       -       Testing external static structure emp_pay */
 
        if ( emp_pay.ss_number != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-9 class 2 fail exit return code : %d\n", emp_pay.ss_number );
             printf("  ** declaration, structures 2.2.1.6.3-9 class 2 fail exit return code : %d\n", emp_pay.ss_number );
           }
 
/* Test 10 */
 
        if ( emp_pay.emp_salary.payrate != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-10 class 2 fail exit return code : %f\n", emp_pay.emp_salary.payrate );
             printf("  ** declaration, structures 2.2.1.6.3-10 class 2 fail exit return code : %f\n", emp_pay.emp_salary.payrate );
           }
 
/* Test 11 */
 
        if ( emp_pay.emp_salary.emp_ded.fed != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-11 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.fed );
             printf("  ** declaration, structures 2.2.1.6.3-11 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.fed );
           }
 
/* Test 12 */
 
        if ( emp_pay.emp_salary.emp_ded.FICA != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-12 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.FICA);
             printf("  ** declaration, structures 2.2.1.6.3-12 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.FICA);
           }
 
/* Test 13 */
 
        if ( emp_pay.emp_salary.emp_ded.ins != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-13 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.ins );
             printf("  ** declaration, structures 2.2.1.6.3-13 class 2 fail exit return code : %f\n", emp_pay.emp_salary.emp_ded.ins );
           }
 
/* Test 15      -       Begin testing internal static structure emp_oth */
 
        if ( emp_oth.phone != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-15 class 2 fail exit return code : %d\n", emp_oth.phone );
             printf("  ** declaration, structures 2.2.1.6.3-15 class 2 fail exit return code : %d\n", emp_oth.phone );
           }
 
/* Test 16 */
 
        if ( emp_oth.emp_hire.mo != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-16 class 2 fail exit return code : %d\n", emp_oth.emp_hire.mo );
             printf("  ** declaration, structures 2.2.1.6.3-16 class 2 fail exit return code : %d\n", emp_oth.emp_hire.mo );
           }
 
/* Test 17 */
 
        if ( emp_oth.emp_hire.day != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-17 class 2 fail exit return code : %d\n", emp_oth.emp_hire.day );
             printf("  ** declaration, structures 2.2.1.6.3-17 class 2 fail exit return code : %d\n", emp_oth.emp_hire.day );
           }
 
/* Test 18 */
 
        if ( emp_oth.emp_hire.yr != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-18 class 2 fail exit return code : %d\n", emp_oth.emp_hire.yr );
             printf("  ** declaration, structures 2.2.1.6.3-18 class 2 fail exit return code : %d\n", emp_oth.emp_hire.yr );
           }
 
/* Test 19 */
 
        if ( emp_oth.vacation != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, structures 2.2.1.6.3-19 class 2 fail exit return code : %f\n", emp_oth.vacation );
             printf("  ** declaration, structures 2.2.1.6.3-19 class 2 fail exit return code : %f\n", emp_oth.vacation );
           }
 
        if ( !fail ){
           fprintf(fp,"  .. declaration, structures 2.2.1.6.3 class 2 pass\n");
           printf("  .. declaration, structures 2.2.1.6.3 class 2 pass\n");
           }
           fclose(fp);
}
