/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.5                                */
/*  Product and Revision :  Unix 1.5                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  8/15/85                                          */
/*  Source File :           source/decl.22151.c                              */
/*                                                                           */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          05/14/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added types short int, long int, unsigned     */
/*                             int, unsigned short, unsigned long, unsigned  */
/*                             char, and long float.                         */
/*                          08/15/85    T. Aleksa  UTX-32 1.2 Release        */
/*                          -- modified test due to protect bit violation    */
/*                                                                           */
/*  Description :           For structure members that are arrays of the     */
/*                          basic types : Verify that space is allocated     */
/*                          correctly for the array.                         */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*
                   syntax    struct { type-specifier declarator;
                                    }
                             struct { type-specifier declarator : const expr;
                                      type-specifier : const expr;
                                    }
*/
 
#include <stdio.h>
#define LINE 100
#define TRUE 1
 
int fail = 0;
typedef  char  *typedef_name;
typedef  int   def_bit;
 
 char buf[256];
 struct key {
             char *keyword[LINE];
             int   key1[1][2];
             short key2[2] ;
             long  key3[3] ;
             unsigned key4[4] ;
             float key5[5][5] ;
             double key6[6][6] ;
             short int key7[7][7] ;
             long int key8[8][8] ;
             unsigned int key9[9] ;
             unsigned short key10[10] ;
             unsigned long key11[11] ;
             unsigned char *key12[LINE] ;
             long float key13[13][13] ;
             typedef_name keyline[LINE] ;
             struct field {
                           def_bit bit : 1;     /* used typedef definition */
                           def_bit     : 1;
                          };
           } table[] = buf  ;
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
 
        table->keyword[0] = "keyword";
        table->keyline[1] = "keyline";
        table->key1[0][1] = 1;
        table->key2[0] = 2;
        table->key7[3][5] = 7;
        table->key8[4][4] = 8;
        table->key9[1] = 9;
        table->key10[6] = 10;
        table->key11[7] = 11;
        table->key12[9] = "key12";
        table->key13[12][12] = 13.0;
    if ( table->key1[0][1] != 1 || table->key2[0] != 2 ||
                table->key2[1] != 0 || table->key3[2] != 0 ||
                table->key4[3] != 0 || table->key5[4][4] != 0 ||
                table->key6[5][5] != 0 || table->key7[3][5] != 7 ||
                table->key8[4][4] != 8 || table->key9[1] != 9    ||
                table->key10[6] !=  10 || table->key11[7] != 11  ||
                table->key13[12][12] != 13.0  )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.1-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
          printf("  ** declaration, structures 2.2.1.5.1-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
        }
     if ( compare(table->keyword[0],"keyword") )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.1-2 class 2 fail exit return code : %s\n",table->keyword[0]);
          printf("  ** declaration, structures 2.2.1.5.1-2 class 2 fail exit return code : %s\n",table->keyword[0]);
        }
     if ( table->keyline[0] != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.1-3 class 2 fail exit return code : %d\n",table->keyline[0]);
          printf("  ** declaration, structures 2.2.1.5.1-3 class 2 fail exit return code : %d\n",table->keyline[0]);
        }
     if ( compare(table->keyline[1],"keyline"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.1-4 class 2 fail exit return code : %s\n",table->keyline[1]);
          printf("  ** declaration, structures 2.2.1.5.1-4 class 2 fail exit return code : %s\n",table->keyline[1]);
        }
     if ( compare(table->key12[9],"key12"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.1-5 class 2 fail exit return code : %s\n",table->keyline[1]);
          printf("  ** declaration, structures 2.2.1.5.1-5 class 2 fail exit return code : %s\n",table->keyline[1]);
        }
 
if (!fail){
        fprintf(fp,"  .. declaration, structures 2.2.1.5.1 class 2 pass\n");
        printf("  .. declaration, structures 2.2.1.5.1 class 2 pass\n");
        };
        fclose(fp);
 
}
 
compare(s1,s2)                  /* compare two strings, and return a zero
                                   if they are equal to each other
                                */
char *s1,*s2;
{       for ( ; *s1 == *s2 ; s1++,s2++ )
                if ( *s1 == '\0' )
                        return (0);
        return ( *s1 - *s2 );
}
