/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Type Void                            */
/*                          Section  2.10                                    */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  6/20/84                                          */
/*  Source File :           source/decl.2102.c                               */
/*  Revisions :             06/15/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the compiler can construct a         */
/*                          pointer to a void function.                      */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.210.j                             */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/* This test is qar397 written against UTX-32 (1.0) Release.
   Problem Description:  The compiler will not allow a pointer construct to
           a void function.  Error message returned is operands of = have
           incompatible types.
*/
 
#include <stdio.h>
 
FILE *fp;
main()
{
void f(),(*pf)();
fp=fopen("decl_res bloc=y","a");
 
        pf = f;
        (*pf)();
        fclose(fp);
}
void f()
{
        fprintf(fp,"  .. declartion, void 2.10.2 class 1 pass\n");
        printf("  .. declartion, void 2.10.2 class 1 pass\n");
}
 
 
