/* optab1.h */
/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 *	Gould, Inc. Base Register Assembler
 */

/*	@(#) (Gould) $Header: optab1.h,v 5.5 89/05/12 12:36:40 pcc Rel-3_0 $;	*/

/*
 *  header file for building the Gould, Inc. UTX assembler opcode table
 *  this file contains enough declarations and defines from struct.h
 *  plus a prototype of the optable array so that builder can produce
 *  a header file amenable to inclusion in the assembler.
 *  because the opcodes are being processed textually, the prototype
 *  used here is structured slightly differently than in struct.h .
 *  see the opcode structure declaration.
 *  the order of appearance of the opcodes affects the order that they
 *  are chained into optable.h (the REAL opcode table). the ordering
 *  chosen here is somewhat optimized for assembler execution speed.
 *  CHANGING THIS ORDERING MAY RESULT IN PERFORMANCE DEGRADATION.
 */

#ifdef LDPOOL
#ifndef POOL
#define POOL 1
#endif /* POOL */
#endif /* LDPOOL */

#ifdef GOTENUM
enum SEGS
{
#ifdef POOL
    S_text, S_data, S_bss,
    S_Lconstant, S_Dconstant, S_Wconstant, S_Xconstant, S_Hconstant,
#else /* not POOL */
    S_text, S_data, S_bss, S_constant,
#endif /* POOL */
    S_fartext, S_fardata, S_farbss,
    S_dat2, S_fdat2, S_ftex2
    last_SEGS			/* this value MUST be the last */
};
#else

#define enum
typedef int SEGS;
#define S_text	0
#define S_data	1
#define S_bss	2
#ifdef POOL
#define S_Lconstant 3
#define S_Dconstant 4
#define S_Wconstant 5
#define S_Xconstant 6
#define S_Hconstant 7
#define S_fartext 8
#define S_fardata 9
#define S_farbss 10
#define S_dat2	11
#define S_fdat2	12
#define S_ftex2	13
#define last_SEGS 14
#else /* not POOL */
#define S_constant 3
#define S_fartext 4
#define S_fardata 5
#define S_farbss 6
#define S_dat2	7
#define S_fdat2	8
#define S_ftex2	9
#define last_SEGS 10
#endif /* POOL */

#endif

/* operand handler declarations and definitions */
/* note the declaration of o2data as a char *, not an int *() */
/* this is due to requiring the name, not a pointer, here */

struct      opcode
{
    char	*oname;		/* opcode mnemonic */
    short	ocode;		/* opcode (reg fields zeroed) for mem->reg */
    short	ocoderr;	/* opcode, reg->reg */
    short	ocoderm;	/* opcode, reg->mem */
    short	ocodeim;	/* opcode, immed->reg */
    short	olength;	/* byte, half, word, long operation */
    short	otype;		/* addressing and operation type data */
    short	onopnd;		/* number of operands (UNKN if infinite) */
    int		o1data;		/* first pass processing rules */
    char	*o2data;	/* second pass procedure */
};

/* olength values */
#define NONE 		0
#define BYTE 		1
#define HALF 		2
#define WORD		3
#define LONG		4

/* otype values - must be bit fields due to multi address mode ops */
#define O_CALLFCN 	0x0	/* essentially a place holder */
#define O_PSEUDO 	0x1	/* pseudo op */
#define O_REGREG	0x2	/* register source, register destination */
#define O_REGMEM	0x4	/* register source, memory destination */
#define O_MEMREG	0x8	/* memory source, register destination */
#define O_SHIFT		0x10
#define O_IMMED		0x20	/* immediate mode instruction exists */
#define O_IO		0x40
#define O_INTR		0x80

#define O_VAR		0x100	/* opcode has non-standard length */
#define	O_HALF		0x200	/* half word instruction alignment */
#define	O_WORD		0x400	/* full word instruction alignment */
#define O_RRHALF	0x800	/* O_WORD unless R,R, then O_HALF */

/* o1data values */
#define M 0x1		/* memory */
#define	R 0x2		/* anyregister */
#define	E 0x4		/* even register */
#define B 0x8		/* base register */
#define I 0x10		/* immediate */
#define A 0x20		/* any operand */

/* operand 1 thru 4 shifts in o1data */
#define O1(n) (n)
#define O2(n) |((n)<<8)
#define O3(n) |((n)<<16)
#define O4(n) |((n)<<24)

/* used in onopnd field for unknown number of operands */
#define UNKN	 	0xFFFF

/*
*  builder scans this table sequentially, so chaining on frequently
*  used opcodes can be avoided by placing them first.
*/
struct opcode optable[] =
{
	/* oft used pseudo ops - use ocode field for variants */
	".align", 0, 0,0,0, NONE, O_PSEUDO, 1, O1(M), "op_align",
	".ascii", 0, 0,0,0, NONE, O_PSEUDO, 1, O1(M), "op_ascii",
	".bf", 0, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_be",
	".byte", 1, 0,0,0, NONE, O_PSEUDO, UNKN, O1(M | I), "op_setmem",
	".comm", 0, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".data", (int) S_data, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".ef", 1, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_be",
	".globl", 0, 0,0,0, NONE, O_PSEUDO, 1, O1(M), "op_globl",
	".half", 2, 0,0,0, NONE, O_PSEUDO, UNKN, O1(M | I), "op_setmem",
	".lcomm", 1, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".long", 8, 0,0,0, NONE, O_PSEUDO, UNKN, O1(M | I), "op_setmem",
	".set", 0, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_set",
	".space", 0,0,0,0, NONE, O_PSEUDO, 0, O1(M), "op_res",
	".text", (int) S_text, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".using", 0, 0,0,0, NONE, O_PSEUDO, 2, O1(B) O2(M), "op_base",
	".word", 4, 0,0,0, NONE, O_PSEUDO, UNKN, O1(M | I), "op_setmem",

	/* assembler opcodes (C compiler required) */

#ifdef GOULD_PN
	"movb", 0xAC08, 0, 0xD408,0, BYTE, O_WORD + O_VAR,
	    3, O1(I | M | R) O2(M | R) O3(M), "op_mov",
	"movh", 0xAC00, 0, 0xD400,0, HALF, O_WORD + O_VAR,
	    3, O1(I | M | R) O2(M | R) O3(M), "op_mov",
	"movw", 0xAC00, 0x2C00, 0xD400, 0xC800, WORD,
	    O_RRHALF + O_VAR,
	    3, O1(I | M | R | B) O2(M | R | B) O3(M), "op_mov",
	"movl", 0xAC00, 0, 0xD400,0, LONG, O_RRHALF + O_VAR,
	    3, O1(I | M | E) O2(M | E) O3(M), "op_mov",
	"movf", 0xAC00, 0x2C00, 0xD400, 0xC800, WORD,	/* like movw */
	    O_RRHALF + O_VAR,
	    3, O1(I | M | R | B) O2(M | R | B) O3(M), "op_mov",
	"movd", 0xAC00, 0, 0xD400,0, LONG, O_RRHALF + O_VAR, /* like movl */
	    3, O1(I | M | E) O2(M | E) O3(M), "op_mov",
	"movea", 0x5808, 0,0,0, WORD, O_WORD, 2,	/* LA or LABR */
	    O1(M) O2(R | B), "op_off",		/* code for gpr different */

	"addb", 0xB808, 0, 0xE808, 0, BYTE, O_WORD, 2,
	    O1(I | M | R) O2(M | R), "op_arith",
	"addh", 0xB800, 0, 0xE800, 0xC801, HALF, O_WORD, 2,
	    O1(I | M | R) O2(M | R), "op_arith",
	"addw", 0xB800, 0x3800, 0xE800, 0xC801, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(M | R), "op_arith",
	"addl", 0xB800, 0, 0xE800,0, LONG, O_WORD, 2,
	    O1(I | M | E) O2(M | E), "op_arith",
	"addf", 0xE008, 0x3801, 0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"addd", 0xE008, 0x3809,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	"andb", 0x8408, 0,0,0, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"andh", 0x8400, 0,0,0, HALF, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"andw", 0x8400, 0x0400, 0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"andl", 0x8400, 0,0,0, LONG, O_WORD, 2, O1(I | M) O2(E), "op_arith",

	/* AB[MR], ZB[MR], SB[MR], TB[MR] */
	"bclrb", 0x9C08, 0x1804,0,0, BYTE, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"bclrh", 0x9C08, 0x1804,0,0, HALF, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"bclrw", 0x9C08, 0x1804,0,0, WORD, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"bsetb", 0x9808, 0x1800,0,0, BYTE, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"bseth", 0x9808, 0x1800,0,0, HALF, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"bsetw", 0x9808, 0x1800,0,0, WORD, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"btstb", 0xA408, 0x180C,0,0, BYTE, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"btsth", 0xA408, 0x180C,0,0, HALF, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"btstw", 0xA408, 0x180C,0,0, WORD, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",
	"baddw", 0xA008, 0x1808,0,0, WORD, O_VAR, 2,
	    O1(I) O2(M | R), "op_bits",

	"cmpb", 0x9008, 0,0,0, BYTE, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"cmph", 0x9000, 0,0, 0xC805, HALF, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"cmpw", 0x9000, 0x1000, 0, 0xC805, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"cmpl", 0x9000, 0,0,0, LONG, O_WORD , 2,
	    O1(I | M) O2(E), "op_arith",
	"cmpf", 0x9000, 0x1000, 0, 0xC805, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"cmpd", 0x9000, 0,0,0, LONG, O_WORD , 2,
	    O1(I | M) O2(E), "op_arith",

	/* cpl is TRC, which is O_REGREG only */
	"cplw", 0x2C03, 0,0,0, WORD, O_HALF , 2, O1(R) O2(R), "op_rroper",

	/* float and fix instructions plus char to word */
	/* note ocode and O_VAR on cvtcw */
	"cvtcw", 0xFFFF, 0,0,0, WORD, O_VAR,  1, O1(R), "op_cvtcw",
	"cvtdl", 0x380D, 0,0,0, WORD, O_HALF, 2, O1(E) O2(E), "op_rroper",
	"cvtfw", 0x3805, 0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_rroper",
	"cvtld", 0x380F, 0,0,0, WORD, O_HALF, 2, O1(E) O2(E), "op_rroper",
	"cvtwf", 0x3807, 0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_rroper",

	"divb", 0xC408, 0,0,0, BYTE, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"divh", 0xC400, 0,0, 0xC804, HALF, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"divw", 0xC400, 0x380A,0, 0xC804, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(E), "op_arith",
	"divf", 0xE400, 0x3804,0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"divd", 0xE400, 0x380C,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",
#ifndef OLDCALL
	"enter", 0xFFFE, 0, 0, 0, NONE, O_VAR, 2, O1(I | M) O2(I | M),
	    "op_enter",
	"entry", 0xFFFC, 0, 0, 0, NONE, O_VAR, 1, O1(M), "op_entry",
#endif /* OLDCALL */

	/* file  is LF, LFBR, STF, or STFBR */
	/* note: opcodes are for regs. for base reg, it's op|8 */
	"file", 0xCC00, 0, 0xDC00, 0, WORD, O_WORD, 2,
	    O1(M | R | B) O2(M | R | B), "op_file",

	/* func is load R3 followed by branch and link */
	"func", 0xF880, 0,0,0, NONE, O_VAR, 2,
	    O1(I) O2(M), "op_func",

	/* reload is really a pseudo to conditionally load base register 6 */
	"reload", 0x5C00, 0,0,0, NONE, O_VAR, 1, O1(B), "op_reload",

	/* note use of both BCF and BCT */
	"jmp", 0xEC00, 0,0,0, WORD, O_VAR, 1, O1(M|R), "op_jmp",
	"jbn", 0xEC80, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jov", 0xEC80, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jbz", 0xF080, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jnov", 0xF080, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jeq", 0xEE00, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jge", 0xEE80, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jgt", 0xED00, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jle", 0xEF00, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jlt", 0xED80, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jne", 0xF200, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jbt", 0xEC80, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jbf", 0xF080, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jany", 0xEF80, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jnany",0xF380, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jsr", 0xF880, 0,0,0, WORD, O_WORD, 1, O1(M), "op_jmp",
	"bl" , 0xF880, 0,0,0, WORD, O_WORD, 1, O1(M), "op_jmp",
	"jft", 0xF000, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
					/* BFT - requires r4 */
	"switch", 0xFFFB, 0,0,0, WORD, O_VAR, 1, O1(M), "op_switch",
	"case", 0xFFFA, 0,0,0, WORD, O_VAR, 1, O1(M), "op_case",

	"mulb", 0xC008, 0,0,0, BYTE, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"mulh", 0xC000, 0,0, 0xC803, HALF, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"mulw", 0xC000, 0x3802, 0, 0xC803, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(E), "op_arith",
	"mulf", 0xE408, 0x3806, 0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"muld", 0xE408, 0x380E, 0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	/* neg is load negative, note no O_REGMEM */
	/* negw with O_REGREG is TRN */
	"negb", 0xB408, 0,0,0, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"negh", 0xB400, 0,0,0, HALF, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"negw", 0xB400, 0x2C04, 0, 0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"negl", 0xB400, 0,0,0, LONG, O_WORD, 2, O1(I | M) O2(E), "op_arith",

	"halt", 0x0000, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"wait", 0x0001, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"nop",  0x0002, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",

	"orb", 0x8808, 0,0,0, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"orh", 0x8800, 0,0,0, HALF, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"orw", 0x8800, 0x0800, 0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"orl", 0x8800, 0,0,0, LONG, O_WORD, 2, O1(I | M) O2(E), "op_arith",
#ifndef OLDCALL
	"retn", 0xFFFD, 0, 0, 0, NONE, O_VAR, 0, 0, "op_retn",
#endif /* OLDCALL */

	/* all shift instructions */
	/* the reg-reg shifts require O_SHIFT + O_VAR for PowerNode */
	"rotlw", 0x2440, 0,0,0, WORD, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"rotrw", 0x2400, 0,0,0, WORD, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"aslw", 0x1C40, 0,0,0, WORD, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"asll", 0x2040, 0,0,0, LONG, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(E), "op_shift",
	"asrw", 0x1C00, 0,0,0, WORD, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"asrl", 0x2000, 0,0,0, LONG, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(E), "op_shift",
	"lslw", 0x1C60, 0,0,0, WORD, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"lsll", 0x2060, 0,0,0, LONG, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(E), "op_shift",
	"lsrw", 0x1C20, 0,0,0, WORD, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"lsrl", 0x2020, 0,0,0, LONG, O_SHIFT + O_VAR, 2,
	    O1(I | R) O2(E), "op_shift",

	/* ES instruction */
	"sign", 0x0004, 0,0,0, WORD, O_HALF, 1, O1(E), "op_rroper",

	"subb", 0xBC08, 0,0,0, BYTE, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"subh", 0xBC00, 0,0, 0xC802, HALF, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"subw", 0xBC00, 0x3C00,0,0xC802, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"subl", 0xBC00, 0,0,0, LONG, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"subf", 0xE000, 0x3803,0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"subd", 0xE000, 0x380B,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	"subea", 0x5800, 0,0,0, NONE, O_WORD, 2, O1(M) O2(B), "op_off",

	/* xchg is XCR, or XCBR */
	"xchg", 0x2C00, 0,0,0, WORD, O_HALF, 2,
	    O1(B | R) O2(B | R), "op_xchg",

	"xorb", 0x8C08, 0,0,0, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"xorh", 0x8C00, 0,0,0, HALF, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"xorw", 0x8C00, 0x0C00,0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"xorl", 0x8C00, 0,0,0, LONG, O_WORD, 2, O1(I | M) O2(E), "op_arith",
/* the less used pseudo ops go here */
	".addr", 0, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_addr",
	".bss", (int) S_bss, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".bvalue", 0, 0,0,0, NONE, O_PSEUDO, 2, O1(B) O2(M), "op_base",
#ifdef POOL
	".const", (int) S_Lconstant, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
#else /* not POOL */
	".const", (int) S_constant, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
#endif /* POOL */
	".far", 1, 0,0,0, NONE, O_PSEUDO, 0, O1(M), "op_nearfar",
	".farbss", (int) S_farbss, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".fardata", (int) S_fardata, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".farlcomm", 3, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".gcomm", 4, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".dpool", 5, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".bpool", 6, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".fartext", (int) S_fartext, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".near", 0, 0,0,0, NONE, O_PSEUDO, 0, O1(M), "op_nearfar",
	".stabd", 1,0,0,0, NONE, O_PSEUDO, 3, O1(M) O2(M) O3(M), "op_stab",
	".stabn", 2,0,0,0, NONE, O_PSEUDO, 4,
	    O1(M) O2(M) O3(M) O4(M), "op_stab",
	".stabs", 0,0,0,0, NONE, O_PSEUDO, 5,
	    O1(M) O2(M) O3(M) O4(M), "op_stab",
	".stamp", 0,0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_stamp",

/*
*  system operation opcodes. these ops will be used very infrequently,
*  and so are placed in the table to minimize search time for others.
*/

/*	mne,   mr,    rr, rm, ir,  len,   type, #opand, pass1,    pass2	*/

	"svc", 0xC806, 0,  0,  0, WORD, O_WORD, 2, O1(I)O2(I), "op_svc",

	"ei",  0xFC00, 0,  0,  0, WORD, O_WORD, 1,      O1(I), "op_intr",
	"ri",  0xFC02, 0,  0,  0, WORD, O_WORD, 1,      O1(I), "op_intr",
	"ai",  0xFC03, 0,  0,  0, WORD, O_WORD, 1,      O1(I), "op_intr",
	"di",  0xFC01, 0,  0,  0, WORD, O_WORD, 1,      O1(I), "op_intr",
	"dai", 0xFC04, 0,  0,  0, WORD, O_WORD, 1,      O1(I), "op_intr",

	"bei", 0x0006, 0,  0,  0, NONE, O_HALF, 0,      0, "op_zero",
	"uei", 0x0007, 0,  0,  0, NONE, O_HALF, 0,      0, "op_zero",

	"lpsd",   0xF980, 0,  0,  0, WORD, O_WORD, 1,	O1(M), "op_mem",
	"lpsdcm", 0xFA80, 0,  0,  0, WORD, O_WORD, 1,	O1(M), "op_mem",
	"lear",   0x8000, 0,  0,  0, WORD, O_WORD, 2, O1(M)O2(R), "op_arith",
	"movear", 0x8000, 0,  0,  0, WORD, O_WORD, 2, O1(M)O2(R), "op_arith",

	"setcpu", 0x2c09, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"rdsts",  0x0009, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"tccr",   0x2804, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"trcc",   0x2805, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"trsw",   0x2800, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"tpcbr",  0x280c, 0,  0,  0, NONE, O_HALF, 1,   O1(B), "op_rroper",
	"rpswt",  0x040b, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"cmc",    0x040a, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"smc",    0x0407, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",

	/* memory management instructions */
	"sipu",   0x000A, 0,  0,  0, NONE, O_HALF, 0,   0, "op_zero",
	"sea",    0x000D, 0,  0,  0, NONE, O_HALF, 0,   0, "op_zero",
	"cea",    0x000F, 0,  0,  0, NONE, O_HALF, 0,   0, "op_zero",
	"lmap",   0x2c07, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"tmapr",  0x2c0a, 0,  0,  0, NONE, O_HALF, 2,
	    O1(R) O2(R), "op_rroper",

	"sacz",   0x1008, 0,  0,  0, NONE, O_HALF, 2,
	    O1(R) O2(R), "op_rroper",
	"trsc",   0x2c0e, 0,  0,  0, NONE, O_HALF, 2,
	    O1(R) O2(R), "op_rroper",
	"tscr",   0x2c0f, 0,  0,  0, NONE, O_HALF, 2,
	    O1(R) O2(R), "op_rroper",
	"lcs",    0x0003, 0,  0,  0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"rnd",    0x0005, 0,  0,  0, NONE, O_HALF, 1,   O1(E), "op_rroper",

	/* branch and increment instructions */
	"jib",	0xF400,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",
	"jih",	0xF420,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",
	"jiw",	0xF440,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",
	"jil",	0xF460,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",

	    /* mnemonic shows D field */
	"bct7", 0xEF80,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf2", 0xF100,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf3", 0xF180,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf5", 0xF280,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf6", 0xF300,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf7", 0xF380,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",

	"ret",  0x280E,0,0,0, NONE, O_HALF, 0, 0, "op_zero",

	/* I/O instructions */
	"td",	  0xFC05,0,0,0,	     WORD, O_WORD, 2, O1(M) O2(M), "op_iodev",
	"cd",	  0xFC06,0,0,0,	     WORD, O_WORD, 2, O1(M) O2(M), "op_iodev",
	"sio",	  0xFC17,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),	"op_io",
	"tio",	  0xFC1F,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),	"op_io",
	"stpio",  0xFC27,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),	"op_io",
	"rschnl", 0xFC2F,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),	"op_io",
	"hio",	  0xFC37,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),	"op_io",
	"grio",	  0xFC3F,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),	"op_io",
	"rsctl",  0xFC47,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),	"op_io",
	"eci",	  0xFC67,0,0,0,	     WORD, O_WORD, 1,	O1(M|R|I),	"op_io",
	"dci",	  0xFC6f,0,0,0,	     WORD, O_WORD, 1,	O1(M|R|I),	"op_io",
	"aci",	  0xFC77,0,0,0,	     WORD, O_WORD, 1,	O1(M|R|I),	"op_io",
	"daci",   0xFC7f,0,0,0,	     WORD, O_WORD, 1,	O1(M|R|I),	"op_io",

	"exm",  0xA800,      0,0,0,  WORD, O_WORD, 1, O1(M), "op_mem",
	"exr",  0xC807, 0x0000,0,0,  WORD, O_WORD, 1, O1(R), "op_ex",
	"exrr", 0xC807, 0x0002,0,0,  WORD, O_WORD, 1, O1(R), "op_ex",

	/* writable control store instructions, use at own risk! */
	"ecwcs", 0xFC4F,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),     "op_io",
	"wcwcs", 0xFC5F,0,0,0,	     WORD, O_WORD, 1,   O1(M|R|I),     "op_io",
	"rwcs",  0x000B,0,0,0,	     NONE, O_HALF, 2, O1(R) O2(R), "op_rroper",
	"wwcs",  0x000C,0,0,0,	     NONE, O_HALF, 2, O1(R) O2(R), "op_rroper",
    /* jwcs needs a relocatable address? use different routine if not */
	"jwcs", 0xFA08,0,0,0,	     WORD, O_WORD, 1,	    O1(M),    "op_mem",

	"dae", 0x000E, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"eae", 0x0008, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
#endif /* GOULD_PN */






#ifdef GOULD_NP1
	"movb", 0xB408, 0, 0xD408,0, BYTE, O_WORD + O_VAR,
	    3, O1(I | M | R) O2(M | R) O3(M), "op_mov",
	"movh", 0xB400, 0, 0xD400,0, HALF, O_WORD + O_VAR,
	    3, O1(I | M | R) O2(M | R) O3(M), "op_mov",
	"movw", 0xB400, 0x2C00, 0xD400, 0xF800, WORD,
	    O_RRHALF + O_VAR,
	    3, O1(I | M | R | B) O2(M | R | B) O3(M), "op_mov",
	"movl", 0xB400, 0, 0xD400,0, LONG, O_WORD + O_VAR,
	    3, O1(I | M | E) O2(M | E) O3(M), "op_mov",
	"movf", 0xB400, 0x2C00, 0xD400, 0xF800, WORD,	/* just like movw */
	    O_RRHALF + O_VAR,
	    3, O1(I | M | R | B) O2(M | R | B) O3(M), "op_mov",
	"movd", 0xB400, 0, 0xD400,0, LONG, O_WORD + O_VAR, /* just like movl */
	    3, O1(I | M | E) O2(M | E) O3(M), "op_mov",
	"movea", 0x5808, 0,0,0, WORD, O_WORD, 2,	/* LA or LABR */
	    O1(M) O2(R | B), "op_off",		/* code for gpr is 0x5000 */

	/* LIL instruction */
	"movil", 0xF80B, 0,0,0, WORD, O_WORD, 2, O1(I) O2(R), "op_lil",
#ifdef NEW_BASEREG_INST
	/* NEW BASE REGISTER instructions */
	"movilb", 0xF80F, 0,0,0, WORD, O_WORD, 2, O1(I) O2(B), "op_lilbr",
	"orib", 0xF80C, 0,0,0, WORD, O_WORD, 2, O1(I) O2(B), "op_oibr",
	"adib", 0xF80D, 0,0,0, WORD, O_WORD, 2, O1(I) O2(B), "op_adibr",
#endif /* NEW_BASEREG_INST */

	/* move physical same as movs */
#ifndef RETIRED
	"movbp", 0x9008, 0, 0x9408,0, BYTE, O_WORD,
	    2, O1(M | R) O2(M | R), "op_mov",
#endif /* NOT RETIRED */
	"movhp", 0x9000, 0, 0x9400,0, HALF, O_WORD,
	    2, O1(M | R) O2(M | R), "op_mov",
	"movwp", 0x9000, 0, 0x9400,0, WORD, O_WORD,
	    2, O1(M | R) O2(M | R), "op_mov",
	"movlp", 0x9000, 0, 0x9400,0, LONG, O_WORD,
	    2, O1(M | E) O2(M | E), "op_mov",

	"moveap", 0x5008, 0,0,0, WORD, O_WORD, 2,	/* LPA */
	    O1(M) O2(R), "op_off",

	"movabs", 0x2C01, 0,0,0, WORD, O_HALF,2,
	    O1(R) O2(R),"op_rroper",
	"movabd", 0x2C09, 0,0,0, LONG, O_HALF,2,
	    O1(E) O2(E),"op_rroper",

	"movbs", 0xEC08, 0,0,0, BYTE, O_WORD,
	    2, O1(M) O2(R), "op_mov",

	"addb", 0xC808, 0, 0xE808, 0, BYTE, O_WORD, 2,
	    O1(I | M | R) O2(M | R), "op_arith",
	"addh", 0xC800, 0, 0xE800, 0xF801, HALF, O_WORD, 2,
	    O1(I | M | R) O2(M | R), "op_arith",
	"addw", 0xC800, 0x3800, 0xE800, 0xF801, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(M | R), "op_arith",
	"addl", 0xC800, 0, 0xE800,0, LONG, O_WORD, 2,
	    O1(I | M | E) O2(M | E), "op_arith",
	"addf", 0xE008, 0x3801, 0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"addd", 0xE008, 0x3809,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	"andb", 0x8408, 0,0,0xF808, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_logic",
	"andh", 0x8400, 0,0,0xF808, HALF, O_WORD, 2, O1(I | M) O2(R), "op_logic",
	"andw", 0x8400, 0x0400, 0,0xF808, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_logic",
	"andl", 0x8400, 0,0,0, LONG, O_WORD, 2, O1(I | M) O2(E), "op_arith",

	/* AB[MR], ZB[MR], SB[MR], TB[MR] were for CONCEPT/32 */
	/* No more bit-in-register instructions and ABM replaced */
	/* by the INCM instruction */
	"bclrb", 0xAC00, 0,0,0, BYTE, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"bclrh", 0xAC00, 0,0,0, HALF, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"bclrw", 0xAC00, 0,0,0, WORD, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"bsetb", 0xAC08, 0,0,0, BYTE, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"bseth", 0xAC08, 0,0,0, HALF, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"bsetw", 0xAC08, 0,0,0, WORD, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"btstb", 0xA808, 0,0,0, BYTE, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"btsth", 0xA808, 0,0,0, HALF, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"btstw", 0xA808, 0,0,0, WORD, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"baddw", 0xA000, 0,0,0, WORD, O_WORD, 2,
	    O1(I) O2(M), "op_incm",

	"zsema", 0x9C00, 0,0,0, WORD, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"ssema", 0x9C08, 0,0,0, WORD, O_WORD, 2,
	    O1(I) O2(M), "op_bits",
	"tsema", 0x9808, 0,0,0, WORD, O_WORD, 2,
	    O1(I) O2(M), "op_bits",

	"cmpb", 0x8008, 0,0,0, BYTE, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"cmph", 0x8000, 0,0, 0xF805, HALF, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"cmpw", 0x8000, 0x1000, 0, 0xF805, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"cmpl", 0x8000, 0x1400,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",
	"cmpf", 0x8000, 0x1000, 0, 0xF805, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"cmpd", 0x8000, 0x1400,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	/* cpl is TRC, which is O_REGREG only */
	"cplw", 0x2C03, 0,0,0, WORD, O_HALF , 2, O1(R) O2(R), "op_rroper",

	/* float and fix instructions plus char to word */
	/* note ocode and O_VAR on cvtcw */
	"cvtcw", 0xFFFF, 0,0,0, WORD, O_VAR,  1, O1(R), "op_cvtcw",
	"cvtdl", 0x380D, 0,0,0, WORD, O_HALF, 2, O1(E) O2(E), "op_rroper",
	"cvtfw", 0x3805, 0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_rroper",
	"cvtld", 0x380F, 0,0,0, WORD, O_HALF, 2, O1(E) O2(E), "op_rroper",
	"cvtwf", 0x3807, 0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_rroper",

	"divb", 0xC408, 0,0,0, BYTE, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"divh", 0xC400, 0,0, 0xF804, HALF, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"divw", 0xC400, 0x380A,0, 0xF804, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(E), "op_arith",
	"divf", 0x9800, 0x1401,0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"divd", 0x9800, 0x1402,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	/* NP1 floating point reciprocal */
	"rff", 0xE400, 0,0,0, WORD, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"rfd", 0xE400, 0,0,0, LONG, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"rrff", 0, 0x0C0E,0,0, LONG, O_HALF, 1,
	    O1(R), "op_rr_recip",
	"rrfd", 0, 0x0C0F,0,0, LONG, O_HALF, 1,
	    O1(E), "op_rr_recip",

#ifndef RETIRED
	/* file  is LF, LFBR, STF, or STFBR */
	/* note: opcodes are for regs. for base reg, it's op|8 */
	"file", 0xBC00, 0, 0xDC00, 0, WORD, O_WORD, 2,
	    O1(M | R | B) O2(M | R | B), "op_file",
#endif /* NOT RETIRED */

	/* new C call, entry opcodes */
	"call",0x4400 ,0,0,0, NONE, O_VAR, 4, O1(M) O2(M) O3(I|M) O4(M),
	    "op_call",
	"entry",0x5800,0,0,0, NONE, O_VAR, 3, O1(M|I) O2(M|I) O3(M|I),
	    "op_entry",
	"subentry",0x5900,0,0,0, NONE, O_VAR, 4, O1(M|I) O2(M|I) O3(M|I) O4(M),
	    "op_subentry",
	"return",0x5808,0,0,0,NONE, O_VAR, 2, O1(M) O2(M), "op_return",

	/* Queue manipulation instructions */
	"lnfl",0x1800,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"lnfp",0x1801,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"lnbl",0x1802,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"lnbp",0x1803,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"lnpl",0x1804,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"ulnl",0x1808,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"ulnp",0x1809,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"ulntl",0x180A,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",
	"ulntp",0x180B,0,0,0, WORD, O_HALF, 2, O1(R) O2(R), "op_queue",


	/* note use of both BCF and BCT */
	"jmp",  0x4000, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jbn",  0x7000, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jbz",  0x7008, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jeq",  0x7180, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jge",  0x7108, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"juge", 0x7200, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jgt",  0x7308, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jugt", 0x7288, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jle",  0x7300, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jule", 0x7280, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jlt",  0x7100, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jult", 0x7208, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jne",  0x7188, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jco",  0x7080, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jnco", 0x7088, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jany", 0x7380, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jnany",0x7388, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jbt",  0x7000, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jov",  0x7000, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jbf",  0x7008, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jnov", 0x7008, 0,0,0, WORD, O_VAR, 1, O1(M), "op_jmp",
	"jsr",  0x4400, 0,0,0, WORD, O_WORD, 2, O1(R) O2(M), "op_jmp",
	"bl" ,  0x4400, 0,0,0, WORD, O_WORD, 2, O1(R) O2(M), "op_jmp",
	"switch", 0xFFFB, 0,0,0, WORD, O_VAR, 1, O1(M), "op_switch",
	"case", 0xFFFA, 0,0,0, WORD, O_VAR, 1, O1(M), "op_case",

	"mulb", 0xC008, 0,0,0xF803, BYTE, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"mulh", 0xC000, 0,0, 0xF803, HALF, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"mulw", 0xC000, 0x3802, 0, 0xF803, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"mull", 0xC000, 0x3C0F, 0, 0xF803, LONG, O_RRHALF, 2,
	    O1(E) O2(E), "op_arith",
	"mulf", 0xE408, 0x3806, 0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"muld", 0xE408, 0x380E, 0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	/* neg is load negative, note no O_REGMEM */
	/* negw with O_REGREG is TRN */
	"negb", 0xB808, 0,0,0, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"negh", 0xB800, 0,0,0, HALF, O_WORD, 2, O1(I | M) O2(R), "op_arith",
	"negw", 0xB800, 0x2C04, 0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"negl", 0xB800, 0x2C0C, 0,0, LONG, O_RRHALF, 2, O1(I | M | E) O2(E), "op_arith",

	"halt", 0x0000, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"wait", 0x0001, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"nop",  0x0002, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",

	"orb", 0x8808, 0,0,0xF809, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_logic",
	"orh", 0x8800, 0,0,0xF809, HALF, O_WORD, 2, O1(I | M) O2(R), "op_logic",
	"orw", 0x8800, 0x0800, 0,0xF809, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_logic",
	"orl", 0x8800, 0,0,0, LONG, O_WORD, 2, O1(I | M) O2(E), "op_arith",

	/* all shift instructions */
#ifndef RETIRED
	"rotlw", 0x2440, 0x3C01,0,0, WORD, O_HALF + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"rotrw", 0x2400, 0x3C01,0,0, WORD, O_HALF, 2,
	    O1(I | R) O2(R), "op_shift",
#endif /* NOT RETIRED */
	"aslw", 0x1C40, 0x3C03,0,0, WORD, O_HALF + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"asll", 0x2040, 0x3C0B,0,0, LONG, O_HALF + O_VAR, 2,
	    O1(I | R) O2(E), "op_shift",
	"asrw", 0x1C00, 0x3C03,0,0, WORD, O_HALF, 2,
	    O1(I | R) O2(R), "op_shift",
	"asrl", 0x2000, 0x3C0B,0,0, LONG, O_HALF, 2,
	    O1(I | R) O2(E), "op_shift",
	"lslw", 0x1C60, 0x3C02,0,0, WORD, O_HALF + O_VAR, 2,
	    O1(I | R) O2(R), "op_shift",
	"lsll", 0x2060, 0x3C0A,0,0, LONG, O_HALF + O_VAR, 2,
	    O1(I | R) O2(E), "op_shift",
	"lsrw", 0x1C20, 0x3C02,0,0, WORD, O_HALF, 2,
	    O1(I | R) O2(R), "op_shift",
	"lsrl", 0x2020, 0x3C0A,0,0, LONG, O_HALF, 2,
	    O1(I | R) O2(E), "op_shift",

	/* convert floating-point double to floating-point single */
	"cfpds", 0x3C09, 0,0,0, LONG, O_HALF, 2, O1(E) O2(R), "op_rroper",

	/* EXS instruction */
	"sign", 0x3808, 0,0,0, WORD, O_HALF, 2, O1(R) O2(R),"op_rroper",

	"subb", 0xCC08, 0,0,0, BYTE, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"subh", 0xCC00, 0,0, 0xFFF9, HALF, O_WORD, 2,
	    O1(I | M) O2(R), "op_arith",
	"subw", 0xCC00, 0x3C00,0,0xFFF9, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"subl", 0xCC00, 0,0,0, LONG, O_WORD, 2,
	    O1(I | M) O2(E), "op_arith",
	"subf", 0xE000, 0x3803,0,0, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_arith",
	"subd", 0xE000, 0x380B,0,0, LONG, O_RRHALF, 2,
	    O1(I | M | E) O2(E), "op_arith",

	"subea", 0x5800, 0,0,0, NONE, O_WORD, 2, O1(M) O2(B), "op_off",

#ifndef RETIRED
	/* xchg is XCR, or XCBR */
	"xchg", 0x2804, 0,0,0, WORD, O_HALF, 2,
	    O1(B | R) O2(B | R), "op_xchg",
	"cxchg", 0x2C06, 0,0,0, WORD, O_HALF, 2,
	    O1(R) O2(R), "op_xchg",
	"cxchl", 0x2C0E, 0,0,0, LONG, O_HALF, 2,
	    O1(E) O2(E), "op_xchg",
#endif /* NOT RETIRED */
	
	"xorb", 0x8C08, 0,0,0xF80A, BYTE, O_WORD, 2, O1(I | M) O2(R), "op_logic",
	"xorh", 0x8C00, 0,0,0xF80A, HALF, O_WORD, 2, O1(I | M) O2(R), "op_logic",
	"xorw", 0x8C00, 0x0C00,0,0xF80A, WORD, O_RRHALF, 2,
	    O1(I | M | R) O2(R), "op_logic",
	"xorl", 0x8C00, 0,0,0, LONG, O_WORD, 2, O1(I | M) O2(E), "op_arith",

	"lwsl1", 0xEC00, 0, 0, 0, WORD, O_WORD, 2, O1(M) O2(R), "op_arith",
	"lwsl2", 0xFC00, 0, 0, 0, WORD, O_WORD, 2, O1(M) O2(R), "op_arith",
	"lwsl3", 0xFC08, 0, 0, 0, WORD, O_WORD, 2, O1(M) O2(R), "op_arith",

/* the less used pseudo ops go here */
	".bss", (int) S_bss, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".bvalue", 0, 0,0,0, NONE, O_PSEUDO, 2, O1(B) O2(M), "op_base",
#ifdef POOL
	".const", (int) S_Lconstant, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
#else /* not POOL */
	".const", (int) S_constant, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
#endif /* POOL */
	".far", 1, 0,0,0, NONE, O_PSEUDO, 0, O1(M), "op_nearfar",
	".farbss", (int) S_farbss, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".fardata", (int) S_fardata, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".farlcomm", 3, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".gcomm", 4, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".dpool", 5, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".bpool", 6, 0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_comm",
	".fartext", (int) S_fartext, 0,0,0, NONE, O_PSEUDO, 0, 0, "op_space",
	".near", 0, 0,0,0, NONE, O_PSEUDO, 0, O1(M), "op_nearfar",
	".stabd", 1,0,0,0, NONE, O_PSEUDO, 3, O1(M) O2(M) O3(M), "op_stab",
	".stabn", 2,0,0,0, NONE, O_PSEUDO, 4,
	    O1(M) O2(M) O3(M) O4(M), "op_stab",
	".stabs", 0,0,0,0, NONE, O_PSEUDO, 5,
	    O1(M) O2(M) O3(M) O4(M), "op_stab",
	".stamp", 0,0,0,0, NONE, O_PSEUDO, 2, O1(M) O2(M), "op_stamp",

/*
*  system operation opcodes. these ops will be used very infrequently,
*  and so are placed in the table to minimize search time for others.
*/

/*	mne,   mr,    rr, rm, ir,  len,   type, #opand, pass1,    pass2	*/

	"svc", 0xF806, 0,0,0, WORD, O_WORD, 3, O1(R) O2(I) O3(I), "op_svc",

	"lpsd",   0xF000, 0,0,0, WORD, O_WORD, 1,	O1(M), "op_mem",
	"ldc",    0xF008, 0,0,0, WORD, O_WORD, 1,	O1(M), "op_mem",

	"setcpu", 0x000C, 0,0,0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"rdsts",  0x0009, 0,0,0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"tpcr",   0x0805, 0,0,0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"trpc",   0x0804, 0,0,0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"rpswt",  0x040B, 0,0,0, NONE, O_HALF, 1,   O1(R), "op_rroper",
	"cmc",    0x000B, 0,0,0, NONE, O_HALF, 1,   O1(R), "op_rroper",

	"sacz",   0x100C, 0,0,0, NONE, O_HALF, 2,
	    O1(R) O2(R), "op_rroper",
	"trsc",   0x0806, 0,0,0, NONE, O_HALF, 2,
	    O1(R) O2(R), "op_rroper",
	"tscr",   0x0807, 0,0,0, NONE, O_HALF, 2,
	    O1(R) O2(R), "op_rroper",
	"ripi",   0x0404, 0,0,0, LONG, O_HALF, 2,   O1(E) O2(R), "op_rroper",

	/* branch and increment instructions */
	"jib",	0x4800,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",
	"jih",	0x4808,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",
	"jiw",	0x4C00,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",
	"jil",	0x4C08,0,0,0,	     WORD, O_VAR, 2,   O1(R) O2(M), "op_binc",

	    /* mnemonic shows D field */
	"bct0", 0x7000,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bct1", 0x7080,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bct2", 0x7100,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bct3", 0x7180,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bct4", 0x7200,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bct5", 0x7280,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bct6", 0x7300,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bct7", 0x7380,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf0", 0x7008,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf1", 0x7088,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf2", 0x7108,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf3", 0x7188,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf4", 0x7208,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf5", 0x7288,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf6", 0x7308,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
	"bcf7", 0x7388,0,0,0,	     WORD, O_VAR, 1,	O1(M), "op_jmp",
#ifndef RETIRED
	"exr",  0xF807, 0x0000,0,0,  WORD, O_WORD, 1, O1(R), "op_ex",
#endif /* NOT RETIRED */

	/* NP1 processor control instructions */

	"stdecc", 0x280B, 0,0,0, LONG, O_HALF, 2, O1(R) O2(E), "op_rroper",
	"ldel",  0x280C, 0,0,0, LONG, O_HALF, 2, O1(R) O2(E), "op_rroper",
	"ldu",   0x280D, 0,0,0, LONG, O_HALF, 2, O1(R) O2(E), "op_rroper",

	"trrcu", 0x0004, 0,0,0, LONG, O_HALF, 1, O1(E), "op_rroper",
	"trrit", 0x0006, 0,0,0, WORD, O_HALF, 1, O1(R), "op_rroper",
	"tritr", 0x0007, 0,0,0, WORD, O_HALF, 1, O1(R), "op_rroper",
	"xcp",   0x0405, 0,0,0, WORD, O_HALF, 1, O1(R), "op_rroper",
	"spm",   0x040C, 0,0,0, WORD, O_HALF, 1, O1(R), "op_rroper",
	"rpm",   0x040D, 0,0,0, WORD, O_HALF, 1, O1(R), "op_rroper",
	"fq",    0x040E, 0,0,0, WORD, O_HALF, 1, O1(R), "op_rroper",
	"ghalt", 0x0C04, 0,0,0, WORD, O_HALF, 1, O1(R), "op_rroper",

	"attio", 0x0005, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"bloc",  0x0406, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"ubloc", 0x0407, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"grun",  0x0C05, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"fudit", 0x2808, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"break", 0x2809, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"frzss", 0x280A, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"diae",  0x000E, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"dfae",  0x000F, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"eiae",  0x0003, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
	"efae",  0x000D, 0,0,0, NONE, O_HALF, 0, 0, "op_zero",
#endif /* GOULD_NP1 */

	0,
};

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
