/*
 * 	(c) Copyright 1986, 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

#ifndef A_OUT_H
#define A_OUT_H
#if	defined(RCSID) && !defined(lint)
static char *include_a_out_hrcsid = "@(#) (Gould) $Header: a.out.h,v 1.11 87/12/16 14:32:13 tuban UTX $";
#endif /* RCSID */

/*
 *   COMMON OBJECT FILE FORMAT
 * 
 * 	A modified version of COFF format is used for NP1 Beta and PN.
 * 	BSD-style a.out format is available for backwards compatibility
 * 	is provided for PN.
 * 
 * 	For a description of the common object file format (COFF) see
 * 	the Common Object File Format chapter of the UNIX System V Support 
 * 	Tools Guide.
 */

#include "exec.h"

/*
 * Macros which take exec structures as arguments and tell whether
 * the file has a reasonable magic number or offsets to text|symbols|strings.
 * Note that the a_text includes a_nbtext; likewise for data and bss.
 */

#define	BADMAG(x) ((x)!=OMAGIC && (x)!=NMAGIC && (x)!=ZMAGIC)

/*
 * Backward compatibility.
 */

#define	N_BADMAG(x)  \
    (((x).a_magic)!=OMAGIC && ((x).a_magic)!=NMAGIC && \
     ((x).a_magic)!=ZMAGIC) 

#ifdef COFF

/*
 * Coff ZMAGIC files consider the filehdr, (optionally) the aouthdr
 * and the relevant section headers to be part of the text segment.
 */

#define SUBSEGALIGN 16		/* all segments must be rounded up to this */
				/* bound to ensure quadword alignment. */

#define N_TXTOFF(x) (x.f_flags & F_DEMAND ? 0 : (FILHSZ + x.f_opthdr \
	+ x.f_nscns * SCNHSZ))

#define N_SYMOFF(x) (x).f_symptr
#define N_STROFF(x) N_SYMOFF(x)+((x).f_nsyms * NLISTSZ)

/*
 * Backwards compatibility.
 */

#define	OLD_ZTXTOFF ((((sizeof (struct old_exec)) + \
		   ((sizeof (double)) -1 )) / \
		  (sizeof (double))) * (sizeof (double)))
#define	OLD_N_TXTOFF(x) \
    ((x).a_magic==ZMAGIC ? 0 : sizeof (struct old_exec))
#define OLD_N_SYMOFF(x) \
    (OLD_N_TXTOFF(x) + (x).a_text+(x).a_data + (x).a_trsize+(x).a_drsize)
#define	OLD_N_STROFF(x) \
    (OLD_N_SYMOFF(x) + (x).a_syms)

#else /* NOT COFF */

/*
 * ZMAGIC files now include the struct exec header as part of the text segment.
 * The size of the header is included in exec.a_text and the offset to the
 * beginning of text is zero.  Programs that need to locate the text of the 1st
 * object loaded in a ZMAGIC file should use ZTXTOFF.
 */

#define	ZTXTOFF ((((sizeof (struct exec)) + \
		   ((sizeof (double)) - 1)) / \
		  (sizeof (double))) * (sizeof (double)))
#define	N_TXTOFF(x) \
    ((x).a_magic==ZMAGIC ? 0 : sizeof (struct exec))
#define N_SYMOFF(x) \
    (N_TXTOFF(x) + (x).a_text+(x).a_data + (x).a_trsize+(x).a_drsize)
#define	N_STROFF(x)  \
    (N_SYMOFF(x) + (x).a_syms)

#endif /* COFF */

/*
 *	Format of a symbol table entry.
 */

typedef struct	nlist
{
    union
    {
        char	*n_name;	/* for use when in-core */
        long	n_strx;		/* index into file string table */
    } n_un;
    unsigned
    char	n_type;		/* type flag, see defines below */
    unsigned
    char	n_other;
    unsigned
    short	n_desc;		/* see <stab.h> */
    unsigned	n_value;	/* value of this symbol or size if */
				/* common or stab offset */
#ifdef COFF
    long	n_scnum;	/* COFF section number */
#endif /* COFF */
} NLIST;

#define NLISTSZ (sizeof(NLIST))

#ifdef COFF

typedef struct old_nlist
{
	union
	{
		char	*n_name;	/* for use when in-core */
		long	n_strx;		/* index into file string table */
	} n_un;
	unsigned
	char	n_type;		/* type flag, see defines below */
	unsigned
	char	n_other;
	unsigned
	short	n_desc;			/* see <stab.h> */
	unsigned	n_value;	/* value of this symbol */
					/* or size if common or stab offset */
} OLD_NLIST;

#define OLD_NLISTSZ (sizeof(OLD_NLIST))

#endif /* COFF */

#define	n_hash	    n_desc	/* used internally by ld */
#define	n_nobase    n_other	/* used to mark comm symbol NOBASE */

/*
 * eligibility flags for n_other
 * (bit flag values 0x10, 0x20, 0x40, 0x80 reserved for ld internal use)
 */

#define E_FAR	1		/* eligible for far */
#define E_SHR	2		/* eligible for interprocess sharing */
#define E_BDDP	4		/* eligible for bounded datapool */
#define E_UBDP	8		/* eligible for unbounded datapool */

/*
 * Simple values for n_type.
 */

#define	N_UNDF		0x00		/* undefined */
#define	N_ABS		0x02		/* absolute */
#define	N_TEXT		0x04		/* text */
#define	N_DATA		0x06		/* data */
#define	N_BSS		0x08		/* bss */
#define	N_NBTEXT	0x0a		/* far text */
#define	N_NBDATA	0x0c		/* far data */
#define	N_NBBSS		0x0e		/* far bss */
#define	N_COMM		0x12		/* common (internal to ld) */
#define	N_NBCOM		0x14		/* far common */
#define N_SHMSG		0x16		/* global common */
#define N_DPOOL		0x18		/* data pool */
#define	N_FN		0x1f		/* file name symbol */

#define N_EXT		01		/* external bit, or'ed in */
#define N_TYPE		0x1e		/* mask for all the type bits */

/*
 * Other permanent symbol table entries have some of the N_STAB bits set.
 * These are given in <stab.h>.
 */

#define	N_STAB		0xe0		/* if any of these bits set, don't
					   discard */

/*
 * Format for namelist values.
 */

#define	N_FORMAT	"%08x"

#endif /* A_OUT_H */

/*
 * 	(c) Copyright 1986, 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
