/* aout.c */
/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 *	Gould, Inc. Base Register Assembler
 */

#ifndef lint
/*NOBASE*/
static char *rcsid = "@(#) (Gould) $Header: aout.c,v 5.5 89/05/12 12:35:28 pcc Rel-3_0 $";
#endif

#include <stdio.h>

#ifndef JCB
#include "a.out.h"
#else /* JCB */
#include <a.out.h>
#endif /* JCB */

#include "struct.h"
#include "operand.h"

#if defined(COFF)
#define RELO_STR reloc
#define RELO_ADDR r_vaddr
#define RELO_SYM r_symndx
#define RSTART si_start

/* segment sizes are rounded to guarantee alignment */
/* RND_SIZE must = the number of bytes - 1 to round by */
/* currently, rounding is to a doubleword (8 byte) boundary */
#else /* A.OUT */
#define RELO_STR relocation_info
#define RELO_ADDR r_address
#define RELO_SYM r_symbolnum
#define RSTART si_rstart
#endif /* COFF */
#define RND_SIZE 7

#ifdef GOULD_NP1
#define ADDRFIELD 0x7fffffff
#else /* GOULD_PN */
#define ADDRFIELD 0x00ffffff
#endif /* GOULD_NP1 */
#define SIGNMASK ~(ADDRFIELD >> 1)

/* macro to handle Gould PowerNode and NP1 f and c address bits */
#define SETCBIT(I,S) {if(S==LONG)I|=2;else if(S==HALF)I|=1;else if(S==BYTE)I|=(1<<19);}

/* temporary symbol to relocate to point to thing in constant seg */
/* the ONLY allowable operations on this structure are to set the */
#ifdef POOL
/* svalue and sspace fields and to use its address in emit_rel calls */
SYM tmpsym =
    {(Tuchar *) "<const>", 0, S_DEF};
/* also temporary operand for constant values */
OPND tmpopnd = {CONSTANT, (short) 0, '\0', '\0', 0, (SYM *) 0, '\0'};
#else /* not POOL */
/* svalue field and to use its address in emit_rel calls */
SYM tmpsym =
    {(Tuchar *) "<const>", 0, S_DEF, 0, 0, S_constant, 0};
#endif /* POOL */

#if defined(COFF)
static FILHDR fl_head;
#ifdef PUT_OPT_HDR
static OLD_AOUTHDR header;
#endif /* PUT_OPT_HDR */
static SCNHDR scn_head;

static SYM scn_syms[] = {
    {(Tuchar *) _TEXT, 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) _DATA, 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) _BSS, 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) ".constl", 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) _CONST_D, 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) _CONST_W, 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) _CONST_X, 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) _CONST_H, 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) _FARTEXT, 0, S_DECL | S_DEF},
    {(Tuchar *) _FARDATA, 0, S_DECL | S_DEF},
    {(Tuchar *) _FARBSS, 0, S_DECL | S_DEF},
#ifdef DYN_BASE
    {(Tuchar *) ".tex2", 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) ".ftex2", 0, S_DECL | S_DEF},
#endif /* DYN_BASE */
    {(Tuchar *) ".dat2", 0, S_DECL | S_DEF | S_BASE},
    {(Tuchar *) ".fdat2", 0, S_DECL | S_DEF},
};

static enum SEGS new_space[] = {
#ifdef DYN_BASE
    S_text, S_fartext,
#endif /* DYN_BASE */
    S_data, S_fardata
};

#ifndef GOULD_NP1
#define MIN_ALIGN sizeof(double)
#else /* GOULD_NP1 */
#define MIN_ALIGN 16
#endif /* NOT GOULD_NP1 */
#define ALIGN_MASK (MIN_ALIGN-1)
#define MOREINF(x) 0, x,
#else /* A.OUT */
struct old_exec header;
#define MOREINF(x)
#endif /* COFF */

Tseginf seginf[last_SEGS] =	/* reserve information for seg info */
				/* ordering must agree with that of */
				/*  enum SEGS in struct.h */
{
    N_TEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(MIN_ALIGN)
    N_DATA,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(MIN_ALIGN)
    N_BSS,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(MIN_ALIGN)
#if defined(COFF)
/* si_align for constant segments is element size */
#endif /* COFF */
    N_TEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(long))
#ifdef POOL
    N_TEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(double))
    N_TEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(long))
    N_TEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(long))
    N_TEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(short))
#endif /* POOL */
    N_NBTEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(MIN_ALIGN)
    N_NBDATA,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(MIN_ALIGN)
    N_NBBSS,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(MIN_ALIGN)
#ifdef DYN_BASE
    N_TEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(long))
    N_NBTEXT,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(long))
#endif /* DYN_BASE */
    N_DATA,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(long))
    N_NBDATA,	0, 0, 0, 0, 0, 0, 0, 0, MOREINF(sizeof(long))
};

#if defined(COFF)
#ifdef DYN_BASE
#define OUTSCNS 15
#else /* NOT DYN_BASE */
#define OUTSCNS 13
#endif /* DYN_BASE */
enum SEGS outscn[OUTSCNS] = {
	S_text,
#ifdef DYN_BASE
	S_tex2,
#endif /* DYN_BASE */
	S_Lconstant, S_Dconstant, S_Wconstant,S_Xconstant, S_Hconstant,
	S_fartext,
#ifdef DYN_BASE
	S_ftex2,
#endif /* DYN_BASE */
	S_fardata, S_fdat2,
	S_data, S_dat2,
	S_bss, S_farbss,
};

#endif /* COFF */

char *malloc ();

Tuchar tmpout[] = "asXXXXXX";	/* temporary output, will be renamed */
FILE *fpout;			/* file pointer for output file */
extern SYM first_sym;
extern long _maketime;
#ifdef POOL

typedef union {
		double c_val;
		int c_ival[2];
		struct {
			SYM *c_sp;
			int c_soff;
		} c_sval;
	} CVAL;

typedef struct Constant {
	struct Constant *c_chain;
	struct Constant *c_next;
	CVAL c_u;
	int c_off;
} CON, *CONP;

static CONP pool[5] = {(CONP) 0};
static CONP pool_first[5] = {(CONP) 0};
static CONP pool_last[5];
static int pool_elsz[5] = {4, 8, 4, 4, 2};
static enum SEGS pool_seg[5] = {S_Lconstant, S_Dconstant, S_Wconstant,
				S_Xconstant, S_Hconstant};
#ifdef LDPOOL
static char *pool_name[] = {"^1", "^2", "^3", "^4"};
static SYM *pool_sym[4];
#endif /* LDPOOL */
#endif /* POOL */






#ifdef POOL
#ifdef LDPOOL
/*
NAME: pre_pass1
PURPOSE:
#if defined(COFF)
initialize section names
#else A.OUT
initially declare constant pool marker symbols
#endif COFF
PRECONDITIONS:
POSTCONDITIONS:
HISTORY:
*/






pre_pass1()
{
#if defined(COFF)
    register enum SEGS cseg;
    
    if (R_readflag) {
	seginf[(int) S_dat2].si_ntype = N_TEXT;
	seginf[(int) S_fdat2].si_ntype = N_NBTEXT;
    };
    for (cseg = S_text; cseg < last_SEGS; ++cseg) {
	scn_syms[(int) cseg].sspace = cseg;
	scn_syms[(int) cseg].s_id = -((int) cseg) - 1;
	seginf[(int) cseg].si_scnsymp = &scn_syms[(int) cseg];
    }
#else /* A.OUT */
    register int i;
    SYM *deflab();

    for (i = 0; i < 4; ++i) {
	if (i < 3)
	    setseg(pool_seg[i+2]);
	pool_sym[i] = deflab(pool_name[i]);
	pool_sym[i]->svalue = 0;
    }
#endif /* COFF */

    setseg(S_text);		/* .text is default segment at start */
}






#endif /* LDPOOL */
#endif /* POOL */
/*
NAME: pass2_init
PURPOSE:
reinitialize data structures for pass 2 and set up initial a.out header.
PRECONDITIONS:
pass 1 MUST be completed before calling this routine
POSTCONDITIONS:
call set_rel_id in sym.c to set the r_symbolnum (a.out) or r_symndx (COFF) field
for each symbol.
seginf and header are set up. space is allocated (with malloc) for
the relocation information. if a malloc call fails, abort the assembly.
otherwise, begin setting up the header, build the temporary output
(object) file name (with mktemp), and open it. header sizes depend on
whether -R used in command line (flagged as R_readflag).
HISTORY:
part of initial coding RJM
*/






pass2_init()
{
    register Tseginf *segp;
    register int i;
    set_rel_id ();

    for (segp = &seginf[0]; segp < &seginf[last_SEGS]; ++segp)
    {
	/* remember seg sizes while readying for pass 2 */
#if defined(COFF)
	segp -> si_size = ((i = segp -> si_dot) + ALIGN_MASK) & ~ALIGN_MASK;
#else /* A.OUT */
	segp -> si_size = ((i = segp -> si_dot) + RND_SIZE) & ~RND_SIZE;
#endif /* COFF */
	segp -> si_dot = 0;

	/* allocate space to store temporaries */
	if (segp -> si_ntype != N_BSS
	   && segp -> si_ntype != N_NBBSS
	) {
	    if ((segp -> si_buf = (Tuchar *) malloc (segp -> si_size)) == 0)
	    {
		error("Fatal assembler error (segment space, program too large)");
		exit (2);
	    }
#if !defined(COFF)
	    /* clear space made by roundup */
	    for (; i < segp -> si_size; ++i)
		segp -> si_buf[i] = 0;
#endif /* NOT COFF */
	}

    /* assume for now that every text or data word is relocated! */
	if (segp -> si_ntype != N_BSS
	   && segp -> si_ntype != N_NBBSS)
	{				/* also, space for relocation info */
#if defined(COFF)
	    i = segp -> si_size * ((RELINFOSZ + sizeof(int)) / sizeof(int));
#else /* A.OUT */
	    i = segp -> si_size * 2;
#endif /* COFF */
	    if ((segp -> si_relbuf =
		(struct RELO_STR *) malloc (i)) == 0)
	    {
	error ("Fatal assembler error (relocation space, program too large)");
		exit (2);
	    }
	}
    }

#if !defined(COFF) || defined(PUT_OPT_HDR)
    header.a_magic = OMAGIC;

    /* text space includes the constant segment */
    header.a_nbtext = seginf[(int) S_fartext].si_size;
    header.a_nbdata =
	seginf[(int) S_fdat2].si_size +
	seginf[(int) S_fardata].si_size;
    if (R_readflag)
    {
	header.a_nbtext += header.a_nbdata;
	header.a_nbdata = 0;
    }
    header.a_nbbss = seginf[(int) S_farbss].si_size;
    header.a_text =
	seginf[(int) S_text].si_size +
#ifdef POOL
	seginf[(int) S_Lconstant].si_size +
	seginf[(int) S_Dconstant].si_size +
	seginf[(int) S_Wconstant].si_size +
	seginf[(int) S_Xconstant].si_size +
	seginf[(int) S_Hconstant].si_size +
#else /* not POOL */
	seginf[(int) S_constant].si_size +
#endif /* POOL */
	header.a_nbtext;
    header.a_data =
	seginf[(int) S_data].si_size +
	seginf[(int) S_dat2].si_size +
	header.a_nbdata;
    if (R_readflag)
    {
	header.a_text += header.a_data;
	header.a_data = 0;
    }
    header.a_bss =
	seginf[(int) S_bss].si_size +
	header.a_nbbss;

#endif /* NOT COFF || PUT_OPT_HDR */
    mktemp (tmpout);

    if ((fpout = fopen (tmpout, "w")) == NULL)
    {
	error ("Fatal assembler error (cannot create temporary file %s)",
	    tmpout);
	exit (2);
    }
}






/*
NAME: emit_half, emit_dhalf
PURPOSE: emit a (instruction, data) halfword
PRECONDITIONS:
parameters instruct and data are the value to be emitted.
dot must be positioned in the proper segment.
POSTCONDITIONS:
the half word is put into the indicated segment with at least halfword
alignment. dot is incremented by 2 (bytes) plus alignment fixup (if any).
ALGORITHM:
the two routines are currently identical. if this remains the same
through the next release, they will be coalesced.
HISTORY:
part of original coding DAW
*/






emit_half(instruct)
int instruct;
{
    short halfwd;
    register SYM *d;

    d = dot;

    if (d -> sspace == S_bss || d -> sspace == S_farbss)
    {
	error ("emit_half: attempt to emit to bss space");
    }
    else
    {
	if ((unsigned) instruct > 0xFFFF)
	{
	    warning ("emit_half: operand precision lost");
	}
	halfwd = instruct;

	if (d -> svalue & 1)
	{			/* how'd this happen? */
	    do_align (2);
	}

#ifdef DEBUG
	if (dbflag)
	{
	    printf ("emit_half: %d+%06x: %04x\n",
		d -> sspace, d -> svalue,
		halfwd);
	    fflush (stdout);
	}
#endif
	stashit (&halfwd, sizeof (halfwd), &seginf[d -> sspace]);
	d -> svalue += 2;
    }
}

emit_dhalf (data)
int data;				/* emit a data halfword */
{
    short halfwd;
    register SYM *d;

    d = dot;

    if (data > 65535 || data < -32768)
    {
	warning ("emit_dhalf: operand precision lost");
    }
    halfwd = data;

    if (d -> svalue & 1)
    {					/* align output */
	do_align (2);
    }

#ifdef DEBUG
    if (dbflag)
    {
	printf ("emit_dhalf: %d+%06x: %04x\n",
	    d -> sspace, d -> svalue,
	    halfwd);
	fflush (stdout);
    }
#endif
    stashit (&halfwd, sizeof (halfwd), &seginf[d -> sspace]);
    d -> svalue += 2;
}






/*
NAME: emit_dbyte
PURPOSE: emit a byte
PRECONDITIONS:
parameter data is the value to be emitted.
dot must be positioned in the proper segment.
POSTCONDITIONS:
the byte is put into the indicated segment with no alignment guarenteed.
dot is incremented by 1 (byte).
HISTORY:
part of original coding DAW
*/






emit_dbyte (data)
int data;
{					/* emit a byte of data */
    Tuchar ch;
    register SYM *d;

    if (data > 255 || data < -128)
    {
	warning ("emit_dbyte: operand precision lost");
    }
    ch = data;
    d = dot;

#ifdef DEBUG
    if (dbflag)
    {
	printf ("emit_dbyte: %d+%06x: %02x\n",
	    d -> sspace, d -> svalue,
	    ch);
	fflush (stdout);
    }
#endif
    stashit (&ch, sizeof (ch), &seginf[d -> sspace]);
    d -> svalue += 1;
}






/*
NAME: emit_word, emit_dword
PURPOSE: emit a (instruction, data) word
PRECONDITIONS:
parameters instruct and data are the value to be emitted.
dot must be positioned in the proper segment.
POSTCONDITIONS:
the word is put into the indicated segment with at least word alignment.
dot is incremented by 4 (bytes) plus alignment fixup (if any).
emit_word will not emit to any bss space. actually, nothing should ever
be emitted to a bss space, no matter what it is called.
HISTORY:
part of original coding DAW
*/






emit_word(instruct)
int instruct;
{
    register SYM *d;

    d = dot;
    if (d -> sspace == S_bss || d -> sspace == S_farbss)
    {
	error ("emit_word: attempt to emit to bss space");
    }
    else
    {
	if (d -> svalue & 3)
	    do_align (4);		/* align the instruction */

#ifdef DEBUG
	if (dbflag)
	{
	    printf ("emit_word: %d+%06x: %08x\n",
		d -> sspace, d -> svalue,
		instruct);
	    fflush (stdout);
	}
#endif
	stashit (&instruct, sizeof (instruct), &seginf[d -> sspace]);

	d -> svalue += 4;
    }
}

emit_dword (data)
int data;
{			/* put out a word of data into current segment */
    register SYM *d;

    d = dot;
    if (d -> svalue & 3)
	do_align (4);			/* align the word */

#ifdef DEBUG
    if (dbflag)
    {
	printf ("emit_dword: %d+%06x: %08x\n",
	    d -> sspace, d -> svalue,
	    data);
	fflush (stdout);
    }
#endif
    stashit (&data, sizeof (data), &seginf[d -> sspace]);

    d -> svalue += 4;
}






/*
NAME: emit_dlong
PURPOSE: emit a long
PRECONDITIONS:
parameter data is the value to be emitted.
dot must be positioned in the proper segment.
because the parameter is of type int (as are all other variables within
the assembler which that value would pass through), the value of data is
limited to what will fit in a 32 bit signed integer. this routine ONLY
assures alignment, 2 words of allocated storage, and sign extension to
the high order word if the most significant bit of data is set.
POSTCONDITIONS:
the long word is put into the indicated segment with two word alignment.
dot is incremented by 8 (byte) plus the alignment fixup (if any).
HISTORY:
part of original coding DAW
*/






emit_dlong (data)
int data;
{			/* put out a dblword of data into current segment */
    int word0 = 0;
    register SYM *d;

    d = dot;
    if (d -> svalue & 7)
	do_align (8);			/* align the data */

#ifdef DEBUG
    if (dbflag)
    {
	printf ("emit_dlong: %d+%06x: %08x\n",
	    d -> sspace, d -> svalue,
	    data);
	fflush (stdout);
    }
#endif

    if (data & 0x80000000)
	word0 = -1;			/* extend sign */

    stashit (&word0, sizeof (word0), &seginf[d -> sspace]);
    d -> svalue += 4;
    stashit (&data, sizeof (data), &seginf[d -> sspace]);
    d -> svalue += 4;
}






/*
NAME: post_pass2
PURPOSE: build the final object file
PRECONDITIONS:
called after pass 2 completes.
POSTCONDITIONS:
an a.out format object file is built.
ALGORITHM:
set up final sizes of all segments,
(fix relocation information using routine patch_rel, - not needed for COFF),
set up the a.out header, write all text, data, and relocation segments,
scan the symbol table to set undefined, external, and absolute flags
as appropriate, build the a.out string table from
the symbol table, link the object file to where it should be.
symbols in the symbol table due to stab pseudo ops must be treated
slightly differently than normal symbols due to non-standard use of
the n_type field. symbols created by .stabd do not have a name
associated with them in the string table.
the order of segments differs within the object file if the -R flag
(R_readflag) is in effect. order for normal object (no -R) is
text, constant, fartext, fardata, fardata2, data, data2
order for readonly object (-R in effect) is
text, constant, data, data2, fartext, fardata, fardata2
bss and farbss is never written to the object file.
HISTORY:
part of initial coding RJM
modified for new segment data structure and in memory assembly DAW
code to handle -R option added RJM
Mon Aug 29 19:54:05 EDT 1983
modified for threaded symbol table RJM
Wed Sep 14 16:07:26 EDT 1983
added first time stamp (temporary) RJM
Thu Sep 22 15:31:41 EDT 1983
*/






#if defined(COFF)
/*
 *	COFF sections which are composites of subsegments have their
 *	alignment set to the maximum of the contained subsegments, and
 *	are internally padded to preserve subsegment alignments
 *
 *	The sections will be null-padded at end in order to round up
 *	to a suitable bound, unless PACK_OBJ is defined.
 */
int segpad[last_SEGS] = {0,};
#endif /* COFF */

post_pass2()
{
    extern Tuchar *outfile;
    register int i, j;
    struct nlist t_sym;
    extern int Symsymbols;		/* number of symbol table entries */
    extern int Symchars;		/* number of symbol characters */
    int strtabsize;
#if defined(COFF)
    extern SYM *latest_sym;
#endif /* COFF */
    SYM *sym_ptr;
#ifdef POOL
    int p;
    CONP cp;
    register enum SEGS cseg;
#if defined(COFF)
    register Tseginf *segi;
    int nscns, rawsiz, relsiz, scnptr, relptr;
#else /* A.OUT */
    int Gpad, Lpad;			/* pad after global/local constants */
    Tuchar zeropad[RND_SIZE];

    for (i = 0; i < RND_SIZE; ++i)
	zeropad[i] = 0;
#endif /* COFF */
#endif /* POOL */

#ifdef DEBUG
    if (dbflag)
    {
	printf ("post_pass2 entry\n");
    }
#endif
#ifdef POOL
    for (p = 0; p < 5; ++p) {
	for (cp = pool_first[p] ; cp; cp = cp->c_next) {
	    int size = (p == 1 ? LONG : (p == 4 ? HALF : WORD));

	    tmpopnd.constval = cp->c_u.c_ival[1];
	    if (p == 0 || p == 3) {
		tmpopnd.haveseen = NAME;
		tmpopnd.symname = cp->c_u.c_sval.c_sp;
	    }
	    else {
		tmpopnd.haveseen = CONST;
		tmpopnd.symname = (SYM *) 0;
	    }
	    if (emit_const(&tmpopnd, size) != cp->c_off)
		error("constant pool phasing error");
	}
    }
#if !defined(COFF)
    Lpad = ((seginf[(int) S_Lconstant].si_offset + RND_SIZE) & ~RND_SIZE)
		- seginf[(int) S_Lconstant].si_offset;
#endif /* NOT COFF */
    seginf[(int) S_Lconstant].si_size = seginf[(int) S_Lconstant].si_offset;
    seginf[(int) S_Dconstant].si_size = seginf[(int) S_Dconstant].si_offset;
    seginf[(int) S_Wconstant].si_size = seginf[(int) S_Wconstant].si_offset;
    seginf[(int) S_Xconstant].si_size = seginf[(int) S_Xconstant].si_offset;
    seginf[(int) S_Hconstant].si_size = seginf[(int) S_Hconstant].si_offset;
#if !defined(COFF)
    i = seginf[(int) S_Wconstant].si_offset +
	seginf[(int) S_Xconstant].si_offset +
	seginf[(int) S_Hconstant].si_offset;
    Gpad = ((i + RND_SIZE) & ~RND_SIZE) - i;
#endif /* NOT COFF */
#else /* not POOL */

    /* constant segment size can change during pass 2 due to availability */
    /* of immediate mode machine instructions, make sure its rounded */
    seginf[(int) S_constant].si_size =
	seginf[(int) S_constant].si_offset + RND_SIZE;
    seginf[(int) S_constant].si_size &= ~RND_SIZE;	/* round up */
#endif /* POOL */






#if !defined(COFF)
#ifdef POOL
    seginf[(int) S_Dconstant].si_start = 0;
    seginf[(int) S_Dconstant].si_rstart = 0;
    for (cseg = S_Wconstant; cseg <= S_Hconstant; ++cseg) {
	seginf[(int) cseg].si_start = seginf[(int) cseg -1].si_start
					+ seginf[(int) cseg - 1].si_size;
	seginf[(int) cseg].si_rstart = seginf[(int) cseg].si_start;
    }

    seginf[(int) S_text].si_start = seginf[(int) S_Hconstant].si_start
				    + seginf[(int) S_Hconstant].si_size + Gpad;
    seginf[(int) S_text].si_rstart = seginf[(int) S_text].si_start;

    seginf[(int) S_Lconstant].si_start = seginf[(int) S_text].si_start
					+ seginf[(int) S_text].si_size;
    seginf[(int) S_Lconstant].si_rstart = seginf[(int) S_Lconstant].si_start;
#else /* not POOL */
    seginf[(int) S_text].si_start = 0;
    seginf[(int) S_text].si_rstart = 0;

    seginf[(int) S_constant].si_start = seginf[(int) S_text].si_size;
    seginf[(int) S_constant].si_rstart = seginf[(int) S_constant].si_start;
#endif /* POOL */

    if (R_readflag)
    {
#ifdef POOL
	seginf[(int) S_data].si_start = 
	    seginf[(int) S_Lconstant].si_start +
	    seginf[(int) S_Lconstant].si_size + Lpad;
	seginf[(int) S_data].si_rstart =
	    seginf[(int) S_Lconstant].si_rstart +
	    seginf[(int) S_Lconstant].si_size + Lpad;
#else /* not POOL */
	seginf[(int) S_data].si_start = 
	    seginf[(int) S_constant].si_start +
	    seginf[(int) S_constant].si_size;
	seginf[(int) S_data].si_rstart =
	    seginf[(int) S_constant].si_rstart +
	    seginf[(int) S_constant].si_size;
#endif /* POOL */

	seginf[(int) S_dat2].si_start = 
	    seginf[(int) S_data].si_start + seginf[(int) S_data].si_size;
	seginf[(int) S_dat2].si_rstart =
	    seginf[(int) S_data].si_rstart + seginf[(int) S_data].si_size;
    }

    /* decide which one that the fartext space follows */
#ifdef POOL
    i = (R_readflag) ? (int) S_dat2 : (int) S_Lconstant;
#else /* not POOL */
    i = (R_readflag) ? (int) S_dat2 : (int) S_constant;
#endif /* POOL */
    seginf[(int) S_fartext].si_start = 
	seginf[i].si_start + seginf[i].si_size + (R_readflag ? 0 : Lpad);
    seginf[(int) S_fartext].si_rstart = seginf[(int) S_fartext].si_start;

    seginf[(int) S_fardata].si_start = 
	seginf[(int) S_fartext].si_start + seginf[(int) S_fartext].si_size;
    if (!R_readflag)
	seginf[(int) S_fardata].si_rstart = 0;
    else
	seginf[(int) S_fardata].si_rstart =
	    seginf[(int) S_fartext].si_rstart + seginf[(int) S_fartext].si_size;

    seginf[(int) S_fdat2].si_start = 
	seginf[(int) S_fardata].si_start + seginf[(int) S_fardata].si_size;
    seginf[(int) S_fdat2].si_rstart = seginf[(int) S_fardata].si_size;

    if (!R_readflag)
    {
	seginf[(int) S_data].si_start = 
	    seginf[(int) S_fdat2].si_start + seginf[(int) S_fdat2].si_size;
	seginf[(int) S_data].si_rstart =
	    seginf[(int) S_fdat2].si_rstart + seginf[(int) S_fdat2].si_size;

	seginf[(int) S_dat2].si_start = 
	    seginf[(int) S_data].si_start + seginf[(int) S_data].si_size;
	seginf[(int) S_dat2].si_rstart =
	    seginf[(int) S_data].si_rstart + seginf[(int) S_data].si_size;
    }

    i = (R_readflag) ? (int) S_fdat2 : (int) S_dat2;
    seginf[(int) S_bss].si_start = 
	seginf[i].si_start + seginf[i].si_size;
    seginf[(int) S_bss].si_rstart = 0;

    seginf[(int) S_farbss].si_start = 
	seginf[(int) S_bss].si_start + seginf[(int) S_bss].si_size;
    seginf[(int) S_farbss].si_rstart = seginf[(int) S_bss].si_size;

    for (i = 0; i < last_SEGS; ++i)
    {
	patch_rel (&seginf[i]);		/* patch up relocation info */
    }

    header.a_nbtext = seginf[(int) S_fartext].si_size;
    header.a_nbdata =
	seginf[(int) S_fdat2].si_size +
	seginf[(int) S_fardata].si_size;
    if (R_readflag)
    {
	header.a_nbtext += header.a_nbdata;
	header.a_nbdata = 0;
    }
    header.a_nbbss = seginf[(int) S_farbss].si_size;
    header.a_text =
	seginf[(int) S_text].si_size +
#ifdef POOL
	seginf[(int) S_Lconstant].si_size +
	seginf[(int) S_Dconstant].si_size +
	seginf[(int) S_Wconstant].si_size +
	seginf[(int) S_Xconstant].si_size +
	seginf[(int) S_Hconstant].si_size +
	Lpad + Gpad +
#else /* not POOL */
	seginf[(int) S_constant].si_size +
#endif /* POOL */
	header.a_nbtext;
    header.a_data =
	seginf[(int) S_data].si_size +
	seginf[(int) S_dat2].si_size +
	header.a_nbdata;
    if (R_readflag)
    {
	header.a_text += header.a_data;
	header.a_data = 0;
    }
    header.a_bss =
	seginf[(int) S_bss].si_size +
	header.a_nbbss;

    /* do not count dot, must change when local symbols added */
    /* Symsymbols is initialized in initsymtab (will not include dot) */
    /* and incremented in sym_create when a symbol is created */
    header.a_syms = Symsymbols * sizeof (struct nlist);

    header.a_stsize = Symchars + 4;
    header.a_trsize = 
	(seginf[(int) S_text].si_nrel
	    + seginf[(int) S_fartext].si_nrel
#ifdef POOL
	    + seginf[(int) S_Lconstant].si_nrel
	    + seginf[(int) S_Dconstant].si_nrel
	    + seginf[(int) S_Wconstant].si_nrel
	    + seginf[(int) S_Xconstant].si_nrel
	    + seginf[(int) S_Hconstant].si_nrel)
#else /* not POOL */
	    + seginf[(int) S_constant].si_nrel)
#endif /* POOL */
	* sizeof (struct RELO_STR);
	
    header.a_drsize = 
	(seginf[(int) S_data].si_nrel
	    + seginf[(int) S_fardata].si_nrel
	    + seginf[(int) S_dat2].si_nrel
	    + seginf[(int) S_fdat2].si_nrel)
	* sizeof (struct RELO_STR);

    if (R_readflag)
    {
	header.a_trsize += header.a_drsize;
	header.a_drsize = 0;
    }
#ifdef LDPOOL
    if (pool_first[4])
	pool_sym[3]->svalue = pool_last[4]->c_off + pool_elsz[4];
#endif /* LDPOOL */

    /* just before it is written, be sure it is stamped */
    header.a_tstamp = time (0);
#ifndef NO_COMPATIBILIY_CHECK
    header.a_asvers = 0x56330000;	/* "V3\0\0"  (1.3 release) */
#else /* no compatibility check */
    header.a_asvers = _maketime;
#endif

    fwrite (&header, sizeof (header), 1, fpout);

#ifdef POOL
    /* global constant segments */
    for (cseg = S_Dconstant; cseg <= S_Hconstant; ++cseg)
	fwrite (seginf[(int) cseg].si_buf,
	    seginf[(int) cseg].si_size, 1, fpout);
    if (Gpad)
	fwrite (zeropad, 1, Gpad, fpout);

    /* text segment */
    fwrite (seginf[(int) S_text].si_buf,
	    seginf[(int) S_text].si_size, 1, fpout);

    /* local constant segment */
    fwrite (seginf[(int) S_Lconstant].si_buf,
	    seginf[(int) S_Lconstant].si_size, 1, fpout);
    if (Lpad)
	fwrite (zeropad, 1, Lpad, fpout);
#else /* not POOL */
    /* text segment */
    fwrite (seginf[(int) S_text].si_buf,
	    seginf[(int) S_text].si_size, 1, fpout);

    /* constant segment */
    fwrite (seginf[(int) S_constant].si_buf,
	    seginf[(int) S_constant].si_size, 1, fpout);
#endif /* POOL */

    /* read only data segment */
    if (R_readflag)
    {
	fwrite (seginf[(int) S_data].si_buf,
		seginf[(int) S_data].si_size, 1, fpout);

    /* read only data segment 2 */
	fwrite (seginf[(int) S_dat2].si_buf,
		seginf[(int) S_dat2].si_size, 1, fpout);
    }

    /* far text segment */
    fwrite (seginf[(int) S_fartext].si_buf,
	    seginf[(int) S_fartext].si_size, 1, fpout);

    /* far data segment */
    fwrite (seginf[(int) S_fardata].si_buf,
	    seginf[(int) S_fardata].si_size, 1, fpout);

    /* far data 2 segment */
    fwrite (seginf[(int) S_fdat2].si_buf,
	    seginf[(int) S_fdat2].si_size, 1, fpout);

    /* read-write data segment */
    if (!R_readflag)
    {
	fwrite (seginf[(int) S_data].si_buf,
		seginf[(int) S_data].si_size, 1, fpout);

    /* read-write data segment 2 */
	fwrite (seginf[(int) S_dat2].si_buf,
		seginf[(int) S_dat2].si_size, 1, fpout);
    }

#ifdef POOL
    /* global constant relocation */
    for (cseg = S_Dconstant; cseg <= S_Hconstant; ++cseg)
	fwrite (seginf[(int) cseg].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) cseg].si_nrel, fpout);
    /* text relocation */
    fwrite (seginf[(int) S_text].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_text].si_nrel, fpout);
    /* local constant relocation */
    fwrite (seginf[(int) S_Lconstant].si_relbuf,
		sizeof (struct RELO_STR),
		seginf[(int) S_Lconstant].si_nrel, fpout);
#else /* not POOL */
    /* text relocation */
    fwrite (seginf[(int) S_text].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_text].si_nrel, fpout);
    /* constant relocation */
    fwrite (seginf[(int) S_constant].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_constant].si_nrel, fpout);
#endif /* POOL */

    /* read-only data relocation */
    if (R_readflag)
    {
	fwrite (seginf[(int) S_data].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_data].si_nrel, fpout);
	fwrite (seginf[(int) S_dat2].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_dat2].si_nrel, fpout);
    }

    /* far text relocation */
    fwrite (seginf[(int) S_fartext].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_fartext].si_nrel, fpout);

    /* far data relocation */
    fwrite (seginf[(int) S_fardata].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_fardata].si_nrel, fpout);
    fwrite (seginf[(int) S_fdat2].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_fdat2].si_nrel, fpout);

    if (!R_readflag)
    {
    /* near data relocation */
	fwrite (seginf[(int) S_data].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_data].si_nrel, fpout);
	fwrite (seginf[(int) S_dat2].si_relbuf, sizeof (struct RELO_STR),
		seginf[(int) S_dat2].si_nrel, fpout);
    }
#endif /* NOT COFF */






#if defined(COFF)
    for (i = S_text; i < last_SEGS; ++i) {
	if (i == S_bss || i == S_farbss)
	    continue;
	while (seginf[i].si_offset < seginf[i].si_size)
	    *(seginf[i].si_buf + seginf[i].si_offset++) = '\0';
    }

    /* fix composite section alignments and pads */
	/* text */
    i = seginf[(int) S_text].si_align;
#ifdef DYN_BASE
    if ((j = seginf[(int) S_tex2].si_align) > i) i = j;
#endif /* DYN_BASE */
    if ((j = seginf[(int) S_Lconstant].si_align) > i) i = j;
    seginf[(int) S_text].si_align = i;		/* alignment for text section */

#ifdef DYN_BASE
    /* assure tex2 alignment */
    i = seginf[(int) S_tex2].si_align - 1;
#else /* NOT DYN_BASE */
    /* assure Lconst alignment */
    i = seginf[(int) S_Lconstant].si_align - 1;
#endif /* DYN_BASE */
    j = seginf[(int) S_text].si_size;
    segpad[(int) S_text] = ((j + i) & ~i) - j;

#ifdef DYN_BASE
    i = seginf[(int) S_Lconstant].si_align - 1;
    j += seginf[(int) S_tex2].si_size;
    segpad[(int) S_tex2] = ((j + i) & ~i) - j;	/* assure Lconst alignment */

	/* far text */
    if ((i = seginf[(int) S_ftex2].si_align) > seginf[(int) S_fartext].si_align)
	seginf[(int) S_fartext].si_align = i;
    --i;
    j = seginf[(int) S_fartext].si_size;
    segpad[(int) S_fartext] = ((j + i) & ~i) - j; /* assure ftex2 alignment */

#endif /* DYN_BASE */
	/* data */
    if ((i = seginf[(int) S_dat2].si_align) > seginf[(int) S_data].si_align)
	seginf[(int) S_data].si_align = i;
    --i;
    j = seginf[(int) S_data].si_size;
    segpad[(int) S_data] = ((j + i) & ~i) - j; /* assure dat2 alignment */

	/* far data */
    if ((i = seginf[(int) S_fdat2].si_align) > seginf[(int) S_fardata].si_align)
	seginf[(int) S_fardata].si_align = i;
    --i;
    j = seginf[(int) S_fardata].si_size;
    segpad[(int) S_fardata] = ((j + i) & ~i) - j; /* assure fdat2 alignment */

#ifndef PACK_OBJ
    i = seginf[(int) S_text].si_size + segpad[(int) S_text] +
#ifdef DYN_BASE
	seginf[(int) S_tex2].si_size + segpad[(int) S_tex2] +
#endif /* DYN_BASE */
	seginf[(int) S_Lconstant].si_size;
    segpad[(int) S_Lconstant] = ((i + ALIGN_MASK) & ~ALIGN_MASK) -i;

    i = seginf[(int) S_Hconstant].si_size;
    segpad[(int) S_Hconstant] = ((i + ALIGN_MASK) & ~ALIGN_MASK) -i;

#ifdef DYN_BASE
    i = seginf[(int) S_fartext].si_size + segpad[(int) S_fartext] +
	seginf[(int) S_ftex2].si_size;
    segpad[(int) S_ftex2] = ((i + ALIGN_MASK) & ~ALIGN_MASK) -i;

#endif /* DYN_BASE */
    i = seginf[(int) S_fardata].si_size + segpad[(int) S_fardata] +
	seginf[(int) S_fdat2].si_size;
    segpad[(int) S_fdat2] = ((i + ALIGN_MASK) & ~ALIGN_MASK) -i;

    i = seginf[(int) S_data].si_size + segpad[(int) S_data] +
	seginf[(int) S_dat2].si_size;
    segpad[(int) S_dat2] = ((i + ALIGN_MASK) & ~ALIGN_MASK) -i;
#endif /* NOT PACK_OBJ */


    for (segi = &seginf[S_text]; segi < &seginf[last_SEGS]; ++segi)
	segi->si_start = 0;

#ifdef DYN_BASE
    seginf[(int) S_tex2].si_start = i = seginf[(int) S_text].si_size
					+ segpad[(int) S_text];
    seginf[(int) S_Lconstant].si_start = i + seginf[(int) S_tex2].si_size
					+ segpad[(int) S_tex2];
#else /* NOT DYN_BASE */
    seginf[(int) S_Lconstant].si_start = seginf[(int) S_text].si_size
					+ segpad[(int) S_text];
#endif /* DYN_BASE */
    seginf[(int) S_dat2].si_start = seginf[(int) S_data].si_size
					+ segpad[(int) S_data];
#ifdef DYN_BASE
    seginf[(int) S_ftex2].si_start = seginf[(int) S_fartext].si_size
					+ segpad[(int) S_fartext];
#endif /* DYN_BASE */
    seginf[(int) S_fdat2].si_start = seginf[(int) S_fardata].si_size
					+ segpad[(int) S_fardata];

    /* find end of symbols */
    for (sym_ptr = &first_sym; sym_ptr; sym_ptr = sym_ptr -> s_taborder)
	latest_sym = sym_ptr;

    nscns = rawsiz = relsiz = 0;
    for (j = 0; j < OUTSCNS; ++j) {
	cseg = outscn[j];
	if (cseg != S_bss && cseg != S_farbss) {
	    rawsiz += seginf[(int) cseg].si_size + segpad[(int) cseg];
	    relsiz += seginf[(int) cseg].si_nrel * RELINFOSZ;
	}

	if (cseg == S_Lconstant
#ifdef DYN_BASE
		|| cseg >= S_tex2
#else /* NOT DYN_BASE */
		|| cseg >= S_dat2
#endif /* DYN_BASE */
	)
	    continue;

	segi = &seginf[(int) cseg];

	switch (cseg) {
	    default:
		if ((i = segi->si_size) == 0)
		    continue;
		break;

	    case S_text:
		if ((i = segi->si_size
#ifdef DYN_BASE
			+ seginf[(int) S_tex2].si_size
#endif /* DYN_BASE */
			+ seginf[(int) S_Lconstant].si_size) == 0
		)
		    continue;
		break;

	    case S_fartext:
		if ((i = segi->si_size + seginf[(int) S_ftex2].si_size) == 0)
		    continue;
		break;

	    case S_data:
		if ((i = segi->si_size + seginf[(int) S_dat2].si_size) == 0)
		    continue;
		break;

	    case S_fardata:
		if ((i = segi->si_size + seginf[(int) S_fdat2].si_size) == 0)
		    continue;
		break;
	}

	/* only non-empty sections get to here */
	seginf[(int) cseg].si_scnnum = ++nscns;

	/* link section name into symbol table */
	latest_sym -> s_taborder = &scn_syms[(int) cseg];
	latest_sym = &scn_syms[(int) cseg];
	scn_syms[(int) cseg].s_taborder = 0;
	scn_syms[(int) cseg].s_id = Symsymbols++;
	Symchars += strlen(scn_syms[(int) cseg].sname) + 1;
    }
    
    seginf[(int) S_Lconstant].si_scnnum = seginf[(int) S_text].si_scnnum;
    scn_syms[(int) S_Lconstant].s_id = scn_syms[(int) S_text].s_id;
#ifdef DYN_BASE
    seginf[(int) S_tex2].si_scnnum = seginf[(int) S_text].si_scnnum;
    scn_syms[(int) S_tex2].s_id = scn_syms[(int) S_text].s_id;
    seginf[(int) S_ftex2].si_scnnum = seginf[(int) S_fartext].si_scnnum;
    scn_syms[(int) S_ftex2].s_id = scn_syms[(int) S_fartext].s_id;
#endif /* DYN_BASE */
    seginf[(int) S_dat2].si_scnnum = seginf[(int) S_data].si_scnnum;
    scn_syms[(int) S_dat2].s_id = scn_syms[(int) S_data].s_id;
    seginf[(int) S_fdat2].si_scnnum = seginf[(int) S_fardata].si_scnnum;
    scn_syms[(int) S_fdat2].s_id = scn_syms[(int) S_fardata].s_id;

    for (i = 0; i < last_SEGS; ++i)
    {
#ifdef DEBUG2
	printf("post_pass2 calling patch_rel: i = %d\n",i);
#endif
	patch_rel (&seginf[i]);
    }

#if defined(PUT_OPT_HDR)
    header.a_magic = OMAGIC;

    header.a_text =
	seginf[(int) S_text].si_size
#ifdef DYN_BASE
	+ seginf[(int) S_tex2].si_size
#endif /* DYN_BASE */
	+ seginf[(int) S_Lconstant].si_size
	+ seginf[(int) S_Dconstant].si_size
	+ seginf[(int) S_Wconstant].si_size
	+ seginf[(int) S_Xconstant].si_size
	+ seginf[(int) S_Hconstant].si_size
#ifdef DYN_BASE
	+ seginf[(int) S_ftex2].si_size
#endif /* DYN_BASE */
	+ seginf[(int) S_fartext].si_size;

    header.a_text +=
	segpad[(int) S_text]
#ifdef DYN_BASE
	+ segpad[(int) S_tex2]
#endif /* DYN_BASE */
	+ segpad[(int) S_Lconstant]
	+ segpad[(int) S_Hconstant]
#ifdef DYN_BASE
	+ segpad[(int) S_ftex2]
#endif /* DYN_BASE */
	+ segpad[(int) S_fartext];

    header.a_data =
	seginf[(int) S_data].si_size +
	seginf[(int) S_dat2].si_size +
	seginf[(int) S_fardata].si_size +
	seginf[(int) S_fdat2].si_size;

    header.a_data +=
	segpad[(int) S_data] +
	segpad[(int) S_dat2] +
	segpad[(int) S_fardata] +
	segpad[(int) S_fdat2];

    if (R_readflag)
    {
	header.a_text += header.a_data;
	header.a_data = 0;
    }
    header.a_bss =
	seginf[(int) S_bss].si_size +
	seginf[(int) S_farbss].si_size;

    /* do not count dot, must change when local symbols added */
    /* Symsymbols was initialized in initsymtab (does not include dot), */
    /* incremented in sym_create when a symbol is created */
    /* and incremented above for section names of non-empty sections */

    header.a_syms = Symsymbols * NLISTSZ;
    header.a_stsize = Symchars + 4;

    /* just before it is written, be sure it is stamped */
#ifdef GOULD_NP1
    header.a_mstamp = 'NP1\0';
#else /* GOULD_PN */
    header.a_mstamp = 'PN\0\0';
#endif /* GOULD_NP1 */

    header.a_sstamp = 'UTX\0';

#ifdef GOULD_NP1
    header.a_cstamp = 'np1\0';		/* initial NP1 version */
#else /* GOULD_PN */
    header.a_asvers = 'V3\0\0';		/* initial PN COFF version */
#endif /* GOULD_NP1 */

#endif /* PUT_OPT_HDR */

/* compose COFF header */
#ifdef GOULD_NP1
    fl_head.f_magic = GNP1MAGIC;
#else /* GOULD_PN */
    fl_head.f_magic = GPNMAGIC;
#endif /* GOULD_NP1 */

    fl_head.f_nscns = nscns;
    fl_head.f_timdat = _maketime;
#ifdef PUT_OPT_HDR
    fl_head.f_opthdr = OLD_AOUTHSZ;
#else /* NOT PUT_OPT_HDR */
    fl_head.f_opthdr = 0;
#endif /* PUT_OPT_HDR */
    fl_head.f_symptr = FILHSZ + fl_head.f_opthdr
			+ nscns * SCNHSZ + rawsiz + relsiz;
    fl_head.f_nsyms = Symsymbols;
    fl_head.f_flags = F_LNNO | F_AR32W | F_EDBX;

    fwrite (&fl_head, FILHSZ, 1, fpout);
#ifdef PUT_OPT_HDR
    fwrite (&header, fl_head.f_opthdr, 1, fpout);
#endif /* PUT_OPT_HDR */

    scnptr = FILHSZ + fl_head.f_opthdr + nscns * SCNHSZ;
    relptr = scnptr + rawsiz;

    for (p = 0; p < OUTSCNS; ++p) {
	cseg = outscn[p];
	if (cseg == S_Lconstant
#ifdef DYN_BASE
		|| cseg >= S_tex2
#else /* NOT DYN_BASE */
		|| cseg >= S_dat2
#endif /* DYN_BASE */
	)
	    continue;
	if (seginf[(int) cseg].si_scnnum != 0) {
	    i = seginf[(int) cseg].si_size + segpad[(int) cseg];
	    j = seginf[(int) cseg].si_nrel;
	    switch (cseg) {
		case S_text:
		    i +=
#ifdef DYN_BASE
			seginf[(int) S_tex2].si_size + segpad[(int) S_tex2] +
#endif /* DYN_BASE */
			seginf[(int) S_Lconstant].si_size
			    + segpad[(int) S_Lconstant];
		    j +=
#ifdef DYN_BASE
			seginf[(int) S_tex2].si_nrel +
#endif /* DYN_BASE */
			seginf[(int) S_Lconstant].si_nrel;
		    break;
		case S_data:
		    i += seginf[(int) S_dat2].si_size + segpad[(int) S_dat2];
		    j += seginf[(int) S_dat2].si_nrel;
		    break;
#ifdef DYN_BASE
		case S_fartext:
		    i += seginf[(int) S_ftex2].si_size + segpad[(int) S_ftex2];
		    j += seginf[(int) S_ftex2].si_nrel;
		    break;
#endif /* DYN_BASE */
		case S_fardata:
		    i += seginf[(int) S_fdat2].si_size + segpad[(int) S_fdat2];
		    j += seginf[(int) S_fdat2].si_nrel;
		    break;
		default:
		    break;
	    }

	    switch (seginf[(int) cseg].si_ntype) {
		case N_TEXT:
		    scn_head.s_flags = STYP_TEXT;
		    if (cseg >= S_Dconstant && cseg <= S_Hconstant)
			scn_head.s_flags |= STYP_CONST;
		    break;

		case N_NBTEXT:
		    scn_head.s_flags = STYP_TEXT | STYP_FAR;
		    break;

		case N_DATA:
		    scn_head.s_flags = (R_readflag ? STYP_TEXT : STYP_DATA);
		    break;

		case N_NBDATA:
		    scn_head.s_flags = (R_readflag ? STYP_TEXT : STYP_DATA)
							| STYP_FAR;
		    break;

		case N_BSS:
		    scn_head.s_flags = STYP_BSS;
		    break;

		case N_NBBSS:
		    scn_head.s_flags = STYP_BSS | STYP_FAR;
		    break;

		default:
		    scn_head.s_flags = 0;
	    }

	    sym_ptr = seginf[(int) cseg].si_scnsymp;
	    strncpy(scn_head.s_name, seginf[(int) cseg].si_scnsymp -> sname, 8);
	    scn_head.s_paddr = scn_head.s_vaddr
		= sym_ptr->svalue = seginf[(int) cseg].si_start;
	    scn_head.s_size = i;
	    if (cseg != S_bss && cseg != S_farbss) {
		scn_head.s_scnptr = scnptr;
		scnptr += i;
	    }
	    else
		scn_head.s_scnptr = 0;
	    scn_head.s_relptr = (j ? relptr : 0);
	    relptr += RELINFOSZ * j;
	    scn_head.s_lnnoptr = 0;
	    scn_head.s_nreloc = j;
	    scn_head.s_nlnno = 0;
	    scn_head.s_align = seginf[(int) cseg].si_align;

	    fwrite(&scn_head, SCNHSZ, 1, fpout);
	}
    }

    /* write section raw data */
    for(j = 0; j < OUTSCNS; ++j) {
	segi = &seginf[(int) outscn[j]];
	if (segi == &seginf[(int) S_bss] || segi == &seginf[(int) S_farbss])
	    continue;
	if (i = segi->si_size)
	    fwrite (segi->si_buf, i, 1, fpout);
	if (i = segpad[(int) outscn[j]])
	    while (i--)
		fputc('\0', fpout);
    }

    /* write section rel data */
    for(j = 0; j < OUTSCNS; ++j) {
	segi = &seginf[(int) outscn[j]];
	if (i = segi->si_nrel)
	    fwrite (segi->si_relbuf, RELINFOSZ, i, fpout);
    }
#endif /* COFF */






    j = 4;				/* to accumulate offset into string */
    /* now build symbol table */
    for (sym_ptr = first_sym.s_taborder; sym_ptr;
	sym_ptr = sym_ptr -> s_taborder)
    {
#if defined(COFF)
	t_sym.n_scnum = 0;
#endif /* COFF */
	if (sym_ptr -> sflags & (S_STABDN | S_STABS))
	{
	   Stab_Fix (&t_sym, sym_ptr);
	}
	else
	{
	    t_sym.n_value = sym_ptr -> svalue;

	    if (!(sym_ptr -> sflags & S_DEF))
	    {
		t_sym.n_type = N_UNDF|N_EXT;
	    }
	    else
	    {
		if (sym_ptr -> sspace == last_SEGS)
		{
		    t_sym.n_type = N_ABS;
#if defined(COFF)
		    t_sym.n_scnum = -1;
#endif /* COFF */
		}
		else
		{
		    if (R_readflag)
		    {
			switch (sym_ptr -> sspace)
			{
			case S_data:
			case S_dat2:
			    t_sym.n_type = N_TEXT;
			    break;

			case S_fardata:
			case S_fdat2:
			    t_sym.n_type = N_NBTEXT;
			    break;

			default:
			    t_sym.n_type =
				seginf[sym_ptr -> sspace].si_ntype;
			    break;
			}
		    }
		    else
		    {
			t_sym.n_type =
			    seginf[sym_ptr -> sspace].si_ntype;
		    }
		    t_sym.n_value += seginf[sym_ptr -> sspace].si_start;
		}
	    }
	    if (sym_ptr -> sflags & S_EXT)
	    {
		t_sym.n_type |= N_EXT;
	    }
/* tell the loader if base register ever used to relocate, see emit_rel */
	    t_sym.n_other = (sym_ptr -> sflags & S_BASE) ? 0 : E_FAR;
	    t_sym.n_desc = 0;
/* mark GLOBAL COMMON and DATAPOOL symbols */
	    if (sym_ptr -> sflags & S_SHARE)
		t_sym.n_other |= E_SHR;
	    if (sym_ptr -> sflags & S_UBDP)
		t_sym.n_other |= (E_UBDP|E_SHR);
	    if (sym_ptr -> sflags & S_BDDP)
		t_sym.n_other |= (E_BDDP|E_SHR);

	}

#if defined(COFF)
	    if ((sym_ptr -> sflags & S_DEF)
		&& !(sym_ptr -> sflags & (S_STABS|S_STABDN))
		&& (t_sym.n_type & N_TYPE) != N_ABS
	    )
	    {
		t_sym.n_scnum = seginf[(int) sym_ptr -> sspace].si_scnnum;
		if (t_sym.n_scnum == 0) {
		    /* label in an empty section;
		       assign a reasonable section */
		    for (i = OUTSCNS - 1; i >= 0; --i) {
			int seen = 0;

			if (outscn[i] >= S_Lconstant
				&& outscn[i] <= S_Hconstant
			)
			    continue;
			segi = (Tseginf *) &seginf[(int) outscn[i]];
			if (segi->si_size > 0)
			    t_sym.n_scnum = segi->si_scnnum;
			if (outscn[i] == sym_ptr -> sspace)
			    seen = 1;
			if (seen && t_sym.n_scnum != 0)
			    break;
		    }
		}
	    }

#endif /* COFF */
	/* n_strx for a .stab[dn] is set to zero in Stab_Fix */
	if (!(sym_ptr -> sflags & S_STABDN))
	{
	    t_sym.n_un.n_strx = j;
	    j += strlen (sym_ptr -> sname) + 1;	/* set next offset */
	}

	fwrite (&t_sym, NLISTSZ, 1, fpout);
    }

    /* now, string table */
    strtabsize = Symchars + 4;
    fwrite (&strtabsize, 4, 1, fpout);
    for (sym_ptr = first_sym.s_taborder; sym_ptr;
	sym_ptr = sym_ptr -> s_taborder)
    {
	if (!(sym_ptr -> sflags & S_STABDN))
	{
	    fputs (sym_ptr -> sname, fpout);
	    putc ('\0', fpout);
	}
    }

    unlink(outfile);
    if (link(tmpout, outfile) != 0)
    {
	perror(outfile);
	error ("Fatal assembler error (output file %s)", outfile);
	exit(2);
    }
    else
    {
	unlink(tmpout);
    }
}






#ifdef POOL
/*
NAME: pool_const
PURPOSE: build constant pools
PRECONDITIONS:
called by emit_rconst to build pools of unique constants.
separate pools are built for address constants of locals, absolute constants
and address constants of externals.
POSTCONDITIONS:
returns byte offset into corresponding subsegment of constant segment
and (via pointer) sets relocation type for referencing instruction.
HISTORY:
84Feb15	initial coding - Gould CSD - 3423
NOTES:
*/






pool_const(opnd, size, reltype, cseg)
register OPND *opnd;
int size, *reltype, *cseg;
{
	int p;
	CONP cp, pcp, tp;
	CVAL v;

	v.c_ival[1] = opnd->constval;
	v.c_ival[0] = 0;
	if (size == BYTE) {
		size = HALF;
		v.c_ival[1] <<= 8;
	}
	if (size == HALF)
		p = 4;
	else if (size == LONG) {
		if (opnd->constval < 0)
			v.c_ival[0] = -1;
		p = 1;
	}
	else {
		if (size != WORD)
		    error("unimplemented constant size");
		p = 2;
	}
	if (opnd->symname) {
		v.c_sval.c_sp = opnd->symname;
		if (opnd->symname->sflags & S_DEF)
			p = 0;
		else
			p = 3;
	}

	*cseg = (int) pool_seg[p];

#ifdef LDPOOL
	*reltype = (p ? R_CONST : R_MEMREFINST);
#else /* not LDPOOL */
	*reltype = R_MEMREFINST;
#endif /* LDPOOL */

	for (pcp = (CONP) &pool[p], cp = pool[p];
	     cp;
	     pcp = cp, cp = cp -> c_chain) {
		if (v.c_val == cp->c_u.c_val)
			return (cp->c_off);
		if (v.c_val < cp->c_u.c_val)
			break;
	}

	tp = cp;

	if ((cp = (CONP) malloc(sizeof(CON))) == 0) {
		error("no constant pool space");
		exit(2);
	}

	cp->c_next = (CONP) 0;
	cp->c_chain = tp;
	cp->c_u.c_val = v.c_val;
	if (pool_first[p]) {
		cp->c_off = pool_last[p]->c_off + pool_elsz[p];
		pool_last[p]->c_next = cp;
	}
	else {
		pool_first[p] = cp;
		cp->c_off = 0;
	}
	pool_last[p] = cp;
	*((int *) pcp) = (int) cp;
	return cp->c_off;
}
#endif /* POOL */
/*
NAME: emit_const
PURPOSE: emit a constant. relocation is emitted if neccessary.
PRECONDITIONS:
currently called only by emit_rconst.
parameter opnd is a pointer to the OPND structure of the (immediate
mode) constant. size is the value of the olength field of the opcode.
POSTCONDITIONS:
the offset within the constant segment of the emitted value is returned.
the value of the constant segment location counter (dot) is incremented
accordingly to the size field.
HISTORY:
15 Jun 83	D A Willcox of Compion	Initial Coding
NOTES:
What do we do with doubleword constants?
Who does bounding?
*/






emit_const (opnd, size)
register OPND *opnd;
int size;
{
    int value;
    int hvalue;
    register int rtype;
    int clength;			/* length of const in bytes */
    int shift;				/* length to shift value before write */
    enum SEGS oldseg;
    int retval;				/* offset to return to caller */
#ifdef POOL
    enum SEGS cseg;
#endif /* POOL */

    /*
     * NOTE - This must be fixed to handle doubleword constants
     */
    
    oldseg = dot -> sspace;			/* remember where we were */

    switch (size)
    {						/* compute alignment */
	case BYTE:
	    shift = 24;
	    rtype = R_BYTE;
	    clength = 1;
	    break;

	case HALF:
	    shift = 16;
	    rtype = R_HALFWORD;
	    clength = 2;
#ifdef POOL
	    cseg = S_Hconstant;
#endif /* POOL */
	    break;

	case WORD:
	    shift = 0;
	    rtype = R_WORD;
	    clength = 4;
#ifdef POOL
	    if (opnd -> haveseen & NAME) {
		if (opnd -> symname -> sflags & S_DEF)
		    cseg = S_Lconstant;
		else
		    cseg = S_Xconstant;
	    }
	    else
		cseg = S_Wconstant;
#endif /* POOL */
	    break;

	default:
	    shift = 0;
	    rtype = R_DOUBLEWORD;
	    clength = 8;
#ifdef POOL
	    cseg = S_Dconstant;
#endif /* POOL */
	    break;
    }

#ifdef POOL
    setseg(cseg);		/* make cseg the current segment */
#else /* NOT POOL */
    setseg (S_constant);	/* make constant seg the current one */
#endif /* POOL */

    do_align (clength);				/* align the constant */

    retval = dot -> svalue;

    value = opnd -> constval;

    if (opnd -> haveseen & NAME)
    {						/* must relocate w.r.t name */
	value = emit_rel (R_ADDRLITERAL, rtype, opnd -> symname, value);
						/* put out relocation info */
    }

    value = ((unsigned) value) << shift;

#ifdef DEBUG
    if (dbflag)
    {
	printf ("CONST: %04x: %08x len %d\n", dot -> svalue, value, clength);
	fflush (stdout);
    }
#endif

    if (clength > 4)
    {
	hvalue = 0;
	if (value < 0)
	    hvalue = -1;
#ifdef POOL
	stashit (&hvalue, 4, &seginf[(int) cseg]);
#else /* not POOL */
	stashit (&hvalue, 4, &seginf[(int) S_constant]);
#endif /* POOL */
	dot -> svalue += 4;
	clength -= 4;
    }

#ifdef POOL
    stashit (&value, clength, &seginf[(int) cseg]);
#else /* not POOL */
    stashit (&value, clength, &seginf[(int) S_constant]);
#endif /* POOL */

    dot -> svalue += clength;			/* update size of segment */
    setseg (oldseg);				/* go back to where we were */

    return (retval);
}






/*
NAME: emit_rconst
PURPOSE: handle immediate mode to register operation.
PRECONDITIONS:
parameters opcd and iopcd are from the ocode and ocodeim fields of the
opcode table. they are the values used for the machine instruction for
an opcode that can (iopcd) and cannot (opcd) use an existing immediate
instruction in the machine instruction set.
parameter r is the value of the destination register.
opnd is the OPND pointer to the operand for the constant.
size is the value of the olength field of the opcode.
POSTCONDITIONS:
emit_const is used to emit the constant into the constant segment.
emit_word is used to emit the instruction.
ALGORITHM:
if an immediate instruction variant is available for this opcode, the
iopcd parameter will be nonzero. to use such a variant (which is
preferred), the constant cannot be relocatable and must fit within a
signed 16 bit quantity. the opcode cannot be a long operation because
the immediate instructions never create a two word quantity.
if no variant exists or these other restrictions are not met, the
constant is emitted into the constant segment and the memory to register
variant of the instruction (opcd) is used.
HISTORY:
15 Jun 83	D A Willcox of Compion	Initial Coding
*/






emit_rconst (opcd, iopcd, r, opnd, size)
register OPND *opnd;
{
    register int inst;		/* instruction being built */
#ifdef POOL
    int reltype, cseg;
#endif /* POOL */

#ifdef DEBUG
    if (dbflag)
    {
	printf ("emit_rconst %x %x %x ... %x\n", opcd, iopcd, r, size);
	popnd (opnd);
    }
#endif

    do_align (4);		/* make sure instr is aligned */

    if (iopcd != 0 &&
	size != LONG &&
	(opnd -> haveseen & NAME) == 0 &&
	opnd -> constval <= 0x7fff &&
	opnd -> constval >= 0xffff8001)
    {				/* we can emit an immediate instr */
	inst = ((unsigned) iopcd) << 16;
	inst |= opnd -> constval & 0xffff;
    }
    else if (iopcd != 0 &&
	size != LONG &&
	opnd -> ishalf)
    {
	inst = opnd -> constval;
	if (opnd -> ishalf == 1) {
	    inst &= 0xffff;
	    reltype = R_LO_ADDR;
	}
	else if (opnd -> ishalf == 2) {
	    if (opnd -> symname) {
		if (inst > 0x7fff || inst < ~0x7fff) {
		    error("emit_rconst: R_HI_ADDR offset overflow");
		    inst = (opnd ->constval & 0x7fff)
					| ((opnd ->constval >> 16) & 0x8000);
		}
	    }
	    else
		inst = (unsigned) opnd -> constval >> 16;
	    reltype = R_HI_ADDR;
	}
	if (opnd -> symname) {
	    dot -> svalue += 2;
	    inst = emit_rel(reltype, R_HALFWORD, opnd -> symname, inst);
	    dot -> svalue -= 2;
	}
	inst |= ((unsigned) iopcd) << 16;
    }
    else
#ifdef POOL
    {				/* put constant in pool */
	tmpsym.svalue = pool_const(opnd, size, &reltype, &cseg);
	tmpsym.sspace = (enum SEGS) cseg;

	inst = emit_rel (reltype, R_WORD, &tmpsym, 0);
#else /* not POOL */
    {				/* must emit a constant */
	tmpsym.svalue = emit_const (opnd, size);
				/* emit const with this value */

	inst = emit_rel (R_MEMREFINST, R_WORD, &tmpsym, 0);
#endif /* POOL */
	/* relocate ref to constant */

#ifdef MODULAR_ADDRESS_ARITHMETIC
	if ((unsigned) inst >= (1 << 19))
#else /* not MODULAR_ADDRESS_ARITHMETIC */
#endif /* MODULAR_ADDRESS_ARITHMETIC */
	{
	    error ("emit_rconst: offset too large");
	}

	inst |= ((unsigned) opcd << 16);
	SETCBIT (inst, size);
    }

    inst |= r << 23;			/* add in src/dest register */

    emit_word (inst);		/* put out the instruction */
}






/*
NAME: emit_rmem
PURPOSE: emit a register-memory (but not constant) instruction.
PRECONDITIONS:
opcode is the instruction code to use, it typically (but not always)
comes from the ocode field of the optable.
r is the register number for the register operand.
op is a OPND pointer for the memory operand.
size is the value of the olength field of the opcode.
POSTCONDITIONS:
the instruction is emitted (by emit_word) and dot is fixed
appropriately. relocation is also done if necessary.
ALGORITHM:
the variable inst is used for the offset field and (if present) the base
register value. emit_rel will 'or' in the base register if a .using pseudo
op is in effect. if the memory operand is just an offset (no name
involved) than make sure it is positive and fits within 16 bits before
building the rest of the instruction.
HISTORY:
15 Jun 83	D A Willcox of Compion	Initial Coding
*/






emit_rmem (opcode, r, opnd, size)
register OPND *opnd;		/* the memory operand */
{
    register int inst;

    do_align (4);

#ifdef DEBUG
    if (dbflag)
    {
	printf ("emit_rmem %x %x ... %x\n", opcode, r, size);
	popnd (opnd);
    }
#endif

    if (opnd -> haveseen & NAME)
    {					/* must locate w.r.t. external symbol */
	if (!opnd->symname) {
	    error("emit_rmem: unnamed memory operand");
	    goto emit_rmem_noname;
	}

	if (opnd -> haveseen & BREG || opnd -> ishalf)
					/* this is funny case */
	{				/* hope it's in low mem! */
	    dot -> svalue += 2;		/* kludge to relocate 2nd halfword */
	    if (opnd -> ishalf == 1 || opnd -> ishalf == 0)
		inst = emit_rel(R_LO_ADDR, R_HALFWORD, opnd -> symname,
			opnd -> constval);	/* relocate ref to constant */
	    else if (opnd -> ishalf == 2) {
		if (opnd -> constval > 0x7fff || opnd -> constval < ~0x7fff) {
		    error("emit_rmem: R_HI_ADDR offset overflow");
		    opnd ->constval = (opnd ->constval & 0x7fff)
					| ((opnd ->constval >> 16) & 0x8000);
		}
		inst = emit_rel(R_HI_ADDR, R_HALFWORD, opnd -> symname,
					opnd -> constval);
	    }

	    inst &= 0xffff;		/* want only the low halfword */
	    dot -> svalue -= 2;
	}
	else if (opnd -> symname -> sflags & S_BDDP)
	{
	    dot -> svalue += 2;
	    inst = emit_rel(R_ADDRLITERAL, R_HALFWORD, opnd -> symname,
		opnd -> constval);
	    dot -> svalue -= 2;
	}
	else
	{				/* normal memory ref instr relocation */
	    inst = emit_rel(R_MEMREFINST, R_WORD, opnd -> symname,
		opnd -> constval);
	}

    }
    else
    {
emit_rmem_noname:
	inst = opnd -> constval;
	if (opnd -> ishalf == 1)
	    inst &= 0xFFFF;
	else if (opnd -> ishalf == 2)
	    inst = ((unsigned) inst >> 16);
	else if (inst & 0xFFFF0000)
	{
	    error ("emit_rmem: offset too large or negative - 0x%x", inst);
	    inst &= 0xFFFF;
	}
    }

    inst |= ((unsigned) opcode << 16) 		/* build base instr */
		| (r << 23)
		| (opnd -> regval << 20)
		| (opnd -> baseval << 16);

    SETCBIT (inst, size);		/* set C bits for half or long */

    emit_word (inst);			/* go put out instruction */
}






/*
NAME: emit_rel
PURPOSE: emit a relocation datum.
PRECONDITIONS:
calling routine must identify type of relocation using parameter type
which can have the values defined for the r_type field of the RELO_STR
structure.  parameter length is used in the r_length field of the same
structure.  parameter symp is the symbol table pointer for the item
that may need to be relocated.  soffs begins as any constant offset
from the operand.
POSTCONDITIONS:
the value of soffs is returned. this return value is the offset from
whatever is being relocated against.
the sflag bit S_BASE is set if any relocation is done using
R_MEMREFINST. this flagging (with some processing in post_pass2) allows
the loader to decide if the symbol can be placed in a far space instead
of a near space. because the base registers used by R_MEMREFINST
relocations are frozen in near space, such relocations disqualify any
use of far space for the symbol.
ALGORITHM:
if the symbol pointed to by symp has a defined value, relocation is done
relative to the beginning of the segment. if, in addition to a local
symbol, a .using pseudo op is in effect, then relocation is not
necessary as the base register has been explicitly assigned by the
.using.
otherwise, relocation is being done against an external (and unknown) symbol,
so set r_extern and r_symbolnum (a.out) or r_symndx (COFF) appropriately.
the variable mask is used to assure that the offset does not exceed the
number of bits available for the type of the relocation item.
the pointer rp is then set up to link the relocation item (ri) into the
appropriate segment's relocation buffer.
HISTORY:
22 Jun 83	D A Willcox of Compion	Initial codiing
*/






emit_rel (type, length, symp, soffs)
int type;		/* type of relocation */
int length;		/* length of relocation */
register SYM *symp;	/* thing to relocation w.r.t. */
register int soffs;
{
#if defined(COFF)
    register SYM *symsp;
#endif /* COFF */
    static struct RELO_STR ri;
    register bvalT *bp;			/* to search bval table */
    extern int bvflags;			/* bit(s) set if .using in effect */
    int mask;				/* mask for offset */
    struct RELO_STR *rp;		/* point to current relocation info */

    ri.RELO_ADDR = dot -> svalue;	/* this is place to relocate */
    ri.r_length = length;
    ri.r_type = type;
#if defined(COFF)
    ((short *) &ri)[5] = 0;	/* null pad */
#endif /* COFF */

    if ((symp -> sflags & S_DEF) && ((ri.r_type != R_HI_ADDR)
   	 || !(symp->sflags & S_EXT)))
    /* local reference and NOT high address relocation item whose
       symbol is globally known...                                */
    {					/* this is a local symbol */
	soffs += symp -> svalue;	/* add in offset within space */

	if (bvflags && type == R_MEMREFINST)	/* if .using is in effect */
	{
	    for (bp = &bval[1]; bp < &bval[8]; ++bp)
	    {				/* look for internal base reg */
		if (bp -> bv_seg == symp -> sspace
		    && bp -> bv_offset <= soffs
		    && bp -> bv_offset + 0x10000 > soffs)
		{				/* we can do it internally! */
		    soffs -= bp -> bv_offset;
		    soffs |= (bp-bval) << 16;
		    symp -> sflags |= S_BASE;	/* cannot NOBASE this one */
		    return (soffs);
		}
	    }
	}

#if defined(COFF)
	/* otherwise, relocate relative to section name symbol */
	symsp = seginf[symp -> sspace].si_scnsymp;
	ri.RELO_SYM = symsp -> s_id;
#else /* A.OUT */
	ri.RELO_SYM = symp -> sspace;	/* this will be fixed in patch_rel */
	ri.r_extern = 0;
#endif /* COFF */
#ifdef DEBUG
	if (dbflag)
	{
#if defined(COFF)
	    printf ("Relocate seg %d+%x, w.r.t %s, sect %s, len %d, type %d\n",
		dot -> sspace, dot -> svalue, symp -> sname,
		    symsp -> sname,
			length, type);
#else /* A.OUT */
	    printf ("Relocate seg %d+%x, w.r.t %s, seg %d, len %d, type %d\n",
		dot -> sspace, dot -> svalue, symp -> sname,
		    ri.RELO_SYM,
			length, type);
#endif /* COFF */
	    fflush (stdout);
	}
#endif
    }
    else
    {					/* relocated w.r.t. external symbol */
#if !defined(COFF)
	ri.r_extern = 1;
#endif /* COFF */
	ri.RELO_SYM = symp -> s_id;
#ifdef DEBUG
	if (dbflag)
	{
	    printf ("Relocate seg %d+%x, ext, sym %d(%s), len %d, type %d\n",
		dot -> sspace, dot -> svalue, ri.RELO_SYM, symp -> sname,
		    length, type);
	    fflush (stdout);
	}
#endif
    }

    switch (type)
    {					/* finally, check negative offset */
	case R_MEMREFINST:
	    symp -> sflags |= S_BASE;	/* cannot NOBASE this one */
#ifdef MODULAR_ADDRESS_ARITHMETIC
	    mask = 0x7ffff;
#else /* not MODULAR_ADDRESS_ARITHMETIC */
#endif /* MODULAR_ADDRESS_ARITHMETIC */
	    break;

	case R_ADDRLITERAL:
	    switch (length)
	    {
		case R_WORD:
#ifdef POOL
/* allow any value in leftmost byte */
		    mask = 0x7fffffff;
#else /* NOT POOL */
#ifdef MODULAR_ADDRESS_ARITHMETIC
		    mask = 0xffffff;
#else /* NOT MODULAR_ADDRESS_ARITHMETIC */
#endif /* MODULAR_ADDRESS_ARITHMETIC */
#endif /* POOL */
		    break;
		
		case R_HALFWORD:
#ifdef MODULAR_ADDRESS_ARITHMETIC
		    mask = 0xffff;
#else /* NOT MODULAR_ADDRESS_ARITHMETIC */
#endif /* MODULAR_ADDRESS_ARITHMETIC */
		    break;

		default:
		    error ("emit_rel: R_ADDRLITERAL length code %d", length);
		    mask = -1;
		    break;
	    }
	    break;

	case R_CONST:
	    switch (length)
	    {
		case R_BYTE:
		    mask = 0x7f;
		    break;

		case R_HALFWORD:
		    mask = 0x7fff;
		    break;

		case R_WORD:
		    mask = 0x7fffffff;
		    break;

		default:
		    error ("emit_rel: R_CONST length type %d", length);
		case R_DOUBLEWORD:
		    mask = -1;
		    break;
	    }
	    break;

	/* R_HI_ADDR and R_LO_ADDR code needs more rigorous testing! */
	case R_HI_ADDR:
	    if (length != R_HALFWORD)
	    {
		    error ("emit_rel: R_HI_ADDR length type %d", length);
		    mask = -1;
	    }
	    else
	    {
		    mask = 0x7fff;
	    }
	    break;

        case R_LO_ADDR:
	    if (length != R_HALFWORD)
	    {
		    error ("emit_rel: R_LO_ADDR length type %d", length);
		    mask = -1;
	    }
	    else
	    {
		    /* Questionable Code ? */
#ifdef GOULD_NP1
		    mask = 0x7fffffff;
#else /* GOULD_PN */
		    mask = 0xffff;
#endif /* GOULD_NP1 */
	    }
	    break;
    }

    if (soffs > mask
	|| soffs < ~mask)
    {				/* requested offset is too large */
	error ("requested offset of 0x%x is larger than 0x%x",
		soffs, mask);
	soffs = mask;
    }

    if (soffs < 0)
#ifdef MODULAR_ADDRESS_ARITHMETIC
    {
	if (type != R_CONST) {
	    if (mask != 0x7fffffff)
		soffs &= mask;
	}
	else
	    soffs &= (1 + (mask<<1));	/* remove high sign bits */
    }
#else /* NOT MODULAR_ADDRESS_ARITHMETIC */
    {
    }
#endif /* MODULAR_ADDRESS_ARITHMETIC */

    rp = seginf[dot -> sspace].si_relbuf + seginf[dot -> sspace].si_nrel++;

    *rp = ri;				/* save the relocation datum */

    return (soffs);			/* return value to store in memory */
}






/*
NAME: patch_rel
PURPOSE: after pass 2, fix relocation offsets for the loader 
PRECONDITIONS:
pass 2 MUST be completed before calling this routine. because of the
existence of multiple subsegments, emit_rel cannot completely resolve
relocations because the sizes are unknown. additional fixes are required
for local (r_extern == 0) relocations.
this routine is called for each subsegment in turn by post_pass2. the
parameter segp is the seginf pointer for the segment to fix up.
ALGORITHM:
caution is required when the -R flag is in effect as symbols in any data
space must be marked as in the appropriate text space and must have
offsets generated properly. status information cannot be blithely over
written due to later need for it elsewhere (here and in post_pass2).
HISTORY:
5 Jul 83	D A Willcox of Compion	Initial coding
*/






patch_rel (segp)
register Tseginf *segp;
{
    register struct RELO_STR *rp;
    register Tuchar *dp;		/* pointer to incore copy */
    register int addr;
    Tseginf *tsegp;			/* segp for target */
    int n, sstart;			/* just to reduce copied code */

#ifdef DEBUG2
	printf("patch_rel: seginf- type = %x\n, buf = %x\n,
		size = %d\n, dot = %x\n, offset = %d\n,
		start = %d\n, relbuf = %x\n, nrel = %d\n\n",
		segp->si_ntype, segp->si_buf,segp->si_size,
		segp->si_dot, segp->si_offset, segp->si_start,
		segp->si_relbuf, segp->si_nrel);
#endif

    for (rp = segp -> si_relbuf + segp -> si_nrel;
	rp && --rp >= segp -> si_relbuf;)
    {					/* loop thru all relocation data */
#ifdef DEBUG2
	printf("patch_rel reloc: addr = %x,\n type = %d\n",
		rp->RELO_ADDR, (int) rp->r_type);
#endif
	if (rp->r_type == R_HI_ADDR && rp->RELO_SYM >= 0)
	    continue; /* No Changes for HiAddr Const */

	dp = (Tuchar *) segp -> si_buf + rp -> RELO_ADDR;
					/* point at the data */

	/* must adjust internal reloc */
#if defined(COFF)
	if ((n = -(rp -> RELO_SYM + 1)) >= 0)
	{
	    if (n == (int) S_Lconstant)
		tsegp = &seginf[S_text];
#ifdef DYN_BASE
	    else if (n >= (int) S_tex2)
		tsegp = &seginf[new_space[n - (int) S_tex2]];
#else /* NOT DYN_BASE */
	    else if (n >= (int) S_dat2)
		tsegp = &seginf[new_space[n - (int) S_dat2]];
#endif /* DYN_BASE */
	    else
		tsegp = &seginf[(enum SEGS) n];
	    rp -> RELO_SYM = tsegp -> si_scnsymp -> s_id;
	    sstart = seginf[n].si_start;	/* relative start of
				segment to relocate with respect to */
#else /* A.OUT */
	if (!rp -> r_extern)
	{
	    tsegp = &seginf[rp -> RELO_SYM];
	    if (R_readflag)
	    {
		switch (rp -> RELO_SYM)
		{
		case S_data:
		case S_dat2:
		    rp -> RELO_SYM = N_TEXT;
		    break;

		case S_fardata:
		case S_fdat2:
		    rp -> RELO_SYM = N_NBTEXT;
		    break;

		default:
		    rp -> RELO_SYM = tsegp -> si_ntype;
		    break;
		}
	    }
	    else
	    {
		rp -> RELO_SYM = tsegp -> si_ntype;
	    }

	    /* change NTYPE to loader's code */
	    sstart = tsegp -> si_start;	/* relative start of segment to relocate
					   with respect to */
#endif /* COFF */
	    switch (rp -> r_type)
	    {
		case R_CONST:
		    switch (rp -> r_length)
		    {
			case R_HALFWORD:
			    *((short *) dp) += sstart;
			    break;

			case R_WORD:
			    *((int *) dp) += sstart;
			    break;

			case R_DOUBLEWORD:
			    dp += 4;
			    *((int *) dp) += sstart;
			    break;

			case R_BYTE:
			default:
			    error ("patch_rel: r_length %d found",
				rp -> r_length);
			    break;
		    }
		    break;

		case R_ADDRLITERAL:
#ifdef MODULAR_ADDRESS_ARITHMETIC
		    addr = *((int *) dp);
		    if ((addr & SIGNMASK) == SIGNMASK)	/* decrement */
			*((int *) dp) = addr + sstart;
		    else
#ifndef GOULD_NP1
		    /* mod 2**24 addition keeps upper byte */
#else /* GOULD_NP1 */
		    /* mod 2**31 addition keeps upper byte */
#endif /* NOT GOULD_NP1 */
			*((int *) dp) = (addr & ~ADDRFIELD)
				    | ((addr + sstart) & ADDRFIELD);
#else /* not MODULAR_ADDRESS_ARITHMETIC */
#endif /* MODULAR_ADDRESS_ARITHMETIC */
		    break;

		case R_MEMREFINST:
#ifdef MODULAR_ADDRESS_ARITHMETIC
		    *((int *) dp) = (*((int *) dp) & 0xfff80000)
				    | ((*((int *) dp) + sstart) & 0x0007ffff);
					/* mod 2**19 addition */
#else /* not MODULAR_ADDRESS_ARITHMETIC */
#endif /* MODULAR_ADDRESS_ARITHMETIC */
		    break;

		case R_HI_ADDR:
		    addr = *((short *) dp) + sstart;
		    if (addr > 0x7fff || addr < ~0x7fff)
			error("patch_rel: 16-bit R_HI_ADDR relocation overflow");
		    *((short *) dp) = addr;
		    break;

		case R_LO_ADDR:
#ifdef GOULD_NP1
		    *((short *) dp) += sstart;
#else /* GOULD_PN */
		    *((short *) dp) += (sstart & 0xffff);
#endif /* GOULD_NP1 */
		    break;

		default:
		    error ("patch_rel: r_type %d found", rp -> r_type);
		    break;
	    }

	}

	rp -> RELO_ADDR += segp -> RSTART;
    }
}






/*
NAME: stashit
PURPOSE: buffer emit requests
PRECONDITIONS:
parameter from is the string of bytes (of length len) to be buffered.
sp is the pointer to the seginf buffer where the data is to be put.
POSTCONDITIONS:
the most likely cause of the error (if it ever occurs) is that pass 1
miscalculated the text segment length. this can happen when new opcodes
are added incorrectly. special care is required that both passes agree
on the size of the O_VAR and O_RRHALF opcodes.
HISTORY:
28 Jun 83	D A Willcox of Compion	Initial coding
*/






stashit (from, len, sp)
register Tuchar *from;
register int len;
register Tseginf *sp;
{
    register Tuchar *to;

    to = (Tuchar *) sp -> si_buf + sp -> si_offset;
    sp -> si_offset += len;

    if (sp -> si_offset > sp -> si_size)
    {
	error ("Fatal assembler error (stashit buffer overflow)");
	error ("%x(%d): %x %x %x", sp, sp-seginf, sp -> si_buf,
	    sp -> si_offset, sp -> si_size);
	dexit (2);
    }
    else
    {
	while (--len >= 0)
	{
	    *to++ = *from++;
	}
    }
}

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
