/*  match.c */

/* %M% %I% %H% SCCS comment line. Leave it alone. */
# include "mfile2.h"
int fldsz, fldshf;
opmatch( lot, lo, p ) register lot, lo;
NODE *p;
{
/* does the op lot in the table correspond to the op lo in the tree p */
 if( lot == OPANY ) return(1);
 if( lot == ASG OPANY ) return( asgop(lo ) );
 if( lot == OPLOG ) return( logop( lo ) );
 if( lot == LTYPE ){
  if( lo==NAME || lo==ICON || lo==OREG ) return(1);
  else return( shltype( lo, p ) );
 }
 if( lot == lo ) return(1);
 if( lot & 01 ){ /* assignment op called for */
  if( !asgop(lo) ) return(0);
  lot = NOASG lot;
  lo = NOASG lo;
 }
 if( lot == OPLEAF ) return( optype(lo) == LTYPE );
 if( lot == OPUNARY ) return( optype(lo) == UTYPE );
 if( lot==OPFLOAT) return( lo==PLUS||lo==MINUS||lo==MUL||lo==DIV );
 switch( lo ){
 case PLUS:
 case OR:
 case ER:
  if( lot == OPCOMM ) return(1);
 case MINUS:
  return( lot == OPSIMP );
  break;
 case MUL:
  return( lot == OPMUL );
 case DIV:
  return( lot == OPMUL || lot == OPDIV );
 case MOD:
  return( lot == OPDIV );
 case LS:
 case RS:
  return( lot == OPSHFT );
  break;
 }
 return(0);
}
tshape( p, shape ) NODE *p;
{
 /* return true if shape is appropriate for the node p
     side effect for SFLD is to set up fldsz,etc */
 register o, mask;
 o = p->in.op;
 if( sdebug ){
  fprintf(of,  "tshape( %x, %o), op = %s\n", p, shape, opstri(o) );
 }
 if( shape & SPECIAL ){
  switch( shape ){
  case SZERO:
  case SONE:
  case SMONE:
   if( o != ICON || p->in.name[0] ) return(0);
   if( p->tn.lval == 0 && shape == SZERO ) return(1);
   else if( p->tn.lval == 1 && shape == SONE ) return(1);
   else if( p->tn.lval == -1 && shape == SMONE ) return(1);
   else return(0);
  default:
   return( special( p, shape ) );
  }
 }
 if( shape & SANY ) return(1);
 if( (shape&INTEMP) && shtemp(p) ) return(1);
 if( (shape&SWADD) && (o==NAME||o==OREG) ){
  if( BYTEOFF(p->tn.lval) ) return(0);
 }
 if( sdebug ){
  fprintf(of,  "...switch( %x, %o), op = %s\n", p, shape, opstri(o) );
 }
 switch( o ){
 case NAME:
  return( shape&SNAME );
 case ICON:
  mask = SCON;
  return( shape & mask );
 case FLD:
  if( shape & SFLD ){
   if( !flshape( p->in.left ) ) return(0);
   /* it is a FIELD shape; make side-effects */
   o = p->tn.rval;
   fldsz = UPKFSZ(o);
   fldshf = SZINT - fldsz - UPKFOFF(o);
   return(1);
  }
  return(0);
 case CCODES:
  return( shape&SCC );
 case REG:
  /* distinctions:
    SAREG any scalar register
    STAREG any temporary scalar register
    SBREG any lvalue (index) register
    STBREG any temporary lvalue register
    */
  mask = 0;
  if (isareg( p->tn.rval )) mask = SAREG;
  if (isbreg( p->tn.rval )) mask |= SBREG;
  if (istreg( p->tn.rval ) && busy[p->tn.rval] <= 1){
   if (mask & SAREG) mask |= STAREG;
   if (mask & SBREG) mask |= STBREG;
  }
  if( sdebug ){
   fprintf(of,  "...REG( %x, %o), op = %s\n", p, shape, opstri(o) );
   fprintf(of, "...REG returning %o\n", shape & mask);
  }
  return( shape & mask );
 case OREG:
  return( shape & SOREG );
 case UNARY MUL:
  /* return STARNM or STARREG or 0 */
  return( shumul(p->in.left) & shape );
 }
 return(0);
}
ttype( t, tword ){
 /* does the type t match tword */
 if( tword & TANY ) return(1);
 if( tdebug ){
  fprintf(of,  "ttype( ");
  tprint(t);
  fprintf(of,  ", %o )\n", tword );
 }
 if( ISPTR(t) && (tword&TPTRTO) ) {
  do {
   t = DECREF(t);
  }
  while ( ISARY(t) );
  /* arrays that are left are usually only
        in structure references... */
  return( ttype( t, tword&(~TPTRTO) ) );
 }
 if( t != BTYPE(t) ) return( tword & TPOINT );
          /* TPOINT means not simple! */
 if( tword & TPTRTO ) return(0);
 switch( t ){
 case CHAR:
  return( tword & TCHAR );
 case SHORT:
  return( tword & TSHORT );
 case STRTY:
 case UNIONTY:
  return( tword & TSTRUCT );
 case INT:
  return( tword & TINT );
 case UNSIGNED:
  return( tword & TUNSIGNED );
 case USHORT:
  return( tword & TUSHORT );
 case UCHAR:
  return( tword & TUCHAR );
 case ULONG:
  return( tword & TULONG );
 case LONG:
  return( tword & TLONG );
 case FLOAT:
  return( tword & TFLOAT );
 case DOUBLE:
  return( tword & TDOUBLE );
 }
 return(0);
}
struct optab *rwtable;
struct optab *opptr[DSIZE];
setrew(){
 /* set rwtable to first value which allows rewrite */
 register struct optab *q;
 register int i;
 for( q = table; q->op != FREE; ++q ){
  if( q->needs == REWRITE ){
   rwtable = q;
   goto more;
  }
 }
 cerror( "bad setrew" );
more:
 for( i=0; i<DSIZE; ++i ){
  if( dope[i] ){ /* there is an op... */
   for( q=table; q->op != FREE; ++q ){
    /*  beware; things like LTYPE that match
            multiple things in the tree must
            not try to look at the NIL at this
            stage of things!  Put something else
            first in table.c  */
    if( opmatch( q->op, i, NIL ) ) break;
   }
   opptr[i] = q;
  }
 }
}
match( p, cookie ) NODE *p;
{
 /* called by: order, gencall
     look for match in table and generate code if found unless
     entry specified REWRITE.
     returns MDONE, MNOPE, or rewrite specification from table */
 register struct optab *q;
 register NODE *r;
 if(mdebug) {
  fprintf(of, "* match(%x, ", p);
  prcook(cookie);
  fprintf(of, "): \n");
 }
 if( cookie == FORREW ) q = rwtable; /* see setrew(), above. */
 else q = opptr[p->in.op];
 for( ; q->op != FREE; ++q ){
  if( !opmatch( q->op, p->in.op, p ) ) continue;
  if (sdebug) fprintf(of, "Table [%d]  op = %s\n",q-table,
               opstri(q->op));
  if( !(q->visit & cookie ) ) continue;
  r = getlr( p, 'L' );   /* see if left child matches */
  if( !tshape( r, q->lshape ) ) continue;
  if( !ttype( r->in.type, q->ltype ) ) continue;
  r = getlr( p, 'R' );   /* see if right child matches */
  if( !tshape( r, q->rshape ) ) continue;
  if( !ttype( r->in.type, q->rtype ) ) continue;
  /* REWRITE means no code from this match but go ahead
        and rewrite node to help future match */
  if( q->needs & REWRITE ) {
   if(mdebug) {
    mprint(q," rewrite needed.");
   }
   return(q->rewrite);
  }
  if( !allo( p, q ) )  {
   if(mdebug) {
    mprint(q, "cant allocate registers");
   }
   continue;
  }
  /* resources are available */
  if(mdebug)  mprint(q, "match found.");
  expand( p, cookie, q->cstring );  /* generate code */
  reclaim( p, q->rewrite, cookie );
  return(MDONE);
 }
 return(MNOPE);
}
expand( p, cookie, cp ) NODE *p;
register char *cp;
{
 /* generate code by interpreting table entry */
 CONSZ val;
 for( ; *cp; ++cp ){
  switch( *cp ){
  default:
   putc( *cp, of);
   continue;  /* this is the usual case... */
  case 'E':  /* For templates we think are defective,
          * but don't want to fix or discard yet. */
   cerror("Defective template for op %s",
   opst[p->in.op] );
   return;
  case 'Z':  /* special machine dependent operations */
   zzzcode( p, *++cp );
   continue;
  case 'F':  /* this line deleted if FOREFF is active */
   if( cookie & FOREFF ) while( *++cp != '\n' ) ; /* VOID */
   continue;
  case 'S':  /* field size */
   fprintf(of,  "%d", fldsz );
   continue;
  case 'H':  /* field shift */
   fprintf(of,  "%d", fldshf );
   continue;
  case 'M':  /* field mask */
   val = 1;
   val <<= fldsz;
   --val;
   val <<= fldshf;
   adrcon( val );
   continue;
  case 'L':  /* output special label field */
   fprintf(of,  "%d", p->bn.label );
   continue;
  case 'O':  /* opcode string */
   hopcode( *++cp, p->in.op );
   continue;
  case 'B':  /* byte offset in word */
   val = getlr(p,*++cp)->tn.lval;
   val = BYTEOFF(val);
   fprintf(of,  CONFMT, val );
   continue;
  case 'C': /* for constant value only */
   conput( getlr( p, *++cp ) );
   continue;
  case 'I': /* in instruction */
   insput( getlr( p, *++cp ) );
   continue;
  case 'A': /* address of */
   adrput( getlr( p, *++cp ) );
   continue;
  case 'U': /* for upper half of address, only */
   upput( getlr( p, *++cp ) );
   continue;
  }
 }
}
NODE *
getlr( p, c ) NODE *p;
{
 /* return the pointer to the left or right side of p, or p itself,
     depending on the optype of p */
 switch( c ) {
 case '1':
 case '2':
 case '3':
  return( &resc[c-'1'] );
 case 'L':
  return( optype( p->in.op ) == LTYPE ? p : p->in.left );
 case 'R':
  return( optype( p->in.op ) != BITYPE ? p : p->in.right );
 }
 cerror( "bad getlr: %c", c );
 return(p); /* shut up warnings */
}
mprint(q,s)
register struct optab *q;
char *s;
{
 fprintf(of, "* %x: table[%d]: ", q, q - table);
 fprintf(of, " %s \n", s);
}
