/* local2.c */

/* %M% %I% %H% SCCS comment line. Leave it alone. */
# include "mfile2.h"
/* a lot of the machine dependent parts of the second pass */
NODE *fortaddr();
int argcnt; /* needed for fortran calls */
where(c){
 fprintf( stderr, "%s, line %d: ", filename, lineno );
}
lineid( l, fn ) char *fn;
{
 /* identify line l and file fn */
#ifdef NBC
 fprintf(of,  "*\n* Line %d File %s\n*\n", l, fn);
#else
 fprintf(of,  "* Line %d File %s\n", l, fn);
#endif
}
eobl2(){
 OFFSZ totaloff;
 maxoff /= SZCHAR;
 SETOFF( maxoff, 8);
 if (maxargs < 0) maxargs = 0;
 SETOFF( maxargs,8);
 totaloff = maxoff + maxargs + SAVEREGION;
 SETOFF( totaloff, 32);
 fprintf(of, " bound 1w\n");
 fprintf(of, "off%d. equ $\n", ftnno);
 fprintf(of, " dataw %ld\n", -totaloff);
 fprintf(of, "aut%d. equ %ld\n", ftnno, totaloff - maxoff );
 fprintf(of, "tmp%d. equ %ld\n", ftnno, totaloff - maxoff );
 fprintf(of, "arg%d. equ %ld\n", ftnno, totaloff + SAVEREGION );
 fprintf(of, "*\n");
 maxargs = -1;
}
struct hoptab {
 int opmask;
 char * opstring;
}
ioptab[] = {
 ASG PLUS, "ad",
 ASG MINUS, "su",
 ASG MUL, "mp",
 ASG DIV, "dv",
 ASG MOD, "dv",
 ASG LS, "sll",
 ASG RS, "srl",
 ASG AND, "an",
 ASG OR, "or",
 ASG ER, "eo",
 -1, ""    };
hopcode( f, o ){
 /* output the appropriate string from the above table */
 register struct hoptab *q;
 for( q = ioptab;  q->opmask>=0; ++q ){
  if( q->opmask == o ){
   fprintf(of,  "%s", q->opstring );
   switch( f ){
   case ' ':
   case 'I':
    break;
    break;
   default:
    fprintf(of, "%c", f); /* mem to reg */
   }
   return;
  }
 }
 cerror( "no hoptab for %s", opst[o] );
}
char *
rnames[] = {  /* keyed to register number tokens */
 "r0.","r1.","r2.","r3.","r4.","r5.","r6.","r7.",
 "FP","AP","TP","CP",
};
int rstatus[] = {
 SAREG|STAREG,
 SAREG|STAREG|SBREG|STBREG,
 SAREG|STAREG|SBREG|STBREG,
 SAREG|SBREG,
 SAREG|STAREG,
 SAREG|STAREG,
 SAREG|STAREG,
 SAREG|STAREG,
 0,
 0,
 0,
 0,
};
char cbsetflg;
zzzcode( p, c ) NODE *p;
{
 register m;
 CONSZ val;
 int typ;
 NODE *p2;
 switch( c ){
 case 'B': /* single bit constant */
 case 'b':
  val = p->in.right->tn.lval;
  m = ispow2(val);
  m = bsiztyp(c=='B'? p->in.left->in.type : INT) - m - 1;
  if(m < 0)
   cerror("Operation with no effect has confused compiler");
  fprintf(of, "%d", m);
  return;
 case 'p': /* set bit for conversion to pointer */
  switch( DECREF(p->in.type) ){
  case CHAR:
   m = 12;
   break;
  case SHORT:
  case USHORT:
   m = 31;
   break;
  case LONG:
  case DOUBLE:
   m = 30;
   break;
  }
  fprintf(of, "%d", m);
  return;
 case 'C': /* flag for cc 'set' */
  cbsetflg = 1;
  return;
 case 'D':
  p2 = p->in.left;
  goto dd;
 case 'd':
  p2 = p->in.right;
dd:
  if (p2->in.type == LONG || p2->in.type == DOUBLE)
   fprintf(of, "d");
  break;
 case 'R': /* put arg cnt into reg */
  fprintf(of, " li r2.,%dw\n", argcnt >> 2);
  break;
 case 'M': /* mask, width determined by left side's type */
  typ = p->in.left->in.type;
  m = 0xFFFFFFFF;
  switch(typ) {
  case CHAR:
  case UCHAR:
   m = 0xFF;
   break;
  case SHORT:
  case USHORT:
   m = 0xFFFF;
   break;
  };
  fprintf(of, "=x'%d'", m);
  return;
 case 'N':  /* logical ops, turned into 0-1 */
  /* use register given by register 1 */
  cbgen( 0, m=getlab(), 'I' );
  deflab( p->bn.label );
  fprintf(of,  " zr %s\n", rnames[getlr( p, '1' )->tn.rval] );
  deflab( m );
  return;
 case 'H': /* shift instruction */
 case 'h':
  val = (p->in.op == ASG LS) ? 0x7040 : 0x7000;
  switch (p->in.left->in.type){
  case DOUBLE:
  case LONG:
   val += 0xc00;
  }
  if(c == 'H')
   val += (p->in.left->tn.rval) << 7; /* register */
  fprintf(of, "x'%lx'", val);
  return;
 case 'i': /* output address or constant for initialization */
/*if (p->in.name[0]){            mjp mods
   fprintf(of, " gen %d/a(", bsiztyp(p->in.type) );  */
  if (p->in.left->in.name[0]){
#ifdef NBC
   fprintf(of, " gen 32/a(");
#else
   fprintf(of, " dataw ");
#endif
   acon( p->in.left );
#ifdef NBC
   fprintf(of, ")");
#endif
  }
  else {
   fprintf(of, " dataw ");
   acon(p->in.left);
  }
  return;
 case 'I':
 case 'P':
  cbgen( p->in.op, p->bn.label, c );
  return;
 case 'U':
  /* output 'l' for logical comparisons */
  if( p->in.op==UGT||p->in.op==UGE||p->in.op==ULT||p->in.op==ULE ){
   fprintf(of,  "l" );
   p->in.op += (LE-ULE);
  }
  return;
 case 'v':
  m = p->in.right->tn.rval;
  typ = p->in.right->in.type;
  goto signext;
 case 'V':
  /* sign extend or not -- register is one less than the
       left descendent */
  m = p->in.left->tn.rval;
  typ = p->in.left->in.type;
signext:
  if( ISUNSIGNED(typ) ){
   fprintf(of,  " zr %s\n",rnames[m - 1]);
  }
  else {
   fprintf(of,  " es %s\n", rnames[m - 1]);
  }
  if( busy[m - 1] == 0) return;
  if (busy[m - 1] > 1) cerror("es register Busy");
  if(p->in.left->in.op == REG && p->in.left->tn.rval == (m-1)) return;
  if(p->in.right->in.op == REG && p->in.right->tn.rval == (m-1)) return;
  cerror("es register busy");
  return;
 case 'L':  /* literal constant */
  m = getlab();
  fprintf(of,  "D.%d\n", m);
  if( p->in.right->in.op != ICON || p->in.right->in.name[0] )
       cerror( "bad ZL" );
  fprintf(datafc, "D.%d\tdataw\t", m);
  fprintf(datafc, "\n");
  return;
 case 'S':  /* structure assignment */
  {
   register NODE *l, *r;
   register size, align, count;
   char *string;
   OFFSZ loff, roff;
   if( p->in.op == STASG ){
    l = p->in.left;
    r = p->in.right;
   }
   else if( p->in.op == STARG ){  /* store an arg into a temporary */
    l = getlr( p, '3' );
    r = p->in.left;
   }
   else cerror( "STASG bad" );
   if( r->in.op == ICON ) r->in.op = NAME;
   else if( r->in.op == REG )
    if(!notoff(0, r->tn.rval, (CONSZ)0, 0))
     r->in.op = OREG;
    else if( r->in.op != OREG ) cerror( "STASG-r" );
   size = p->stn.stsize;
   align = p->stn.stalign;
   if( align > 4 ) align = 4;
   count = size / align;
   if( align == 1 ) string = "b";
   else if( align == 2 ) string = "h";
   else string = "w";
   loff = l->tn.lval;
   roff = r->tn.lval;
   while( count-- ){ /* simple load/store loop */
    fprintf(of,  " l%s ", string );
    expand( r, FOREFF, "A1,AR\n" );
    fprintf(of,  " st%s ", string );
    expand( l, FOREFF, "A1,AL\n" );
    l->tn.lval += align;
    r->tn.lval += align;
   }
   l->tn.lval = loff;
   r->tn.lval = roff;
   if( r->in.op == NAME ) r->in.op = ICON;
   else if( r->in.op == OREG ) r->in.op = REG;
  }
  break;
 default:
  cerror( "illegal zzzcode" );
 }
}
rmove( rt, rs, t ){
 fprintf(of,  " trr %s,%s\n", rnames[rs], rnames[rt]);
 if (t == LONG || t == DOUBLE)
  fprintf(of, " trr %s,%s\n", rnames[rs+1], rnames[rt+1]);
}
struct respref
respref[]  = {
 INTAREG|INTBREG, INTAREG|INTBREG,
 INAREG|INBREG|FORARG, INAREG|INBREG,
 INTEMP|FORARG, INTEMP,
 INTEMP, INTAREG|INAREG|INTBREG|INBREG|SOREG|STARREG,
 0, 0 };
setregs(){ /* set up temporary registers */
 register i;
 for (i = R4; i <= R7; i++){
  if (i <= maxtreg) rstatus[i] |= STAREG;
  else rstatus[i] &= ~STAREG;
 }
 fregs = maxtreg;
 ;
}
szty(t){ /* size, in words, needed to hold thing of type t */
 if (t == LONG || t == DOUBLE) return(2);
 return( 1 );
}
rewfld( p ) NODE *p;
{
 return(1);
}
callreg(p) NODE *p;
{
 if(busy[R2]) cerror("call regs busy");
 return( R0 );
}
shltype( o, p ) register NODE *p;
{
 return( o == NAME || o == ICON || o == OREG );
}
flshape( p ) register NODE *p;
{
 return( shtemp( p ) );
}
shtemp( p ) register NODE *p;
{
 if( p->in.op == STARG ) p = p->in.left;
 return( p->in.op==NAME || p->in.op ==ICON || p->in.op == OREG );
}
shumul( p ) register NODE *p;
{
 register x;
 switch( p->in.op ){
 case NAME:
 case ICON:
 case OREG:
  switch( x = DECREF(p->in.type)){
  default:
   if ( !ISPTR(x)) return(0);
  case INT:
  case FLOAT:
   return(STARNM);
  }
 }
 return (0);
}
adrcon( val ) CONSZ val;
{
 fprintf(of,  "=" );
 fprintf(of,  "x'%lx'", val );
}
conput( p ) register NODE *p;
{
 switch( p->in.op ){
 case ICON:
  scon( p );
  return;
 case REG:
  fprintf(of,  "%s", rnames[p->tn.rval] );
  return;
 default:
  cerror( "illegal conput" );
 }
}
insput( p ) register NODE *p;
{
 char c;
 switch( p->in.type ){
 case UCHAR:
 case CHAR:
  c = 'b';
  break;
 case USHORT:
 case SHORT:
  c = 'h';
  break;
 case UNSIGNED:
 case INT:
 case FLOAT:
  c = 'w';
  break;
 case LONG:
 case DOUBLE:
  c = 'd';
  break;
 default:
  if (ISPTR(p->in.type) ) c = 'w';
  else
  if (ISARY(p->in.type) ) c = 'w';
  else
  if (ISFTN(p->in.type) )  c = 'a';
  else
   cerror("insput %o ??\n", p->in.type);
 }
 fprintf(of, "%c", c);
}
upput( p ) register NODE *p;
{
 cerror( "upput" );
}
adrput( p ) register NODE *p;
{
 /* output an address, with offsets, from p */
 int o;
 register i, m;
 CONSZ v;
 o = p->in.op;
 if( o == FLD ){
  p = p->in.left;
 }
 if (o == UNARY MUL){
  fprintf(of, "?"); /* was * */
  fflush(of);
  cerror("adrput: indirection encountered");
 }
 o = p->in.op;
 switch( o ){
 case NAME:
  scon( p );
  return;
 case ICON:
   { int loc; FILE *fc;
  /* addressable value of the constant */
  if (p->in.name[0]){
   fprintf(of, "L.%d", m = getlab());
   loc = locctr( 4 ); /* locctr( ISTRING ) */
   fc = swfc(sdatafc);
#ifdef NBC
   fprintf(of, " bound 1w\nL.%d gen 32/a(", m);
#else
   fprintf(of, " bound 1w\nL.%d dataw ", m);
#endif
   acon( p );
#ifdef NBC
   fprintf(of, ")\n");
#else
   fprintf(of, "\n");
#endif
   swfc(fc);
   locctr(loc);
  }
  else{
   fprintf(of,  "=" );
   acon( p );
  }
  return;
   }
 case REG:
  fprintf(of,  "%s", (p->tn.rval > R7 ? "sp." : rnames[p->tn.rval] ));
  return;
 case OREG:
  v = p->tn.lval;
  switch(p->tn.rval){
  case R1:
  case R2:
  case R3:
   break;
  case AUTO_P:
   fprintf(of, "aut%d.+", ftnno);
   break;
  case TMP_P:
   fprintf(of, "tmp%d.+", ftnno);
   break;
  case CALL_P:
   fprintf(of, "call.+");
   break;
  case ARG_P:
   fprintf(of, "arg%d.+", ftnno);
   break;
  }
  scon( p );
  fprintf(of,  ",%s", (p->tn.rval > R7 ? "sp." : rnames[p->tn.rval] ));
  return;
 default:
  cerror( "illegal address" );
  return;
 }
}
scon( p ) register NODE *p;
{ /* print out a "short" constant */
 /* for address field in instruction. */
 /* Not to be confused with "short" data type */
 CONSZ  v, top, mask;
 v = p->tn.lval;
 mask = 0x7FFFF;
 top = v & ~mask;
 if( v < 0 ) {
  if( top != ~mask )
   cerror("scon: negative offset");
  acon(p);
 }
 else {
  if( top != 0 )
   cerror("scon: offset too big");
  if (p->in.name[0] == 0 && v % 4 == 0) fprintf(of, "%ldw", v/4);
  else acon( p );
 }
}
acon( p ) register NODE *p;
{ /* print out a constant */
 if( p->in.name[0] == '\0' ){
  fprintf(of, "x'%lx'", p->tn.lval);
 }
 else if( p->tn.lval == 0 ) {
  putname(p->in.name);
 }
 else {
  putname(p->in.name);
  fprintf(of,  "+" );
  fprintf(of,  CONFMT, p->tn.lval );
 }
}
putname(s)
char *s;
{
 int i;
 for(i=0; i < NCHNAM && *s; i++)
  fprintf(of, "%c", *s++);
}
genscall( p, cookie ) register NODE *p;
{
 /* structure valued call */
 return( gencall( p, cookie ) );
}
int arglock = 0;
gencall( p, cookie ) register NODE *p;
{
 /* generate the call given by p */
 register NODE *p1, *ptemp;
 register temp;
 register fort;
 if(odebug) {
  fprintf(of, "gencall(%x, ", p);
  prcook( cookie );
  fprintf(of, "):\n");
  fwalk(p, eprint, 0);
 }
 fort = 0;
 if( p->in.right ) temp = argsize( p->in.right );
 else temp = 0;
 argcnt = 0;
 if (p->in.op == FORTCALL || p->in.op == UNARY FORTCALL){
  fort = 1;
  temp += 8;
 }
 if( p->in.op == STCALL || p->in.op == UNARY STCALL ){
  /* set aside room for structure return */
  if( p->stn.stsize > temp ) temp = p->stn.stsize;
 }
 if( temp > maxargs ) maxargs = temp;
 SETOFF(temp,8);
 if( p->in.right ){
     /* make temp node, put offset in, and generate args*/
  ptemp = talloc();
  ptemp->in.op = OREG;
  ptemp->tn.lval = 0;
  if (fort) ptemp->tn.lval += 4; /* room for aRG COUNT */
  ptemp->tn.rval = CALL_P;
  MVNAME(ptemp->in.name, "");
  ptemp->in.rall = NOPREF;
  ptemp->in.su = 0;
  if (fort) p->in.right = fortaddr( p->in.right );
        /* insert address nodes for Fortran */
  if(arglock++) {
   cerror("Bad gencall");
  }
  else {
   genargs( p->in.right, ptemp );
   arglock=0;
  }
  ptemp->in.op = FREE;
 }
 p1 = p->in.left;
 if( p1->in.op != ICON ){
  if( p1->in.op != REG ){
   order( p1, INBREG );
  }
 }
 if(p1->in.op == REG && !isbreg( p1->tn.rval )) {
  order(p1, INBREG);
 }
 /*
  fprintf(of,  " la %%5,(.F%d-%d)(%%15)\n", ftnno, temp + SAVEREGION );
 */
 if (fort)
  p->in.op = UNARY FORTCALL;
 else
  p->in.op = UNARY CALL;
 if(odebug) {
  fprintf(of, "gencall(), before match:\n");
  fwalk( p, eprint, 0 );
 }
 return( match( p, INTAREG|INTBREG ) != MDONE );
}
NODE *
fortaddr( p ) NODE *p;
/* insert U& nodes for Fortran arguments */
{
 NODE * pa, *pcv;
 if (p->in.op == CM){
  p->in.left = fortaddr(p->in.left);
  p->in.right = fortaddr(p->in.right);
  return(p);
 }
 argcnt += 4;
 if (p->in.op == UNARY MUL){
  /* we can remove it because OREG's are already created */
  p->in.op = FREE;
  pa = p->in.left;
 }
 else {
  pa = talloc();
  pa->in.op = UNARY AND;
  pa->in.left = p;
  pa->in.type = INCREF( p->in.type );
 }
 switch( p->in.type ){
 case CHAR:
 case SHORT:
 case USHORT:
  /*
   case LONG:
   case DOUBLE:
  */
  pcv = talloc();
  pcv->in.op = PCONV;
  pcv->in.left = pa;
  pcv->in.type = pa->in.type;
  return(pcv);
 }
 return(pa);
}
char *
ccbranches[]  = {
 " beq L.%d\n",
 " bne L.%d\n",
 " ble L.%d\n",
 " blt L.%d\n",
 " bge L.%d\n",
 " bgt L.%d\n",
};
cbgen( o, lab, mode ) { /*   printf conditional and
                      unconditional branches */
 register t;
 t = cbsetflg;
 cbsetflg = 0;
 if( o == 0 ) fprintf(of,  " bu L.%d\n", lab );
 else if ( t ){
  if (o == NE || o == GT)
   fprintf(of, " bs L.%d\n", lab);
  else fprintf(of, " bns L.%d\n", lab);
 }
 else {
  /* Output same branch instruction for signs & unsigns */
  if(o <= UGT && o >= ULE) o -= (UGT-GT);
  else if( o > GT ) cerror( "bad conditional branch: %s", opst[o] );
  fprintf(of,  ccbranches[o-EQ], lab, lab );
 }
}
nextcook( p, cookie ) NODE *p;
{
 /* we have failed to match p with cookie; try another */
 if( cookie == FORREW ) return( 0 );  /* hopeless! */
 if( !(cookie&(INTAREG|INTBREG)) ) return( INTAREG|INTBREG );
 if( !(cookie&INTEMP) && asgop(p->in.op) )
          return( INTEMP|INAREG|INTAREG|INTBREG|INBREG );
 return( FORREW );
}
lastchance( p, cook ) NODE *p;
{
 /* forget it! */
 return(0);
}
#ifndef ONEPASS
char *sourcefile = "<stdin>";
main(argc, argv) int  argc;
char       *argv[];
{       /* control multiple files */
 register    i;
 register char  *cp;
 char *cp1, *cp2;
 extern unsigned int     offsz;
 int         fdef = 0;
 char       *release = "";
 curfc = textfc = datafc = sdatafc = dclfc = symfc = stdout;
 infc = stdin;
 for (i = 1; i < argc; ++i) {
  if (*(argv[i]) != '-')
   switch (fdef++) {
   case 0:
    /* stdout appended to 1st file arg */
    if(freopen(argv[i],"a",stdout) == NULL) {
     fprintf(stderr, "ccom:can't open %s\n",
      argv[i] );
     exit(1);
    }
    break;
   case 1:
    /* sdatafc and datafc become 2nd file arg */
    datafc = sdatafc = fopen(argv[i], "w");
    if(sdatafc == NULL) {
     fprintf(stderr, "cant open file %s\n",
      argv[i]);
     exit(1);
    }
    break;
   case 2:
    /* take input from third file arg */
    sourcefile=argv[i];
    infc = fopen(argv[i], "r");
    if(infc == NULL) {
     fprintf(stderr, "c2:can't open %s\n",
      argv[i] );
     exit(1);
    }
    break;
   } /* end switch */
 } /* end for */
 exit(mainp2(argc, argv));
}
#endif
special (p, shape )
NODE *p;
{
 static lasttype = CHAR;
 int i;
 int tp;
 int shp;
 int val;
 tp = lasttype;
 if(sdebug) fprintf(of,"special(%x, %o) op= %s\n", p, shape,
                     opstri(p->in.op));
 lasttype = p->in.type;  /*This is to help with bit instructs */
 if (p->in.op == REG){
  switch( shape ){
  case SREG0:
   return( p->tn.rval == R0);
  case SREG1:
   return( p->tn.rval == R1);
  case SSTK:
   return( p->tn.rval > R7);
  }
  return(0);
 }
 shp = shape & ~SPECIAL;
 val = p->tn.lval;
 switch(p->in.op) {
 case ICON:
  if(shp&SICON) return(1);
  if(p->in.name[0]) return(0);
  if ((shp&SCONH) && ishalfcon(val) ) return(1);
  if((shp&SPOW2) && (i=ispow2(val)) >= 0 && i <= bsiztyp(tp))
   return(1);
  if( (shp&SCON5) && (val & ~0x1F) == 0 ) return(1);
  return(0);
 case OREG:
  i = p->tn.lval;
  if((shp&SOREGH) && i >= 0 && ishalfcon(i))  return(1);
  return(0);
 case NAME:
  i = p->tn.lval;
  if((shp&SNAMEH) && i >= 0 && ishalfcon(i))  return(1);
  return(0);
 }
 return(0);
}
#ifndef ONEPASS
ispow2( c ) CONSZ c;
{
 CONSZ b;
 register i;
 if(c&(c-1)) return(-1);
 b = 1;
 for( i=0; c!=b; i++) b <<= 1;
 return(i);
}
#endif
ishalfcon( c ) CONSZ c;
{
 if(c < 0 || c >= 0x8000) return(0);
 else return(1);
}
bsiztyp( t ) /* return size in bits of basic types */
{
 if (ISPTR( t )) return(32);
 switch( t ){
 case CHAR:
 case UCHAR:
  return(8);
 case SHORT:
 case USHORT:
  return(16);
 case INT:
 case UNSIGNED:
  return(32);
 case LONG:
 case DOUBLE:
  return(64);
 }
 return(0);
}
FILE *
swfc( fc )
FILE *fc;
{
 register FILE *i;
 i = of;
 of = fc;
 return(i);
}
tlen(p) NODE   *p;
{
 switch (p -> in.type) {
 case CHAR:
 case UCHAR:
  return(1);
 case SHORT:
 case USHORT:
  return(2);
 case LONG:
 case DOUBLE:
  return(8);
 default:
  return(4);
 }
}
