
diff(1)                                                   diff(1)

NAME
       diff - differential file comparator

SYNOPSIS
       diff [ -bitw ] [ -C|-h ] filename1 filename2
       diff [ -bitw ] [ -C number ] filename1 filename2
       diff [ -bitw ] [ -D string ] filename1 filename2
       diff [ -bitw ] [ -C|-h ] [-l] [-r][-s] [ -S
       name ] directory1 directory2

DESCRIPTION
       diff tells what lines must be  changed  in  two  files  to
       bring them into agreement.  If filename1 (filename2) is -,
       the standard input is used.  If filename1 (filename2) is a
       directory,  then  a  file  in that directory with the name
       filename2 (filename1) is used.  The normal output contains
       lines of these forms:

            n1 a n3,n4
            n1,n2 d n3
            n1,n2 c n3,n4

       These lines resemble ed commands to convert filename1 into
       filename2.  The numbers after the letters pertain to file-
       name2.   In  fact, by exchanging a for d and reading back-
       ward one may ascertain equally how  to  convert  filename2
       into  filename1.  As in ed, identical pairs, where n1 = n2
       or n3 = n4, are abbreviated as a single number.

       Following each of these lines come all the lines that  are
       affected  in  the  first  file  flagged by <, then all the
       lines that are affected in the second file flagged by >.
  
       -b     Ignores  trailing  blanks  (spaces  and  tabs)  and
              treats other strings of blanks as equivalent.

       -i     Ignores  the case of letters; for example, `A' will
              compare equal to `a'.

       -t     Expands TAB characters in output lines.  Normal  or
              -C  output  adds  character(s) to the front of each
              line that may adversely affect the  indentation  of
              the original source lines and make the output lines
              difficult to interpret.  This option will  preserve
              the original source's indentation.

       -w     Ignores  all  blanks (SPACE and TAB characters) and
              treats all other strings of blanks  as  equivalent;
              for  example, `if ( a == b )' will compare equal to
              `if(a==b))'.

       -q     Give a quick difference indication.   0 is returned
              if files are identical, else a 1 is returned.

       -C number
              Produces a listing of differences with number lines
              of context.  With this option output format is mod-
              ified slightly: output begins  with  identification
              of  the  files  involved  and their creation dates,
              then each change is separated  by  a  line  with  a
              dozen  *'s.   The  lines removed from filename1 are
              marked with '--';  those  added  to  filename2  are
              marked  '+'.   Lines that are changed from one file
              to the other are marked in both files with '!'.  If
              number is not specified, the default is three lines
              of context.

       Except in rare circumstances, diff finds a smallest suffi-
       cient set of file differences.

       -h     Does a fast, half-hearted job.  It works only  when
              changed stretches are short and well separated, but
              does work on files of unlimited length.

       -D string
              Creates a merged version of filename1 and filename2
              with C preprocessor controls  included  so  that  a
              compilation  of  the result without defining string
              is equivalent to compiling filename1, while  defin-
              ing string will yield filename2.

       The following options are used for comparing directories:

       -l     Produce output in long format.   Other  differences
              are remembered and  summarized after  all text file
              differences are reported.

       -r     Applies  diff  recursively to common subdirectories
              encountered.

       -s     Reports files that are the identical;  these  would
              not otherwise be mentioned.

FILES
       temp files D??????
       /system/bin/diffh for -h

SEE ALSO
       cmp.m

DIAGNOSTICS
       Exit status is 0 for no differences, 1  for  some  differ-
       ences, 2 for trouble.

NOTES
       Editing  scripts  produced  under  the -e or -f option are
       naive about creating lines consisting of a  single  period
       (.).

DIFF - RCS - DIFF             J B Systems                05/30/95

