/*~!date.c*/
/* Name:  date.c Part No.: _______-____r
 *
 * Copyright 1995 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"Make4MPX $Id: date.c,v 1.2 1995/03/14 04:03:41 jbev Exp $"

/* $Log: date.c,v $
 * Revision 1.2  1995/03/14  04:03:41  jbev
 * Correct external errorrs.
 *
 * Revision 1.1  1995/03/14  01:29:22  jbev
 * Initial revision
 *
 */

/*
 *	date - with format capabilities
 */

#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <fcntl.h>

#define	year_size(A)	(((A) % 4) ? 365 : 366)

static char buf[100];
static time_t	clock_val;
static short month_size[12] = { 
    31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };


static char *usage =
 "usage: date [-u] [+format] [hhmm | mmddhhmm[[cc]yy]]\n";
int uflag;
char *ap;

main(argc, argv)
int argc;
char **argv;
{
    register struct tm *tp;
    char *fmt = (char *)NULL;

    /*  Initialize variables  */

    (void)time(&clock_val);

    if (argc > 1) {
    	if (strcmp(argv[1], "-u") == 0) {
    	    argc--; 
    	    argv++;
    	    uflag++;
    	} 
    }
    if (argc > 1) {
    	if (*argv[1] == '+')
    	    fmt = &argv[1][1];
    	else if (setdate(localtime(&clock_val), argv[1]))
    	    exit(1);
    }

    if (uflag) {
    	tp = gmtime(&clock_val);
    	ascftime(buf, "%a %b %e %H:%M:%S GMT %Y", tp);
    } else {
    	tp = localtime(&clock_val);
    	ascftime(buf, fmt, tp);
    }

    puts(buf);

    exit(0);
}

extern time_t timezone;
extern time_t altzone;

setdate(current_date, date)
struct tm *current_date;
char *date;
{
    register int i;
    int mm, dd = 0, hh, min, yy, wf = 0;
    int minidx = 6;

    /*  Parse date string  */
    switch (strlen(date)) {
    case 12:
    	yy = atoi(&date[8]);
    	date[8] = '\0';
    	break;
    case 10:
    	yy = 1900 + atoi(&date[8]);
    	date[8] = '\0';
    	break;
    case 8:
    	yy = 1900 + current_date->tm_year;
    	break;
    case 4:
    	yy = 1900 + current_date->tm_year;
    	mm = current_date->tm_mon + 1; 	/* tm_mon goes from 1 to 11*/
    	dd = current_date->tm_mday;
    	minidx = 2;
    	break;
    default:
    	(void) fprintf(stderr, "date: bad conversion\n");
    	return(1);
    }
    min = atoi(&date[minidx]);
    date[minidx] = '\0';
    hh = atoi(&date[minidx-2]);
    date[minidx-2] = '\0';
    if (!dd) {
    	/* if dd is 0 (not between 1 and 31), then 
		 * read the value supplied by the user.
		 */
    	dd = atoi(&date[2]);
    	date[2] = '\0';
    	mm = atoi(&date[0]);
    }
    if (hh == 24)
    	hh = 0, dd++;

    /*  Validate date elements  */
    if (!((mm >= 1 && mm <= 12) && (dd >= 1 && dd <= 31) && 
      (hh >= 0 && hh <= 23) && (min >= 0 && min <= 59))) {
    	(void) fprintf(stderr, "date: bad conversion\n");
    	return(1);
    }

    /*  Build date and time number  */
    for (clock_val = 0, i = 1970; i < yy; i++)
    	clock_val += year_size(i);
    /*  Adjust for leap year  */
    if (year_size(yy) == 366 && mm >= 3)
    	clock_val += 1;
    /*  Adjust for different month lengths  */
    while (--mm)
    	clock_val += (time_t)month_size[mm - 1];
    /*  Load up the rest  */
    clock_val += (time_t)(dd - 1);
    clock_val *= 24;
    clock_val += (time_t)hh;
    clock_val *= 60;
    clock_val += (time_t)min;
    clock_val *= 60;

    if (!uflag) {
    	/* convert to GMT assuming standard time */
    	/* correction is made in localtime(3C) */

    	clock_val += (time_t)timezone;

    	/* correct if daylight savings time in effect */

    	if (localtime(&clock_val)->tm_isdst)
    	    clock_val = clock_val - (time_t)(timezone - altzone);
    }

    if (stime(&clock_val) < 0) {
    	(void) fprintf(stderr, "date: no permission\n");
    	return(1);
    }
    return(0);
}

