boot-mop = false

config-access-control-enabled = true
config-access-control-list = {
	{ blade42	tcpip }
}
config-auto-save-file = false

diag-access-control-enabled = true

# Allow no other hosts to start local clients.
exec-access-control-enabled = true
exec-access-control-list = {
}

# This exec-startup-command will send a direct query to the specified host.
#	{ "login blade42" }
# This exec-startup-command will pop up the setup window right away.
#	{ "setup" }
# This exec-startup-command will send a broadcast query for an xdm session.
# What to do with the response is ruled by the value of login-xdm-broadcasts.
#	{ "login" }
exec-startup-commands = {
	{ "login blade42" }
}

file-manager-access-control-enabled = true

# All these ip*router and ip*gateway things seem to concern only booting.
ip-use-router-discovery = false
ip-use-router-solicit = false
ip-initial-default-gateway-1 = 192.168.104.1
#ip-initial-default-gateway-2 = 158.121.1.1
# This table download seems to perform an append rather than an overwrite.
# Anyway it used to work to get packets out when we used campus.1.1.
ip-routing-table = {
  { 0.0.0.0 192.168.104.1 -1 static local 225 -1 network 0x0 }
}

# { 0.0.0.0 158.121.104.40 -2 static local 225 -1 network 0x0 }
# { 127.0.0.1 127.0.0.1 0 static local 830 -1 host 0xffffffff }


#login-default-hosts = {
#	{ tcp	blade42	 "xterminal support host" }
#}
login-xdm-action-on-disconnect = logout
login-xdm-broadcasts = ignore
# DFLT login-xdm-broadcasts = prompt
#      login-xdm-broadcasts is moot when the host is hardwired
#                           in the exec-startup-commands table.
# prompt         makes broadcast, collects responses into a chooser window.
# use-first      makes broadcast, gets xdm service from first respondant.
# ignore    suppresses broadcast, offers only login-default-hosts.

# pref-font-path should match xserver-default-font-path, else we have fonts
# not found after the first XDMCP session exits.
pref-font-path = {
	{ "built-ins" }
	{ "/usr/lib/X11/ncd/fonts/pcf/misc" }
	{ "/usr/lib/X11/ncd/fonts/pcf/75" }
}
pref-xserver-graphics-optimizations = false

serial-access-control-enabled = true

snmp-read-only-access-control-enabled = true
snmp-read-only-access-control-list = {
	{ blade42       }
}
snmp-read-write-access-control-enabled = true
snmp-read-write-access-control-list = {
	{ blade42       }
}


###tcpip-dns-default-domain = cs.umb.edu
tcpip-name-server-protocol = dns
# Things sort of mostly work when list below is commented-out.
# I suppose the terminal sends another bootp request asking for the nameservers.# it takes some seconds, and a chooser box flashes on the screen for a second
# before it disappears and the xdm login box appears.
tcpip-name-servers = {
   { 192.168.105.40 }
}
###{ 158.121.104.33 }

unit-query-for-name-at-boot = tcpip

xserver-access-control-enabled = true
xserver-access-control-enabled-default = true
# Leave this list empty so MAGIC-COOKIE will be used.
xserver-access-control-list = {
}
# Below list is good for 15r and MCX under 3.3.2
xserver-default-font-path = {
	{ "built-ins" }
	{ "/usr/lib/X11/ncd/fonts/pcf/misc" }
	{ "/usr/lib/X11/ncd/fonts/pcf/75dpi" }
}
# xserver-retain-font-path MUST be true, else we get the error
# Cannot convert string "<some-font-spec>" to type FontStruct
# The pref-font-path rules; the default-font-path doesn't help.
xserver-retain-font-path = true
