@echo off
REM Multi-HotFix installer
REM By Mark Aggar
REM Copyright Network Computing Devices, Inc 1996,1997
REM v1.5

REM Revision History
REM 1.0 Initial Revision
REM 1.1 Added support to copy HFIX.EXE which comes in *56; Modified USAGE.
REM 1.2 Changed Hotfix selection criteria to WF*.EXE
REM 1.3 Added writable directory check, HotFix list, Reboot message.
REM 1.4 Added looping deletes to overcome SP5 problems
REM 1.5 Added a line to copy the readme.txt from the hotfix to %systemroot%\hotfix\%hfname%.txt

REM This will install all hotfixes from the specified directory.
REM The source directory has to be writable (sorry - can't read from CDROMS this version!)

if "%DEBUG%"=="1" echo on

if "%1"=="_ExPaNd_" goto EXPAND
if "%1"=="/?" goto USAGE
if "%1"=="-h" goto USAGE

for %%i in (HFTEMP HFNAME PROG LOG HFDIR) do set %%i=

set PROG=%0
set HFDIR=%1
set LOG=%SYSTEMROOT%\INSTHF.LOG
if "%HFDIR%"=="" goto USAGE
if not exist %HFDIR%\*.EXE goto NODIR
if not "%HFDIR%"=="." copy %PROG%.cmd %HFDIR% >nul
if not exist %HFDIR%\%PROG%.CMD echo Error: %HFDIR% needs to be writable! - Aborting && goto END

set HFTEMP=%TEMP%\hftemp
if exist %HFTEMP%\*.* echo About to delete temporary HotFix install directory. && del %HFTEMP%\*.* && del %HFTEMP%\*.* && rd %HFTEMP%
if exist %HFTEMP%\*.* echo Files not deleted from %HFTEMP% - Aborting && goto END

md %HFTEMP%
pushd %HFDIR%
for %%i in (WF*.EXE) do call %PROG% _ExPaNd_ %%i
for %%i in (SE*.EXE) do call %PROG% _ExPaNd_ %%i
popd

if "%BADINST%"=="1" echo Bad Installation.  Please check %LOG% for details.
rd %HFTEMP%
if not "%HFDIR%"=="." del %HFDIR%\%PROG%.cmd

hotfix /l

if "%BADINST%"=="" echo Please reboot this WinCenter Host NOW!

goto END


REM ***** Start of Subroutine ******

:EXPAND
if "%DEBUG%"=="1" echo !!!!IN THE SUBROUTINE!!!
if "%BADINST%"=="1" goto END_EXPAND
set HFNAME=%2
echo Copying HotFix %HFNAME% to temporary HotFix install directory...
copy %HFNAME% %HFTEMP% > nul
if not exist %HFTEMP%\%HFNAME% set BADINST=1 && goto END_EXPAND
pushd %HFTEMP%

echo Expanding HotFix %HFNAME%...
echo y | %HFNAME% >> %LOG%
echo Installing HotFix %HFNAME%...
hotfix /i 
REM if errorlevel 1 set BADINST=1 && goto DEL_TEMP
echo %HFNAME% installed. >> %LOG%
if exist README.TXT copy README.TXT %systemroot%\hotfix\%HFNAME%.txt >nul
goto DEL_TEMP

:DEL_TEMP
echo Cleaning up...
copy hotfix.exe %systemroot% > nul
if exist hfix.exe copy hfix.exe %systemroot% >nul
:DEL_LOOP
echo y | del *.* >nul
if exist *.exe goto DEL_LOOP

:END_EXPAND
popd
if "%DEBUG%"=="1" echo !!!!OUT OF SUBROUTINE!!!
echo.
echo.
goto QUIT

REM ***** End of Subroutine *****


:NODIR
echo There is nothing in the %HFDIR% directory.
goto USAGE

:USAGE
echo Multiple HotFix Installer
echo.
echo %0 [dirname]
echo.
echo   dirname  Directory that contains the hotfix(es) you wish to install.
echo            (Use '.' if the hotfixes are in the same directory as %0)
echo.
goto END


:END
for %%i in (HFTEMP HFNAME PROG LOG HFDIR) do set %%i=

:QUIT

