Article Title           : DECW_REMOTE.COM
Creation Date           : unknown
Author                  : outside of NCD
Last Update             : November 11, 1992
Last Update By          : ERW, NCD Technical Support
Expiration Rules        : Applies to VMS DECwindow XUI and Motif indefinitely.
Location		: NCD-Articles/Host_Systems/VMS
=============================================================================

$ !
$ !	DECW_REMOTE.COM - Procedure for starting remote applications.
$ !
$ !	This procedure performs both the sending of the request to a remote node
$ !	and service of such a request from another node by examining the current
$ !	process mode. INTERACTIVE jobs are considered to be sending a remote
$ !	request to another node for an application and NETWORK jobs will service
$ !	remote application requests.
$ !
$ !	This procedure also assumes it is running under FILEVIEW if the OWNER
$ !	of this process is not null. Under FILEVIEW it will, if necessary,
$ !	display pop-up windows to request information and display status.
$ !	If the owner is null, for example it was run under the Session Manager,
$ !	the following parameters are used:
$ !
$ !	P1 - remote node (creates a task-to-task communication to DECW_REMOTE)
$ !	P2 - command to send to remote node
$ !
$ begin:
$	username = f$edit(f$getjpi(0,"username"),"trim")
$	if (username .eqs. "DECNET") then eoj
$	node = f$getsyi("nodename")
$	mode = f$getjpi(0,"mode")
$	if (mode .eqs. "INTERACTIVE") then goto interactive
$	if (mode .eqs. "NETWORK") then goto network
$	write sys$output "This procedure must run as an interactive job to"
$	write sys$output "request remote applications, or as a network job"
$	write sys$output "to service request. The current mode of ''mode'"
$	write sys$output "is not supported."
$	exit
$
$ interactive:
$	set noon
$	if (f$getjpi(0,"owner") .nes. "")
$	   then fileview = "true"
$		vue$suppress_output_popup
$	   else fileview = "false"
$	endif
$
$ i_get_node:
$	if ((p1 .eqs. "") .and. fileview)
$	   then vue$inquire_symbol "NODE Node:"
$		vue$read node
$	   else node = p1
$	endif
$	if (node .eqs. "")
$	   then if (fileview)
$		   then vue$popup_confirm "Node not specified. Try again?"
$			vue$read okay
$			if (okay .eqs. "NO") then exit
$			p1 = ""
$			goto i_get_node
$		   else goto i_finish
$		endif
$	endif
$	node = "''f$edit(node,"upcase")'"
$
$ i_get_command:
$	if ((p2 .eqs. "") .and. fileview)
$	   then vue$inquire_symbol "COMMAND Command:"
$		vue$read command
$	   else command = "''p2'"
$	endif
$	if (command .eqs. "")
$	   then if (fileview)
$		   then vue$popup_confirm "Command not specified. Try again?"
$			vue$read okay
$			if (okay .eqs. "NO") then exit
$			p2 = ""
$			goto i_get_command
$		   else goto i_finish
$		endif
$	endif
$	
$	if (fileview)
$	   then vue$popup_progress_box 20
$		vue$set_task_label "Connecting to ''node'"
$	endif
$
$ i_do_task:
$	if (f$trnlnm("DECW$DISPLAY") .nes. "")
$	   then define/user_mode sys$output nl:
$		show display/symbols
$		remote_node = decw$display_node	! could be 0 too
$	   else remote_node = "0"
$	endif
$	if (remote_node .eqs. "0") then remote_node = f$trnlnm("sys$node")
$	node = node - "::"
$	task_name = "''node'::""task=decw_remote"""
$	open /write /error=i_no_connection link 'task_name'
$	write link "''remote_node'"
$	write link "''command'"
$
$ i_start_status:
$	read/end_of_file=i_failed_start/time_out=10 link status
$	if (status .nes. "START")
$	   then msg = f$fao("!AS NOT started on !AS!/!AS",command,node,status)
$		if (fileview)
$		   then vue$popup_message "''msg'"
$		endif
$	   else if (fileview)
$		   then vue$set_task_label "''node' ''command'"
$			wait 00:00:10.00
$		endif
$	endif
$
$ i_final_status:
$	read/end_of_file=i_failed_final/error=i_failed_final link status
$
$ i_display_final:
$	if (status .nes. "STOP")
$	   then msg = f$fao("!AS on !AS returned:!/!AS",command,node,status)
$		if (fileview)
$		   then vue$popup_message "''msg'"
$		endif
$	endif
$	close/nolog link
$	goto i_finish
$
$ i_finish:
$	exit
$
$ i_failed_start:
$	status = "Server did not respond with START status"
$	goto i_display_final
$
$ i_failed_final:
$	status = "Server did not respond with FINAL status"
$	goto i_display_final
$
$ i_no_connection:
$	message = f$message($status)
$	msg = f$fao("Connection to !AS failed, returned:!/!AS",node,message)
$	if (fileview) then vue$popup_message "''msg'"
$	goto i_finish
$
$ network:
$	on error then goto shutdown
$	open /read /write link sys$net
$	set noon
$	purge /keep=3 netserver.log
$
$ n_remote_node:
$	read /end_of_file=n_shutdown /error=n_shutdown link remote_node
$	if (remote_node .eqs. "") then remote_node = f$trnlnm("sys$rem_node")
$	remote_node = remote_node - "::" + "::"
$
$ n_get_command:
$	read /end_of_file=n_shutdown /error=n_shutdown link command
$	command = "''f$edit(command,"trim,uncomment")'"
$	write link "START"
$	write sys$output "Starting: ''command'"
$	set noon
$	define /nolog sys$error sys$output
$	define decw$display 'remote_node'0.0
$	set display /create /node='remote_node'
$	on error then goto n_shutdown
$	show display
$
$ n_perform_command:
$	set noon
$	''command'
$	status = $status
$	set on
$
$ n_return_status:
$	if (status)
$	   then write link "STOP"
$	   else write link "''f$message(status)'"
$	endif
$
$ n_shutdown:
$	set display /nopermanent
$	close/nolog link
$	eoj
