#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "dm.h"

Widget toplevel;
Display *dpy;
XtAppContext context;

static String fallbacks[] = {
 "xuwdm.selectHost.box.label1.Label: XDM",
 "xuwdm.selectHost.box.label2.Label: Select one of the following",
 "xuwdm.selectHost.box.label3.Label: hosts to begin a session.",
 "xuwdm.selectHost.box.Box.Label.Label: ",
 "xuwdm.selectHost.box.Box.orientation: horizontal",
 "xuwdm.selectHost.box.Box.label.justify: left",
 "xuwdm.logout.command.Label: End X Windows session",
 "xuwdm.logout.command.Font: -adobe-new century schoolbook-*-r-*--*-120-*-*-*-*-*-*",
 "xuwdm.selectHost.box.Label.Font: -adobe-new century schoolbook-*-r-*--*-120-*-*-*-*-*-*",
 "xuwdm.selectHost.box.Box.Label.Font: -adobe-new century schoolbook-*-r-*--*-120-*-*-*-*-*-*",
 "xuwdm.selectHost.box.Box.Command.Font: -adobe-new century schoolbook-*-r-*--*-180-*-*-*-*-*-*",
 NULL
};

Display *
Init (d)
     struct display *d;
{
  static char *argv[] = {"xuwdm", 0};
  static int argc = 1;
  Screen *scrn;
  int i;
  Arg arglist[4];

  XtToolkitInitialize ();
  Debug ("creating application context\n");
  context = XtCreateApplicationContext ();
  XtAppSetFallbackResources (context, fallbacks);
  Debug ("opening display\n");
  dpy = XtOpenDisplay (context, d->name, "xuwdm", "Xuwdm", 0, 0, &argc, argv);
  scrn = DefaultScreenOfDisplay (dpy);

  Debug ("creating shell\n");
  i = 0;
  XtSetArg (arglist[i], XtNscreen, scrn); ++i;
  XtSetArg (arglist[i], XtNargc, argc); ++i;
  XtSetArg (arglist[i], XtNargv, argv); ++i;
  toplevel = XtAppCreateShell ("xuwdm", NULL, applicationShellWidgetClass,
			       dpy, arglist, i);
  return dpy;
}

