/*
 * xsm - session manager
 *
 * $XConsortium: dm.c,v 1.36 90/02/07 18:47:14 keith Exp $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Keith Packard, MIT X Consortium
 */

/*
 * display manager
 */

# include	<stdio.h>
# include	<X11/Xos.h>
# include	<sys/signal.h>
#ifndef sigmask
#define sigmask(m)  (1 << ((m - 1)))
#endif

# include	<sys/stat.h>
# include	<errno.h>
# include	<varargs.h>
#ifdef SYSV
#ifndef F_TLOCK
# include	<unistd.h>
#endif
#endif
# include	"dm.h"

extern int	errno;

extern void	exit (), abort ();

extern void ManageSession ();
extern int LoadDisplayResources ();

#ifndef NOXDMTITLE
static char *Title;
static int TitleLen;
#endif

main (argc, argv)
int	argc;
char	**argv;
{
    int	oldpid, oldumask;
#ifndef SYSV
    static SIGVAL	ChildNotify ();
#endif
    char serverline[220];

    /* make sure at least world write access is disabled */
    if (((oldumask = umask(022)) & 002) == 002)
	(void) umask (oldumask);
#ifndef NOXDMTITLE
    Title = argv[0];
    TitleLen = (argv[argc - 1] + strlen(argv[argc - 1])) - Title;
#endif

    /*
     * Step 1 - load configuration parameters
     */
    InitResources (argc, argv);
    /* SetConfigFileTime? */
    LoadDMResources ();
    if (debugLevel == 0 && getuid () != 0) {
	fprintf (stderr, "Only root wants to run %s\n", argv[0]);
        exit (1);
    }
    if (debugLevel == 0 && daemonMode) BecomeDaemon ();

    if (oldpid = StorePid ()) {
	if (oldpid == -1) LogError ("Can't create/lock pid file %s\n", pidFile);
	else LogError ("Can't lock pid file %s, another xuwsm is running (pid %d)\n", pidFile, oldpid);
	exit (1);
    }
    InitErrorLog ();
    Debug ("Initiating xuwdm dialog.\n");
    CommitToXdmSocket ();
    Debug ("Nothing left to do, exiting.\n");
}

void
StartSession (sock)
	int sock;
{
	char server[200];
	extern struct display *displays;
	struct display *d;
	char *cp;
	static DisplayType acceptableTypes[] =
		{ { Local, Permanent, FromFile },
		  { Foreign, Permanent, FromFile },
		  { Foreign, Transient, FromXDMCP },
		};
#define NumTypes (sizeof (acceptableTypes) / sizeof (acceptableTypes[0]))

	Debug ("Starting session from socket %d\n", sock);
	ReadRemote (sock, server, sizeof (server));
	Debug ("server line: \"%s\"\n", server);
	cp = index (server, ' ');
	++cp;
	cp = index (cp, ' ');
	*cp = (char) 0;
	++cp;
	Debug ("server line: \"%s\"\n", server);
	ParseDisplay (server, acceptableTypes, NumTypes);
	d = displays;
	Debug ("type codes: \"%s\"\n", cp);
	d->displayType.location = (*(cp++) == '1') ? Local : Foreign;
	d->displayType.lifetime = (*(cp++) == '1') ? Permanent : Transient;
	d->displayType.origin = (*(cp++) == '1') ? FromFile : FromXDMCP;
	Debug ("d->name: \"%s\"\n", d->name);
	LoadDisplayResources (d);
	ManageSession (d, sock);
}

static FD_TYPE CloseMask;
static int max;

CloseOnFork ()
{
	int fd;

	for (fd = 0; fd <= max; fd++)
		if (FD_ISSET (fd, &CloseMask))
			close (fd);
	FD_ZERO (&CloseMask);
	max = 0;
}

static int  pidFd;
static FILE *pidFilePtr;

StorePid ()
{
    int		oldpid;

    if (pidFile[0] != '\0') {
	pidFd = open (pidFile, 2);
	if (pidFd == -1 && errno == ENOENT)
	    pidFd = creat (pidFile, 0666);
	if (pidFd == -1 || !(pidFilePtr = fdopen (pidFd, "r+")))
	{
	    LogError ("process-id file %s cannot be opened\n",
		      pidFile);
	    return -1;
	}
	if (fscanf (pidFilePtr, "%d", &oldpid) != 1)
	    oldpid = -1;
	fseek (pidFilePtr, 0l, 0);
	if (lockPidFile)
	{
#if defined (SYSV) || (defined (ibm) && defined (_BSD))
	    if (lockf (pidFd, F_TLOCK, 0) == -1)
	    {
		if (errno == EACCES)
		    return oldpid;
		else
		    return -1;
	    }
#else
	    if (flock (pidFd, LOCK_EX|LOCK_NB) == -1)
	    {
		if (errno == EWOULDBLOCK)
		    return oldpid;
		else
		    return -1;
	    }
#endif
	}
	close(creat(pidFile, 0666));
	fprintf (pidFilePtr, "%d\n", getpid ());
	fflush (pidFilePtr);
    }
    return 0;
}

/*VARARGS*/
SetTitle (va_alist)
va_dcl
{
#ifndef NOXDMTITLE
    char	*p = Title;
    int	left = TitleLen;
    char	*s;
    va_list	args;

    va_start(args);
    *p++ = '-';
    --left;
    while (s = va_arg (args, char *))
    {
	while (*s && left > 0)
	{
	    *p++ = *s++;
	    left--;
	}
    }
    while (left > 0)
    {
	*p++ = ' ';
	--left;
    }
    va_end(args);
#endif	
}
