/* Copyright 1990 Network Computing Devices, Inc.  All rights reserved. */

#ident "@(#)encode.c	13.1	90/08/16"

/*
 * encoding utilities
 *
 * read encoding files
 * convert between encodings
 *
 */

#include	"encode.h"
#include	<stdio.h>


static char	*latin1[] =	{
#include	"iso8859.enc"
	NULL
};

static char	*unknown[] = {
	"UNKNOWN",
	NULL
};

static char	*dectech[] = {
#include	"dectech.enc"
	NULL
};

static char	*symbol[] = {
#include	"symbol.enc"
	NULL
};

static	char	**builtin_encodings[] = {
	latin1,
	unknown,
	dectech,
	symbol
};

#define	NUM_BUILTIN_ENCODINGS	4

#define		TRUE	1
#define		FALSE	0

static	Encoding	encodings[MAX_ENCODINGS];
static	int		num_encodings = 0;

Encoding
read_internal_enc(buf)
char	**buf;
{
int	i = 0;
char	*line;
char	name[256];
Encoding	enc;
int	ent = 0;
int	index;

	if (num_encodings >= MAX_ENCODINGS)	{
		fprintf(stderr, "Help!! too many encodings -- increase the size of MAX_ENCODINGS\n");
		return (Encoding) 0;
	}

	enc = (Encoding) calloc(sizeof(EncodingRec), 1);
	if (!enc)	{
		fprintf(stderr, "failed to allocate encoding\n");
		return (Encoding) 0;
	}
	encodings[num_encodings++] = enc;

	enc->name = MakeAtom(buf[i], strlen(buf[i]) + 1, TRUE);

	for (i = 1; line = buf[i]; i++)	{
		if (line[0] == '#')
			continue;
		if (sscanf(line, "%d%s", &index, name) != 2)     {
			fprintf(stderr, "Bogus encoding @ %d: %s\n", i, line);
			return (Encoding) 0;
		}
		if (index != -1)        {
			enc->char_name[ent] =
				MakeAtom(name, strlen(name) + 1, TRUE);
			enc->index[ent] = index;
			ent++;
		}
	}
	enc->num_encs = ent;
	return enc;
}

Encoding
read_enc_file(fname)
char	*fname;
{
FILE	*fp;
Encoding	enc;
int	line = 0, ent = 0;
char	buf[BUFSIZ];
int	index;
char	name[255];
	
	if ((fp = fopen(fname, "r")) == NULL)	{
		fprintf(stderr, "can't open encoding file:");
		perror(fname);
		return (Encoding) 0;
	}

	if (num_encodings >= MAX_ENCODINGS)	{
		fprintf(stderr, "Help!! too many encodings -- increase the size of MAX_ENCODINGS\n");
		return (Encoding) 0;
	}

	enc = (Encoding) calloc(sizeof(EncodingRec), 1);
	if (!enc)	{
		fprintf(stderr, "failed to allocate encoding\n");
		return (Encoding) 0;
	}

	encodings[num_encodings++] = enc;

	while (fgets(buf, BUFSIZ, fp) != NULL)	{
		if (line++ == 0)	{
			enc->name = MakeAtom(buf, strlen(buf) + 1, TRUE);
			continue;
		}
		if (buf[0] == '#')
			continue;
		if (sscanf(buf, "%d%s", &index, name) != 2)	{
			fprintf(stderr, "Bogus encoding @ %d: %s\n", line, buf);
			return (Encoding) 0;
		}
		if (index != -1)	{
			enc->char_name[ent] = 
				MakeAtom(name, strlen(name) + 1, TRUE);
			enc->index[ent] = index;
			ent++;
		}
	}
	enc->num_encs = ent;
	return enc;
}

char	*
index_to_name(enc, index)
Encoding	enc;
int		index;
{
Atom	n;

	n = index_to_atom(enc, index);
	if (n > 0)
		return (char *)NameForAtom(n);
	else
		return NULL;
}

Atom
index_to_atom(enc, index)
Encoding	enc;
int	index;
{
int	i;

	for (i = 0; i < enc->num_encs; i++)	{
		if (enc->index[i] == index)	{
			return enc->char_name[i];
		}
	}
	return 0;
}

int
name_to_index(enc, name)
Encoding	enc;
char	*name;
{
Atom	n;

	n = MakeAtom(name, strlen(name) + 1, FALSE);
	if (!n)
		return -1;
	return (atom_to_index(enc, n));
}

int
atom_to_index(enc, atom)
Encoding	enc;
Atom	atom;
{
int	i;

	for (i = 0; i < enc->num_encs; i++)	{
		if (enc->char_name[i] == atom)	{
			return enc->index[i];
		}
	}
	return -1;
}

Encoding
find_encoding(name)
char	*name;
{
int	i;
Atom	n;
static	parsed_internal = FALSE;

	if (!parsed_internal)	{
		for (i = 0; i < NUM_BUILTIN_ENCODINGS; i++)	{
			read_internal_enc(builtin_encodings[i]);
		}
		parsed_internal = TRUE;
	}

	n = MakeAtom(name, strlen(name) + 1, FALSE);
	if (!n)
		return (Encoding) 0;
	
	for (i = 0; i < num_encodings; i++)	{
		if (encodings[i]->name == n)	{
			return encodings[i];
		}
	}
	return (Encoding) 0;
	
}
