
/* Copyright 1990 Network Computing Devices, Inc.  All rights reserved. */

#ident "@(#)if.c	13.1	90/07/23"

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

/* derived from "lpf.c	5.3 (Berkeley) 6/30/88" */

/*
 * 	filter which senses PostScript and passes data through
 *	text to PostScript filter.
 */

#include <stdio.h>
#include <signal.h>
#include <sys/wait.h>

#define MAXWIDTH  132
#define MAXREP    10

int	width = 80;	/* default line length */
int	length = 60;	/* page length */
int	indent;		/* indentation length */
int	literal;	/* print control characters */
char	*name;		/* user's login name */
char	*host;		/* user's machine name */
char	*acctfile = 0;	/* accounting information file */
char	*txt_driver = 0;	/* text to PostScript filter */
char	*ps_driver = 0;	/* command to drive printer */
char	*driver = 0;	/* optional driver */
char	*progname;	/* name of this program from argv[0] */

main(argc, argv) 
	int argc;
	char *argv[];
{
	register FILE *p = stdin, *o = stdout;
	FILE *d;
	int i, col;
	char *cp;
	int done, linedone, maxrep;
	char *limit;
	int fchi, chi;
	union wait status;

	progname = argv[0];

#ifdef DEBUG
	stamp (stderr);
	for (i=0; i<argc; i++)
	    fprintf (stderr, "\"%s\" ", argv[i]);
	fprintf (stderr, "\n");
#endif

	while (--argc) {
		if (*(cp = *++argv) == '-') {
			switch (cp[1]) {
			case 'n':
				argc--;
				name = *++argv;
				break;

			case 'h':
				argc--;
				host = *++argv;
				break;

			case 'w':
				if ((i = atoi(&cp[2])) > 0 && i <= MAXWIDTH)
					width = i;
				break;

			case 'l':
				length = atoi(&cp[2]);
				break;

			case 'i':
				indent = atoi(&cp[2]);
				break;

			case 'c':	/* Print control chars */
				literal++;
				break;

			case 't':	/* Command for text */
				argc--;
				txt_driver = *++argv;
				break;

			case 'p':	/* Command for PostScript */
				argc--;
				ps_driver = *++argv;
				break;

			default:
				stamp (stderr);
				fprintf (stderr, "exiting (bad flag %c)\n", cp[1]);
				exit (1);
			}
		} else
			if (acctfile) {
				stamp (stderr);
				fprintf (stderr, "exiting (extra arg %s)\n", cp);
				exit (1);
			}
			acctfile = cp;
	}

	/* Here we have stdin and stdout set by lpd */

	driver = (char *)0;
	fchi = getc (p);
	if ((int)fchi == '%') { /* might be PostScript */
		chi = getc (p);
		if ((int)chi == '!') { /* it is PostScript */
			stamp (stderr);
#ifdef DEBUG
			fprintf (stderr, "passing PostScript through\n");
#else
			fprintf (stderr, "%8s %s\n", name, ps_driver);
#endif
			driver = ps_driver;
		}
		else {
			stamp (stderr);
#ifdef DEBUG
			fprintf (stderr, "filtering to PostScript\n");
#else
			fprintf (stderr, "%8s %s\n", name, txt_driver);
#endif
			driver = txt_driver;
		}
		ungetc ((int)chi, p);
	}
	else {
		stamp (stderr);
#ifdef DEBUG
		fprintf (stderr, "filtering to PostScript\n");
#else
		fprintf (stderr, "%8s %s\n", name, txt_driver);
#endif
		driver = txt_driver;
	}
	chi = fchi;

	if (driver) {
#ifdef DEBUG
		stamp (stderr);
		fprintf (stderr, "opening filter: %s\n", driver);
#endif
		o = d = popen (driver, "w");
		if (d == NULL) {
			stamp (stderr);
			fprintf (stderr, "exiting (popen %s)\n", driver);
			exit (1);
		}
	}

	done = 0;
	while (!done) {
		if (chi == EOF)
			break;
		putc((char)chi, o);
		chi = getc(p);
	}
	fflush (o);

	status.w_status = 0;
	if (driver) {
		status.w_status = pclose (d);
	}

	stamp (stderr);
	fprintf (stderr, "exiting (%d)\n", status.w_retcode);

	exit(status.w_retcode);
}

#include <sys/time.h>

stamp (fd)
    int		fd;
{
	struct tm *tm;
	long now;

	now = time (0);
	tm = localtime (&now);
	fprintf (fd, "%02d%02d%02d %2d:%02d:%02d: %s: ",
	    tm->tm_year, tm->tm_mon, tm->tm_mday,
	    tm->tm_hour, tm->tm_min, tm->tm_sec,
	    progname);
}
