;**********************************************************************
; Z150_VIDEO_EMULATOR: (FUNCTION, PARAMETERS)
;
;	Z150_Video_Emulator provides a LIMITED emulation of the normal
; Z-150 video on the Z-100 compatible Z-319 video board.  It responds
; to the terminal display function, the set-cursor-position call, and 
; it also emulates the erase-page routine by special-casing the 
; clear-screen form of the scroll command.
;**********************************************************************
Z150_VIDEO_EMULATOR PROC NEAR
	PUBLIC	Z150_VIDEO_EMULATOR
	PUSHREG	<BP>
	MOV	BP,AX			;Save the contents of AX in BP
	CMP	AH,10			;Is this a write-character?
	JE	ZVE1			;Yes - display the character
	CMP	AH,9			;Is this a write-char-with-attribute?
	JE	ZVE1			;Yes - display char only
	CMP	AH,14			;Is this a write-terminal-display?
	JNE	ZVE2			;No, check for cursor control
ZVE1:	CALL	MTR_SMART_CRT		;Display the character on the Z-319
	JMP	SHORT ZVE6		;Return
ZVE2:	CMP	AH,2			;Is this a set-cursor-position?
	JNE	ZVE3			;No, continue
	MOV	AL,ESC			;Yes - send out an Escape
	CALL	MTR_SMART_CRT		;Display the Escape
	MOV	AL,'Y'			;Use the set-cursor-position sequence...
	CALL	MTR_SMART_CRT
	MOV	AL,DH
	ADD	AL,' '			;...to set the Z-319's cursor...
	CALL	MTR_SMART_CRT
	MOV	AL,DL
	ADD	AL,' '			;...to the correct position!
	CALL	MTR_SMART_CRT
	JMP	SHORT ZVE6		;Return
ZVE3:	TEST	AH,AH			;Is this a set-video-mode?
	JE	ZVE4			;Yes - just clear the screen
	CMP	AH,6			;Is this a scroll-up command?
	JE	ZVE4			;Yes - clear the entire screen
	CMP	AH,7			;Is this a scroll-down command?
	JNE	ZVE5			;No, check for light pen
ZVE4:	MOV	AL,ESC			;Yes - display the escape sequence...
	CALL	MTR_SMART_CRT
	MOV	AL,'E'			;...which clears the Z-319's screen
	CALL	MTR_SMART_CRT		;Display character on screen
ZVE5:	CMP	AH,4			;Is this a read-light-pen?
	JNE	ZVE6			;No, unsupported function
	CALL	GET_LPEN_STATUS		;Yes - read the light pen
	JMP	SHORT ZVE7		;Return with new info in AH,BX,CH,DX
ZVE6:	MOV	AX,BP			;Restore the contents of AX
ZVE7:	POPREG	<BP>
	RET
Z150_VIDEO_EMULATOR ENDP




