;**********************************************************************
;	  D I S A S S E M B L E R   O P C O D E   T A B L E
;
;	The following table contains the definitions for most of the
; 8088 instructions.  It is accessed by the first byte of the instruc-
; tion, and it contains two fields: a pointer to a text string, and
; a bit-mapped field used to decode the instruction (in the case of
; the ESCape instruction, the test string pointer is used to contain
; the ESCape number).  The layout of the bit-mapped field is as follows:
;
;	    Bit 15:	Direction flag - From = 0, To = 1
;	    Bit 14: 	PC-relative flag (1 = True)
;	    Bit 13: 	Accumulator operation flag (True = 1)
;	    Bit 12-11:	Instruction decode flag:
;			00 = No special decoding necessary
;			01 = MOD/R/M type decoding
;			10 = MOD/REG/R/M decoding
;			11 = Special Instruction
;	    Bit 10:	Immediate constant flag (True = 1)
;	    Bit 9:	Memory reference flag (True = 1)
;	    Bit 8-6:	Type of operation:
;			000 = Untyped
;			001 = Byte
;			010 = Word
;			011 = DWord (Pointer)
;			100 = Unknown type (ie, LEA)
;			101 = Signed byte
;			111 = Constant 1
;	    Bit 5:	Special Instruction (text ptr = Group number)
;	    Bit 4:	Segment register flag
;	    Bit 3-0:	Register involved:
;			0000 - AL
;			0001 - CL
;			0010 - DL
;			0011 - BL
;			0100 - AH
;			0101 - CH
;			0110 - DH
;			0111 - BH
;			1000 - AX
;			1001 - CX
;			1010 - DX
;			1011 - BX
;			1100 - SP
;			1100 - BP
;			1101 - SI
;			1111 - DI
;**********************************************************************
	PUBLIC	OPC_TBL_
OPC_TBL_ EQU THIS BYTE
	DW	ADD_, MODRRMF_ OR BYTE_ OR FROM_	;00H
	DW	ADD_, MODRRMF_ OR WORD_ OR FROM_	;01H
	DW	ADD_, MODRRMF_ OR BYTE_ OR TO_		;02H
	DW	ADD_, MODRRMF_ OR WORD_ OR TO_		;03H
	DW	ADD_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;04H
	DW	ADD_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;05H
	DW	PUSH_, ES_				;06H
	DW	POP_, ES_				;07H
	DW	OR_, MODRRMF_ OR BYTE_ OR FROM_		;08H
	DW	OR_, MODRRMF_ OR WORD_ OR FROM_		;09H
	DW	OR_, MODRRMF_ OR BYTE_ OR TO_		;0AH
	DW	OR_, MODRRMF_ OR WORD_ OR TO_		;0BH
	DW	OR_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;0CH
	DW	OR_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;0DH
	DW	PUSH_, CS_				;0EH
	DW	nil_, 0					;0FH
	DW	ADC_, MODRRMF_ OR BYTE_ OR FROM_	;10H
	DW	ADC_, MODRRMF_ OR WORD_ OR FROM_	;11H
	DW	ADC_, MODRRMF_ OR BYTE_ OR TO_		;12H
	DW	ADC_, MODRRMF_ OR WORD_ OR TO_		;13H
	DW	ADC_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;14H
	DW	ADC_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;15H
	DW	PUSH_, SS_				;16H
	DW	POP_, SS_				;17H
	DW	SBB_, MODRRMF_ OR BYTE_ OR FROM_	;18H
	DW	SBB_, MODRRMF_ OR WORD_ OR FROM_	;19H
	DW	SBB_, MODRRMF_ OR BYTE_ OR TO_		;1AH
	DW	SBB_, MODRRMF_ OR WORD_ OR TO_		;1BH
	DW	SBB_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;1CH
	DW	SBB_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;1DH
	DW	PUSH_, DS_				;1EH
	DW	POP_, DS_				;1FH
	DW	AND_, MODRRMF_ OR BYTE_ OR FROM_	;20H
	DW	AND_, MODRRMF_ OR WORD_ OR FROM_	;21H
	DW	AND_, MODRRMF_ OR BYTE_ OR TO_		;22H
	DW	AND_, MODRRMF_ OR WORD_ OR TO_		;23H
	DW	AND_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;24H
	DW	AND_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;25H
	DW	SEGES_, 0				;26H
	DW	DAA_, 0					;27H
	DW	SUB_, MODRRMF_ OR BYTE_ OR FROM_	;28H
	DW	SUB_, MODRRMF_ OR WORD_ OR FROM_	;29H
	DW	SUB_, MODRRMF_ OR BYTE_ OR TO_		;2AH
	DW	SUB_, MODRRMF_ OR WORD_ OR TO_		;2BH
	DW	SUB_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;2CH
	DW	SUB_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;2DH
	DW	SEGCS_, 0				;2EH
	DW	DAS_, 0					;2FH
	DW	XOR_, MODRRMF_ OR BYTE_ OR FROM_	;30H
	DW	XOR_, MODRRMF_ OR WORD_ OR FROM_	;31H
	DW	XOR_, MODRRMF_ OR BYTE_ OR TO_		;32H
	DW	XOR_, MODRRMF_ OR WORD_ OR TO_		;33H
	DW	XOR_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;34H
	DW	XOR_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;35H
	DW	SEGSS_, 0				;36H
	DW	AAA_, 0					;37H
	DW	CMP_, MODRRMF_ OR BYTE_ OR FROM_	;38H
	DW	CMP_, MODRRMF_ OR WORD_ OR FROM_	;39H
	DW	CMP_, MODRRMF_ OR BYTE_ OR TO_		;3AH
	DW	CMP_, MODRRMF_ OR WORD_ OR TO_		;3BH
	DW	CMP_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;3CH
	DW	CMP_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;3DH
	DW	SEGDS_, 0				;3EH
	DW	AAS_, 0					;3FH
	DW	INC_, AX_				;40H
	DW	INC_, CX_				;41H
	DW	INC_, DX_				;42H
	DW	INC_, BX_				;43H
	DW	INC_, SP_				;44H
	DW	INC_, BP_				;45H
	DW	INC_, SI_				;46H
	DW	INC_, DI_				;47H
	DW	DEC_, AX_				;48H
	DW	DEC_, CX_				;49H
	DW	DEC_, DX_				;4AH
	DW	DEC_, BX_				;4BH
	DW	DEC_, SP_				;4CH
	DW	DEC_, BP_				;4DH
	DW	DEC_, SI_				;4EH
	DW	DEC_, DI_				;4FH
	DW	PUSH_, AX_				;50H
	DW	PUSH_, CX_				;51H
	DW	PUSH_, DX_				;52H
	DW	PUSH_, BX_				;53H
	DW	PUSH_, SP_				;54H
	DW	PUSH_, BP_				;55H
	DW	PUSH_, SI_				;56H
	DW	PUSH_, DI_				;57H
	DW	POP_, AX_				;58H
	DW	POP_, CX_				;59H
	DW	POP_, DX_				;5AH
	DW	POP_, BX_				;5BH
	DW	POP_, SP_				;5CH
	DW	POP_, BP_				;5DH
	DW	POP_, SI_				;5EH
	DW	POP_, DI_				;5FH
	DW	nil_, 0					;60H
	DW	nil_, 0					;61H
	DW	nil_, 0					;62H
	DW	nil_, 0					;63H
	DW	nil_, 0					;64H
	DW	nil_, 0					;65H
	DW	nil_, 0					;66H
	DW	nil_, 0					;67H
	DW	nil_, 0					;68H
	DW	nil_, 0					;69H
	DW	nil_, 0					;6AH
	DW	nil_, 0					;6BH
	DW	nil_, 0					;6CH
	DW	nil_, 0					;6DH
	DW	nil_, 0					;6EH
	DW	nil_, 0					;6FH
	DW	JO_, PC_ OR IMM_ OR SBYTE_		;70H
	DW	JNO_, PC_ OR SBYTE_ OR IMM_		;71H
	DW	JB_, PC_ OR IMM_ OR SBYTE_		;72H
	DW	JAE_, PC_ OR IMM_ OR SBYTE_		;73H
	DW	JZ_, PC_ OR IMM_ OR SBYTE_		;74H
	DW	JNZ_, PC_ OR IMM_ OR SBYTE_		;75H
	DW	JBE_, PC_ OR IMM_ OR SBYTE_		;76H
	DW	JA_, PC_ OR IMM_ OR SBYTE_		;77H
	DW	JS_, PC_ OR IMM_ OR SBYTE_		;78H
	DW	JNS_, PC_ OR IMM_ OR SBYTE_		;79H
	DW	JPE_, PC_ OR IMM_ OR SBYTE_		;7AH
	DW	JPO_, PC_ OR IMM_ OR SBYTE_		;7BH
	DW	JL_, PC_ OR IMM_ OR SBYTE_		;7CH
	DW	JGE_, PC_ OR IMM_ OR SBYTE_		;7DH
	DW	JLE_, PC_ OR IMM_ OR SBYTE_		;7EH
	DW	JG_, PC_ OR IMM_ OR SBYTE_		;7FH
	DW	0, SPECIALF_ OR BYTE_ OR IMM_ OR TO_	;80H
	DW	0, SPECIALF_ OR WORD_ OR IMM_ OR TO_	;81H
	DW	0, SPECIALF_ OR BYTE_ OR IMM_ OR TO_	;82H
	DW	0, SPECIALF_ OR SBYTE_ OR IMM_ OR TO_	;83H
	DW	TEST_, MODRRMF_ OR BYTE_		;84H
	DW	TEST_, MODRRMF_ OR WORD_		;85H
	DW	XCHG_, MODRRMF_ OR BYTE_		;86H
	DW	XCHG_, MODRRMF_ OR WORD_		;87H
	DW	MOV_, MODRRMF_ OR BYTE_ OR FROM_	;88H
	DW	MOV_, MODRRMF_ OR WORD_ OR FROM_	;89H
	DW	MOV_, MODRRMF_ OR BYTE_ OR TO_		;8AH
	DW	MOV_, MODRRMF_ OR WORD_ OR TO_		;8BH
	DW	MOV_, MODRRMF_ OR WORD_ OR SEGREG_ OR FROM_;8CH
	DW	LEA_, MODRRMF_ OR WORD_			;8DH
	DW	MOV_, MODRRMF_ OR WORD_ OR SEGREG_ OR TO_;8EH
	DW	POP_, MODRMF_ OR WORD_			;8FH
	DW	NOP_, 0					;90H
	DW	XCHG_, ACCUM_ OR WORD_ OR CX_ OR TO_	;91H
	DW	XCHG_, ACCUM_ OR WORD_ OR DX_ OR TO_	;92H
	DW	XCHG_, ACCUM_ OR WORD_ OR BX_ OR TO_	;93H
	DW	XCHG_, ACCUM_ OR WORD_ OR SP_ OR TO_	;94H
	DW	XCHG_, ACCUM_ OR WORD_ OR BP_ OR TO_	;95H
	DW	XCHG_, ACCUM_ OR WORD_ OR SI_ OR TO_	;96H
	DW	XCHG_, ACCUM_ OR WORD_ OR DI_ OR TO_	;97H
	DW	CBW_, 0					;98H
	DW	CWD_, 0					;99H
	DW	CALLF_, IMM_ OR DWORD_			;9AH
	DW	WAIT_, 0				;9BH
	DW	PUSHF_, 0				;9CH
	DW	POPF_, 0				;9DH
	DW	SAHF_, 0				;9EH
	DW	LAHF_, 0				;9FH
	DW	MOV_, ACCUM_ OR MEM_ OR BYTE_ OR TO_	;A0H
	DW	MOV_, ACCUM_ OR MEM_ OR WORD_ OR TO_	;A1H
	DW	MOV_, ACCUM_ OR MEM_ OR BYTE_ OR FROM_	;A2H
	DW	MOV_, ACCUM_ OR MEM_ OR WORD_ OR FROM_	;A3H
	DW	MOVSB_, 0				;A4H
	DW	MOVSW_, 0				;A5H
	DW	CMPSB_, 0				;A6H
	DW	CMPSW_, 0				;A7H
	DW	TEST_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;A8H
	DW	TEST_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;A9H
	DW	STOSB_, 0				;AAH
	DW	STOSW_, 0				;ABH
	DW	LODSB_, 0				;ACH
	DW	LODSW_, 0				;ADH
	DW	SCASB_, 0				;AEH
	DW	SCASW_, 0				;AFH
	DW	MOV_, AL_ OR IMM_ OR BYTE_ OR TO_	;B0H
	DW	MOV_, CL_ OR IMM_ OR BYTE_ OR TO_	;B1H
	DW	MOV_, DL_ OR IMM_ OR BYTE_ OR TO_	;B2H
	DW	MOV_, BL_ OR IMM_ OR BYTE_ OR TO_	;B3H
	DW	MOV_, AH_ OR IMM_ OR BYTE_ OR TO_	;B4H
	DW	MOV_, CH_ OR IMM_ OR BYTE_ OR TO_	;B5H
	DW	MOV_, DH_ OR IMM_ OR BYTE_ OR TO_	;B6H
	DW	MOV_, BH_ OR IMM_ OR BYTE_ OR TO_	;B7H
	DW	MOV_, AX_ OR IMM_ OR WORD_ OR TO_	;B8H
	DW	MOV_, CX_ OR IMM_ OR WORD_ OR TO_	;B9H
	DW	MOV_, DX_ OR IMM_ OR WORD_ OR TO_	;BAH
	DW	MOV_, BX_ OR IMM_ OR WORD_ OR TO_	;BBH
	DW	MOV_, SP_ OR IMM_ OR WORD_ OR TO_	;BCH
	DW	MOV_, BP_ OR IMM_ OR WORD_ OR TO_	;BDH
	DW	MOV_, SI_ OR IMM_ OR WORD_ OR TO_	;BEH
	DW	MOV_, DI_ OR IMM_ OR WORD_ OR TO_	;BFH
	DW	nil_, 0					;C0H
	DW	nil_, 0					;C1H
	DW	RET_, IMM_ OR WORD_			;C2H
	DW	RET_, 0					;C3H
	DW	LES_, MODRRMF_ OR DWORD_ OR TO_		;C4H
	DW	LDS_, MODRRMF_ OR DWORD_ OR TO_		;C5H
	DW	MOV_, MODRMF_ OR IMM_ OR BYTE_ OR TO_	;C6H
	DW	MOV_, MODRMF_ OR IMM_ OR WORD_ OR TO_	;C7H
	DW	nil_, 0					;C8H
	DW	nil_, 0					;C9H
	DW	RETF_, IMM_ OR WORD_			;CAH
	DW	RETF_, 0				;CBH
	DW	INT3_, 0				;CCH
	DW	INT_, IMM_ OR BYTE_			;CDH
	DW	INTO_, 0				;CEH
	DW	IRET_, 0				;CFH
	DW	1, SPECIALF_ OR ONEBYTE_		;D0H
	DW	1, SPECIALF_ OR ONEWORD_		;D1H
	DW	1, SPECIALF_ OR BYTE_ OR CL_ OR TO_	;D2H
	DW	1, SPECIALF_ OR WORD_ OR CL_ OR TO_	;D3H
	DW	AAM_, IMM_ OR BYTE_			;D4H
	DW	AAD_, IMM_ OR BYTE_			;D5H
	DW	nil_, 0					;D6H
	DW	XLAT_, 0				;D7H
	DW	ESC_, SPECIALF_ OR UNTYPE_		;D8H
	DW	ESC_, SPECIALF_ OR UNTYPE_		;D9H
	DW	ESC_, SPECIALF_ OR UNTYPE_		;DAH
	DW	ESC_, SPECIALF_ OR UNTYPE_		;DBH
	DW	ESC_, SPECIALF_ OR UNTYPE_		;DCH
	DW	ESC_, SPECIALF_ OR UNTYPE_		;DDH
	DW	ESC_, SPECIALF_ OR UNTYPE_		;DEH
	DW	ESC_, SPECIALF_ OR UNTYPE_		;DFH
	DW	LOOPNE_, PC_ OR IMM_ OR SBYTE_		;E0H
	DW	LOOPE_, PC_ OR IMM_ OR SBYTE_		;E1H
	DW	LOOP_, PC_ OR IMM_ OR SBYTE_		;E2H
	DW	JCXZ_, PC_ OR IMM_ OR SBYTE_		;E3H
	DW	IN_, ACCUM_ OR IMM_ OR BYTE_ OR TO_	;E4H
	DW	IN_, ACCUM_ OR IMM_ OR WORD_ OR TO_	;E5H
	DW	OUT_, ACCUM_ OR IMM_ OR BYTE_ OR FROM_	;E6H
	DW	OUT_, ACCUM_ OR IMM_ OR WORD_ OR FROM_	;E7H
	DW	CALL_, PC_ OR IMM_ OR WORD_		;E8H
	DW	JMP_, PC_ OR IMM_ OR WORD_		;E9H
	DW	JMPF_, IMM_ OR DWORD_			;EAH
	DW	JMP_, PC_ OR IMM_ OR SBYTE_		;EBH
	DW	IN_, ACCUM_ OR DX_ OR BYTE_ OR TO_	;ECH
	DW	IN_, ACCUM_ OR DX_ OR WORD_ OR TO_	;EDH
	DW	OUT_, ACCUM_ OR DX_ OR BYTE_ OR FROM_	;EEH
	DW	OUT_, ACCUM_ OR DX_ OR WORD_ OR FROM_	;EFH
	DW	LOCK_, 0				;F0H
	DW	nil_, 0					;F1H
	DW	REPNE_, 0				;F2H
	DW	REPE_, 0				;F3H
	DW	HLT_, 0					;F4H
	DW	CMC_, 0					;F5H
	DW	2, SPECIALF_ OR BYTE_ OR TO_		;F6H
	DW	2, SPECIALF_ OR WORD_ OR TO_		;F7H
	DW	CLC_, 0					;F8H
	DW	STC_, 0					;F9H
	DW	CLI_, 0					;FAH
	DW	STI_, 0					;FBH
	DW	CLD_, 0					;FCH
	DW	STD_, 0					;FDH
	DW	3, SPECIALF_ OR BYTE_ OR TO_		;FEH
	DW	3, SPECIALF_ OR WORD_ OR TO_		;FFH



;**********************************************************************
;     S P E C I A L   P R O C E S S O R   I N S T R U C T I O N S
;**********************************************************************
	PUBLIC	SP_TBL_
SP_TBL_	EQU	THIS WORD
	DW	 ADD_,   OR_,  ADC_,  SBB_,  AND_,  SUB_,  XOR_,  CMP_
	DW	 ROL_,  ROR_,  RCL_,  RCR_,  SHL_,  SHR_,  NIL_,  SAR_
	DW	TEST_,  NIL_,  NOT_,  NEG_,  MUL_, IMUL_,  DIV_, IDIV_
	DW	 INC_,  DEC_, CALL_,CALLF_,  JMP_, JMPF_, PUSH_,  NIL_



;**********************************************************************
;		I N S T R U C T I O N   N A M E S
;**********************************************************************
	PUBLIC	INSTRUCTION_TBL
	INSTRUCTION_TBL	EQU THIS BYTE
nil_	DB	'??','?' OR 80H
AAA_	DB	'AA','A' OR 80H
AAD_	DB	'AA','D' OR 80H
AAM_	DB	'AA','M' OR 80H
AAS_	DB	'AA','S' OR 80H
ADC_	DB	'AD','C' OR 80H
ADD_	DB	'AD','D' OR 80H
AND_	DB	'AN','D' OR 80H
CALL_	DB	'CAL','L' OR 80H
CALLF_	DB	'CALL','F' OR 80H
CBW_	DB	'CB','W' OR 80H
CLC_	DB	'CL','C' OR 80H
CLD_	DB	'CL','D' OR 80H
CLI_	DB	'CL','I' OR 80H
CMC_	DB	'CM','C' OR 80H
CMP_	DB	'CM','P' OR 80H
CMPSB_	DB	'CMPS','B' OR 80H
CMPSW_	DB	'CMPS','W' OR 80H
CWD_	DB	'CW','D' OR 80H
DAA_	DB	'DA','A' OR 80H
DAS_	DB	'DA','S' OR 80H
DEC_	DB	'DE','C' OR 80H
DIV_	DB	'DI','V' OR 80H
ESC_	DB	'ES','C' OR 80H
HLT_	DB	'HL','T' OR 80H
IDIV_	DB	'IDI','V' OR 80H
IMUL_	DB	'IMU','L' OR 80H
IN_	DB	'I','N' OR 80H
INC_	DB	'IN','C' OR 80H
INT_	DB	'IN','T' OR 80H
INT3_	DB	'INT    03','H' OR 80H
INTO_	DB	'INT','O' OR 80H
IRET_	DB	'IRE','T' OR 80H
JA_	DB	'J','A' OR 80H
JAE_	DB	'JA','E' OR 80H
JB_	DB	'J','B' OR 80H
JBE_	DB	'JB','E' OR 80H
JC_	DB	'J','C' OR 80H
JCXZ_	DB	'JCX','Z' OR 80H
JG_	DB	'J','G' OR 80H
JGE_	DB	'JG','E' OR 80H
JL_	DB	'J','L' OR 80H
JLE_	DB	'JL','E' OR 80H
JMP_	DB	'JM','P' OR 80H
JMPF_	DB	'JMP','F' OR 80H
JNC_	DB	'JN','C' OR 80H
JNZ_	DB	'JN','Z' OR 80H
JNO_	DB	'JN','O' OR 80H
JNS_	DB	'JN','S' OR 80H
JPO_	DB	'JP','O' OR 80H
JO_	DB	'J','O' OR 80H
JPE_	DB	'JP','E' OR 80H
JS_	DB	'J','S' OR 80H
JZ_	DB	'J','Z' OR 80H
LAHF_	DB	'LAH','F' OR 80H
LDS_	DB	'LD','S' OR 80H
LEA_	DB	'LE','A' OR 80H
LES_	DB	'LE','S' OR 80H
LOCK_	DB	'LOC','K' OR 80H
LODSB_	DB	'LODS','B' OR 80H
LODSW_	DB	'LODS','W' OR 80H
LOOP_	DB	'LOO','P' OR 80H
LOOPE_	DB	'LOOP','E' OR 80H
LOOPNE_	DB	'LOOPN','E' OR 80H
MOV_	DB	'MO','V' OR 80H
MOVSB_	DB	'MOVS','B' OR 80H
MOVSW_	DB	'MOVS','W' OR 80H
MUL_	DB	'MU','L' OR 80H
NEG_	DB	'NE','G' OR 80H
NOP_	DB	'NO','P' OR 80H
NOT_	DB	'NO','T' OR 80H
OR_	DB	'O','R' OR 80H
OUT_	DB	'OU','T' OR 80H
POP_	DB	'PO','P' OR 80H
POPF_	DB	'POP','F' OR 80H
PUSH_	DB	'PUS','H' OR 80H
PUSHF_	DB	'PUSH','F' OR 80H
RCL_	DB	'RC','L' OR 80H
RCR_	DB	'RC','R' OR 80H
REPE_	DB	'REP','E' OR 80H
REPNE_	DB	'REPN','E' OR 80H
RET_	DB	'RE','T' OR 80H
RETF_	DB	'RET','F' OR 80H
ROL_	DB	'RO','L' OR 80H
ROR_	DB	'RO','R' OR 80H
SAHF_	DB	'SAH','F' OR 80H
SAR_	DB	'SA','R' OR 80H
SBB_	DB	'SB','B' OR 80H
SCASB_	DB	'SCAS','B' OR 80H
SCASW_	DB	'SCAS','W' OR 80H
SEGES_	DB	'ES',':' OR 80H
SEGCS_	DB	'CS',':' OR 80H
SEGSS_	DB	'SS',':' OR 80H
SEGDS_	DB	'DS',':' OR 80H
SHL_	DB	'SH','L' OR 80H
SHR_	DB	'SH','R' OR 80H
STC_	DB	'ST','C' OR 80H
STD_	DB	'ST','D' OR 80H
STI_	DB	'ST','I' OR 80H
STOSB_	DB	'STOS','B' OR 80H
STOSW_	DB	'STOS','W' OR 80H
SUB_	DB	'SU','B' OR 80H
TEST_	DB	'TES','T' OR 80H
WAIT_	DB	'WAI','T' OR 80H
XCHG_	DB	'XCH','G' OR 80H
XLAT_	DB	'XLAT   BYTE PTR [BX',']' OR 80H
XOR_	DB	'XO','R' OR 80H



;**********************************************************************
;		C P U   R E G I S T E R   N A M E S
;**********************************************************************
__7	DB 'AL',0
__8	DB 'CL',0
__9	DB 'DL',0
__10	DB 'BL',0
__11	DB 'AH',0
__12	DB 'CH',0
__13	DB 'DH',0
__14	DB 'BH',0
__15	DB 'AX',0
__16	DB 'CX',0
__17	DB 'DX',0
__18	DB 'BX',0
__19	DB 'SP',0
__20	DB 'BP',0
__21	DB 'SI',0
__22	DB 'DI',0
__23	DB 'ES',0
__24	DB 'CS',0
__25	DB 'SS',0
__26	DB 'DS',0

	PUBLIC	reg_name_
reg_name_ EQU THIS WORD
	DW	WORD PTR __7
	DW	WORD PTR __8
	DW	WORD PTR __9
	DW	WORD PTR __10
	DW	WORD PTR __11
	DW	WORD PTR __12
	DW	WORD PTR __13
	DW	WORD PTR __14
	DW	WORD PTR __15
	DW	WORD PTR __16
	DW	WORD PTR __17
	DW	WORD PTR __18
	DW	WORD PTR __19
	DW	WORD PTR __20
	DW	WORD PTR __21
	DW	WORD PTR __22
	DW	WORD PTR __23
	DW	WORD PTR __24
	DW	WORD PTR __25
	DW	WORD PTR __26



;**********************************************************************
;		  I N S T R U C T I O N   T Y P E S
;**********************************************************************
	PUBLIC	ins_type_name_
__28	DB 0
__29	DB 'BYTE PTR ',0
__30	DB 'WORD PTR ',0
__31	DB 'DWORD PTR ',0
__32	DB '? PTR ',0
__33	DB 'BYTE PTR ',0

ins_type_name_ EQU THIS WORD
	DW	WORD PTR __28
	DW	WORD PTR __29
	DW	WORD PTR __30
	DW	WORD PTR __31
	DW	WORD PTR __32
	DW	WORD PTR __33



;**********************************************************************
;		  A D D R E S S I N G   M O D E S
;**********************************************************************
	PUBLIC	rm_name_
__35	DB '[BX+SI',0
__36	DB '[BX+DI',0
__37	DB '[BP+SI',0
__38	DB '[BP+DI',0
__39	DB '[SI',0
__40	DB '[DI',0
__41	DB '[BP',0
__42	DB '[BX',0

rm_name_ EQU THIS WORD
	DW	WORD PTR __35
	DW	WORD PTR __36
	DW	WORD PTR __37
	DW	WORD PTR __38
	DW	WORD PTR __39
	DW	WORD PTR __40
	DW	WORD PTR __41
	DW	WORD PTR __42



;**********************************************************************
;		  P R E F I X   B Y T E   T A B L E
;**********************************************************************
	PUBLIC	PREFIX_TBL_
PREFIX_TBL_ EQU THIS BYTE
	DB	26H, 2EH, 36H, 3EH, 0F0H, 0F2H, 0F3H



