#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>


extern errno;

main(argc, argv)
int argc;
char *argv[];
{
	register struct hostent *fhost;
	register char	**alias;
	register int	i;
	struct	in_addr	sa;

	if (argc < 2) {
		printf ("usage: %s host [...]\n", argv[0]);
		exit (1);
	}

	for (i = 1; i < argc; i++) {
		if ((fhost = gethostbyname(argv[i])) == NULL) {
			if ((sa.s_addr = inet_addr(argv[i])) == -1 ||
			    (fhost = gethostbyaddr(&sa, sizeof(sa), AF_INET))
			     == NULL) {
				printf("Don't know host %s\n", argv[i]);
				continue;
			}
		}

		bcopy(fhost->h_addr, &sa, fhost->h_length);
		printf("%s %s", fhost->h_name, inet_ntoa(sa));
		for (alias = fhost->h_aliases; *alias != NULL; alias++)
			printf(" %s", *alias);
		printf("\n");
	}
	exit(0);
}
