/*  Copyright 1985 by Micom-Interlan, Inc. */
/*  See permission and disclaimer notice in file "interlan-notice.h"  */
#include	"interlan-notice.h"

/* 8/10/85 - wrote for interlan ethernet interface.
						<John Romkey>
*/

#include <ether.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>

#define NULL	0

/* This is the network configuration file for the new IP code. This file
	sets up the configuration for a single ethernet interface
	machine. Programs which want to use multiple net interfaces
	should use their own configuration file.
  ***** OF COURSE, PC/IP DOES NOT YET SUPPORT MULTIPLE NET INTERFACES...

*/

int Nnet = 1;		/* The number of networks. */

/* random fnctns. */
int il_init(), il_send(), il_switch(), il_stat(), il_close(), ip_ether_send();

NET nets[1] = { "Interlan Ethernet",	/* interface name */
		il_init,		/* initialization routine */
		il_send,		/* raw packet send routine */
		il_switch,		/* interrupt vector swap routine */
		il_close,		/* shutdown routine */
		ip_ether_send,		/* ip packet send routine */
		il_stat,		/* statistics routine */
		NULL,			/* demultiplexing task */
		NULL,			/* packet queue */
					/* first parameter...*/
#ifdef	WATCH
		ALLPACK,		/* ...promiscuous mode for netwatch */
#endif
#ifndef	WATCH
		0,			/* ...normal mode for others */
#endif
		0,			/* second parameter unused */
		5400,			/* demux task stack size */
		14,			/* local net header size */
		0,			/* local net trailer size */
		0L,			/* ip address */
		0L,			/* default gateway */
		&custom,		/* our custom structure! */
		NULL			/* per interface info */
	};
