@part[tftp, root "manual"]

@string[sectiontitle = "@b<tftp>"]
@newpage

@section[TFTP]
PC/@b[tftp], Version 7.3


A file transfer package for the IBM PC, using the UDP/IP 
protocol.

@Begin[format]
Usage:

@b[tftp] @^[ get ] local-file-name hostname foreign-file-name [octet]
@\[ put ] 
@End[format]

where
@Begin[itemize]
The first argument should be @i[get] to move a file from
another machine to the PC, or @i[put] to move a file from the PC 
to another machine.

@i[local-file-name] is the name of the file in the file system
of the PC.  

@i[hostname] is either a standard character-string name of the
other computer, or the internet address of that computer.  See
the section on hostnames for more details on this argument.

@i[foreign-file-name] is the name of the file in the file
system of the other computer.  Note that the foreign computer 
may require that this file name be "fully qualified," that is 
it may need to include a directory name in idiosyncratic syntax 
in order that the foreign system can identify the wanted file.  
If the foreign file name syntax requires use of characters 
reserved by PC/DOS, then the name must be surrounded by double-
quote marks.  (The PC/DOS reserved characters are greater-than, 
less-than, and reverse slash.)

The optional argument @i[octet] instructs @b[tftp] to move the 
file literally, byte-by-byte, from one computer to the other.  
If this argument is omitted, the file is assumed to be a text 
file, and @b[tftp] automatically performs any necessary character 
set conversions to and from the network standard character set
representation, known as @i[netascii].  For compatibility, PC/@b[tftp]
also accepts the argument @i[image] with the same meaning as 
@i[octet].
@End[itemize]

@subsection[Notes]

Not all hosts implement TFTP service.  It is currently available
on most Multics, PDP-11 UNIX, VAX-UNIX, Alto, IBM PC, and 
TOPS-20 machines attached to the network.

TFTP does not demand a password from the user, so most foreign
hosts are not willing to let just any file be transferred.  As a
general rule, one can move a file from a foreign host if that
file is publicly accessible on that host.  If it is protected
from public access, it is usually protected also from TFTP @i[get]
operations.  Similarly, a file may be moved to directory in a
foreign host only if that host would normally permit anyone to
put files in that directory.  An important restriction that most
hosts enforce is that one may not @i[put] a file on top of an
already-existing file of the same name.  This restriction is
especially important to understand if for some reason a @i"put"
operation fails or is aborted.  Despite the failure, the foreign
host may have created an empty or partial file, with the name
specified.  Another attempt to @i[put] the file with the same name
will then fail because of the access-control restriction.

It is possible to send a file to a printer on a remote PC that is
running the tftp server, by giving a name such as "PRN" or "LPT1" as
the foreign file name.  See the writeup of the tftp server for more
details.

All PCIP packages follow the DOS convention of returning an 
ERRORLEVEL value when they exit.  In the case of PC/@b[tftp], the 
value zero means that the file was successfully transferred, 
while the value one means that some error prevented completion 
of the transfer.  The ERRORLEVEL feature is primarily of use if 
PC/@b[tftp] is invoked as a command from a DOS batch file.

The version of TFTP distributed with Berkeley 4.2 UNIX contains  two
defects that are often noticed only by PC/IP users.  First,  it
ignores the using computer's specification of netascii or  octet mode,
and performs all transfers in octet mode.  Thus when  a text file is
transferred to or from a PC the resulting file is  not translated, and
end-of-line characters are not properly  represented.  Second, if a
single packet sent to the PC gets lost  during the transfer, the 4.2
UNIX TFTP never retries and it ignores  retries from the PC.  Thus the
loss of a single packet guarantees  failure of that file transfer. A
new TFTP which does not have these problems is available on the PC/IP
source release.

See also the writeups of PC/@b[tftp] service and dialup line file
transfer.


16 September 1985.  This document is in file tftp.mss
