@part[telnet, root "manual"]

@string[sectiontitle = "@b<telnet>"]
@newpage

@section[Telnet]
PC/@b[telnet], Version 8.0

A remote login program for the IBM PC, using the TCP/IP protocol
and emulating a display terminal.

@Begin[format]
Usage:

     @b[telnet] hostname
or
     @b[telnet] -p portno hostname
@End[format]

Where @i"hostname" is either a character-string name of the target
host, or an internet address in standard form.  (See the section
on hostnames in the network overview for more details.)  When
used with the "-p" option, the argument @i"portno" is used as a
port number at the target machine.  This feature is used to
connect with certain @b[telnet]-like services available on some
hosts.

From the point of view of the target host, PC/@b[telnet] emulates a
standard "network virtual terminal".  From the point of view of
the keyboard user, PC/@b[telnet] emulates a Heath H19 terminal.
The terminal emulation is only approximate.  A set of conventions
and list of incompatibilities appears on the next page.

Typing the command with the name or internet address of a target
host causes PC/@b[telnet] to try to establish a connection.  When 
that connection is successful, the target host should display 
its greeting banner.  The following conventions apply to the 
translation between H19 emulation and network virtual terminal 
emulation:

@Begin[enumerate]
Function key F10 is an escape used to invoke PC/@b[telnet] functions.
F10 followed by a question mark displays a list of escape sequences.
Others are F10 followed by:
@Begin[description]
a@\Send "Are You There?" inquiry to the target host.

b@\Send "break" to the target host.

c@\Close the connection and exit from @b[telnet].

e@\Send to target on every typed character.

l@\Local echo.  (PC/@b[telnet] echos typed input.)

E@\Send to target only when End-Of-Line is typed.

q@\exit from @b[telnet] without closing connection.

r@\Remote echo.  (Target host echos typed input.)

x@\Send any outstanding data now.

U@\turn on the line-25 clock and status report. (default is on)

u@\turn off the line-25 clock and status report.
@End[description]

Function key F10 is also used to change the mode of operation 
of the terminal emulator within PC/@b[telnet].  These escapes are:
@Begin[description]
B@\Backspace key sends BS, control-backspace sends DEL.

D@\Backspace key sends DEL, control-backspace sends BS.

d@\If output line too long, discard extra characters.

w@\If output line too long, wrap around to next line.
@End[description]

The PC "Print-Screen" feature, triggered by key "PrtSc",
can be used from within PC/@b[telnet], but immediately preceding
its use one must restore the display buffer to the format
expected by PrtSc.  Function key F10 typed twice does this
format adjustment.

F10 also provides some TFTP server commands, discussed below.
@End[enumerate]

@subsection[Closing connections]

At the end of a login session, some hosts will close the  connection,
in which case PC/@b[telnet] exits, returning to PC-DOS.  Other hosts
issue an invitation for  another login.  In the latter case, type F10
followed by "c"  to close the connection and exit from PC/@b[telnet].
Other methods  of exiting, such as F10 followed by "q", or powering
down the PC,  will leave a dangling TCP/Telnet connection that some
hosts may  not clean up properly.  A later attempt to login to that
host  from the same PC may encounter interference from the unclosed
previous connection.

If you close a connection without logging out, most hosts will
deal with the situation in the same way they handle telephone
line hangups.  If you exit @b[telnet] without either logging out or
closing the connection, the host may not realize you are gone,
and there is no way to pick up the connection again.  (The host,
noticing lack of activity for a long time, may eventually log 
you out and close the connection.)

If you try to open a connection to a host that does not respond,
PC/@b[telnet] will try eight times, then display an error message 
and exit.  Note that this message may mean either that the 
target host is not listening to the network or that some network 
or gateway in the communication path to that host has failed.  
(The command PC/@b[ping] may be useful in isolating the trouble.)

Versions of PC/@b[telnet] are available for both local area networks and
serial lines.  On a serial line, at speeds below 9600 baud, the
combination of remote echo and send-on-every-character modes causes
display to fall far behind typed input.  Local echo and
send-on-newline modes are recommended for operation at lower line
speeds.


@subsection[Terminal emulation conventions and compatibility]

The following conventions allow the PC keyboard to behave like
that of a Heath H19:
@Begin[enumerate]
There is no repeat key.  To repeat any key, hold it down.

The function keys are keys F1-F5.

The color keys are F6(blue), F7(red) and F8(gray).

The H19 has separate keys for ASCII "Carriage Return" and
ASCII "Line Feed".  These two functions are combined on 
the PC "Enter" key.  To send an ASCII CR, type "enter".
To send an ASCII LF, type "control-enter".

The H19 has separate keys for ASCII "Backspace" and ASCII
"Delete".  These two functions are combined on the PC 
"back-space" key.  To send ASCII DEL, type "backspace".
To send ASCII BS, type "control-backspace".  A customization
option and an F10 escape allow interchanging backspace and
control-backspace.  For convenience, the keypad key labeled
"Del" also sends an ASCII DEL.

Note that, like it or not, the emulator exactly emulates the
Heath H19 line wraparound feature.  That is, in line wraparound
mode, the emulator automatically goes to the next line after
placing a character in column 80, rather than waiting to see if
the program or typist will try to put something in column 81.
@End[enumerate]

@subsection[Heath H19 features not emulated]
@Begin[format]
@tabdivide[2]
          hold screen/scroll@\keyclick disable
          graphics@\keyboard disable
          shifted keypad@\block cursor
          alternate keypad@\AutoCR
          identify as VT-52@\AutoLF
          transmit page@\transmit 25th line
          offline/online switch@\parity enable
          XOFF/XON flow control@\most ANSI escapes
          control-suppression of transmitting display mgt codes
          restore power-up configuration
          ESC x setting of parameters
          control-space does not send null (but control-2 does)
@End[format]

@subsection(File transfer with PC/telnet)

The PC/@b[tftp] server package can be invoked while using PC/@b[telnet].
With this feature, one can use PC/@b[telnet] to log in to a remote
host, and then move files between that host and the PC, using the
other host's tftp command to control the transfer.  Compared with
initiating the transfer from the PC, this method has two 
advantages:
@Begin[enumerate]
Because the user authenticates himself upon logging in 
to the distant host he can transfer any files to which 
he has access, not just publicly accessible files.

The user can invoke other commands on the distant host
in conjunction with the transfer.  (E.g., compile and
load a program before sending it.)
@End[enumerate]

Seven functions of PC/@b[telnet] support tftp service.  They are
invoked by typing function key F10 followed by:
@Begin[description]
T@\Enable the tftp server. (This is the default mode of operation when
Telnet starts.)

t@\Disable the tftp server (upon completion of any transfer currently in
progress).

i@\Send this PC's internet address, in decimal format, as 
        if it had been typed on the keyboard. This function
        simplifies the issuing of tftp commands on other systems.

o@\Same as i, but send in octal format.

I@\Display this PC's internet address on line 25 in octal 
        and decimal formats.  (For use if the other system needs 
        this address in some odd format.)

y@\Accept a file transfer request.

n@\Refuse a file transfer request.

A@\Accept all file transfer requests, without asking. Typing F10/A
again returns to the normal mode of operation.
@End[description]

When another host requests a file transfer to or from this PC,
the PC/@b[tftp] server asks the PC/@b[telnet] user for permission to
accept the request. (Type F10/y or F10/n.)  For a successful
transfer, the user must accept the request before the remote 
host loses patience, times out, and aborts the transfer.  
Hosts commonly have a 10 to 30 second timeout.

Further information on file transfer may be found in the
description of PC/@b[tftp] service, and in the description of tftp
usage for the remote host.  Some hosts have a tftp command 
that is similar to the PC/@b[tftp] command, so that writeup in 
this manual may offer some help if no other documentation is 
available.


@subsection[Nested calls to the DOS shell]

The PC/@b[telnet] escape F10/! invokes a nested DOS command interpreter,
permitting the user to invoke other DOS commands locally on the PC
without shutting down the @b[telnet] connection.  This feature requires a
configuration of at least 192K bytes of memory, and while running the
nested command interpreter, network commands cannot be used. One
should not stay in DOS for extended periods because while in DOS,
arriving messages are ignored, and if the host at the other end of
the @b[telnet] tries to send such a message it may become impatient with
the lack of response from the PC, and close the connection.  To
return to PC/@b[telnet], issue the DOS command EXIT.


@subsection[Customization]

The following parameters of @b[telnet] can be customized with the
PC/custom command:
@Begin[enumerate]
The parameters for TCP window size and TCP low window
are of particular interest to PC/@b[telnet] users.  If one
is communicating with a mainframe time-sharing system
on the same local area network as the PC, it is
recommended that a window size no larger than 350 bytes
be used, with a low window of 150 bytes.  Use of larger
windows may lead to pauses  when displaying large quantities
of output.  See the description of PC/custom for more
explanation of these parameters.

Start in line-at-a-time mode or character-at-a-time mode.
@End[enumerate]

@subsection[DOS note]

The DOS feature of redirecting output to a file cannot be used
for PC/@b[telnet] display output.

@subsection[Debugging note]

There are several debugging features built in to PC/@b[telnet] that 
can be useful in tracing network problems.  See the section 
"debugging options" for more information.  Function key F10,
followed by control-H, will produce a display of a list of those
options.


16 September 1985.  This document is in file telnet.mss
