@part[setclock, root "manual"]

@string[sectiontitle = "@b<setclock>"]
@newpage

@section[Setclock]
PC/@b[setclock], version 6.1

A program to obtain a clock reading from a network time service
and set the PC date and time accordingly.


@Begin[format]
Usage:

@b[setclock] [time-server]
@End[format]

where @i"time-server" is either a character-string name or an internet
address of a network host that provides an UDP time service.
PC/@b[setclock] sends a request, using the standard UDP time service
protocol, to @i"time-server".  If the name @i"time-server" is omitted,
PC/@b[setclock] sends requests to a default list of internet addresses of
the known time servers. This list is stored within PC/@b[setclock] and
can be set or changed with the customizer.  PC/@b[setclock] takes the
first response, converts the calendar clock reading found therein to
the local date and time and displays it.  Finally, PC/@b[setclock] calls
the standard PC-DOS entry points to set the system date and time.

If the second letter of the customized time zone label is either 's'
or 'S', from the last Sunday in April to the last Sunday in October,
PC/@b[setclock] adjusts the local time one hour forward for Daylight
Savings Time and changes the 's' to 'd' or 'S' to 'D'. 

If no time server responds, or the network is not operational,
PC/@b[setclock] displays a message to that effect and leaves the current
date and time settings of PC-DOS unchanged.

PC/@b[setclock] is designed for use either as a stand-alone command or
as a command invoked by an @i[autoexec.bat] batch file.  There are two
advantages to using PC/@b[setclock] in an @i[autoexec.bat] batch file.
First, DOS does not ask the user to type the date and time on  every
bootload operation.  Second, it provides an immediate test  of whether
or not the network connection is operational.  If  @b[setclock]
receives at least one response, it returns to DOS with  the DOS
variable ERRORLEVEL=0; otherwise ERRORLEVEL=1.


@subsection[Customization]

The following parameters of PC/@b[setclock] can be customized with the
PC/@b[custom] command:
@Begin[itemize]
Local standard time offset, in minutes before GMT.  West of GMT the
value is positive, east of GMT the value is negative.  For EST the
value is +300.  For SET the value is -60.

Local standard time designation string.  Three letters, such as EST,
EDT, or SET.  If the second letter is 's' or 'S' then PC/@b[setclock]
automatically provides Daylight Savings Time during the appropriate
part of the year.

Internet addresses of up to five time servers.  The  servers are
polled at two second intervals in the order  they were set by the
customizer, so one may place  preferred services nearer the head of
the list.
@End[itemize]

21 May 1985.  This document is in file setclock.mss
