@part[overview, root "manual"]

@string[sectiontitle = "Overview"]
@newpage

@section[Overview of PC/IP network programs]


The PC/IP network programs are a set of commands that operate
under the DOS operating system for the IBM Personal Computer.
They provide a set of facilities that make the PC a directly
attachable network host rather than a simulated intelligent
terminal.

The PC/IP programs have their origin in an M.I.T. research
project on protocol effectiveness.  In consequence, they
incorporate several second- and third-generation protocol
implementation techniques and algorithms.  These techniques and
algorithms:
@Begin[itemize]
reduce the processing load on the computer

maximize opportunities for parallel operation of the network and the computer

minimize unnecessary retransmission of data

eliminate certain pathological situations in which 
two technically compatible machines communicate very inefficiently.
@End[itemize]

One result of application of these techniques is that a complete
host implementation can operate with high effectiveness in a
machine as small as the PC.

@subsection[Software environment]

The PC/IP programs are a set of commands that operate under IBM
PC-DOS versions 2.0, 2.1, 3.0, or 3.1.  A device driver must be
installed, but no changes are required to the operating system.
Ethernet versions of the PC/IP programs have been verified to
work under TopView.  

These programs all use the ARPANET standard end-to-end Internet
Protocol, IP, and can be used to communicate with any other host
that also uses that protocol.  Individual commands use various
higher-level ARPANET standard protocols from the IP family, as
appropriate:
@Begin[description]
TCP@\for reliable byte stream transmission

UDP@\for datagram service

Telnet@\for remote login

ICMP@\for control messages

TFTP@\for file transfer

name lookup service protocol

error and event logging protocol

time-of-day and calendar service protocol
@End[description]

Thus these programs are directly useful only in a network
environment where there are other hosts that implement one or
more IP-family protocols  [Thus the programs are not useful on a
network where all other hosts implement only the SNA LU6.2, A.I.
Laboratory CHAOS, DECNET, or Xerox NS protocol families.]  

There is one limitation in the PC/IP protocol implementation that
may affect usage in some environments: reassembly of fragmented
packets is not supported.  If one anticipates communications with 
a host that is accessible only via networks that require small
packets, this limitation may be a problem.

In addition to the protocols mentioned above, PC/IP network 
programs make use, if available, of several network services 
commonly found in IP network environments.  These services 
include:
@Begin[itemize]
name-to-host-address translation service

IP gateways to other IP networks

time-of-day and calendar services

error logging service

printer service
@End[itemize]

If any of these services is not available, it is still possible 
to use the PC/IP network programs, though with loss of certain
convenience features.

@subsection[Hardware environment]

The PC/IP programs operate on a standard IBM PC, PC/XT, or
PC/AT.  They have also been reported to work on a COMPAQ
IBM-compatible PC.  Under DOS 2.0, they require 128 kbytes of
memory, one disk drive, 80-column display (the IBM Monochrome display
card, Color Graphics Adapter or Professional Graphics Adapter)
and any of the following kinds of hardware network attachment:
RS-232 port, Interlan NI5010 Ethernet@footnote[@i{Ethernet} is a
registered trademark of the Xerox Coporation.], 3COM
Etherlink@footnote[@i(Etherlink) is a registered trademark of 3COM
Corporation.] Ethernet (not the new, smart card), or Proteon
proNET@footnote[@i{proNET} is a registered trademark of Proteon, Inc.].

When an RS-232 port is used, the other end of the line can go 
(either by dialup or by direct wiring) to another PC or a
gateway that forwards packets to and from a local area network.  
The link-level protocol used is a non-standard one designed to 
allow flow control, buffer management, and packet-to-packet 
redundancy compression on a full-duplex line.  To simplify 
forwarding of packets destined for an RS-232 attached PC, 
the gateway assigns the internet host address of the PC.  The PC 
asks the gateway for its assigned address using another non-
standard protocol.  The port may be used at any standard 
data rate from 300 bits/sec. to 19.2 kbits/sec.  Note, however, that 
highly interactive services, such as character-at-a-time remote 
echoing, are not every effective at data rates below 9.6 kbits/sec.  
The RS-232 port does not work under TopView at speeds of 
9.6 kbits/sec. and higher.

The Ethernet versions of the PC/IP programs provide a driver for the
Interlan NI5010 interface and the 3COM Etherlink interface@footnote[The
PC/IP Etherlink driver does not use the 3COM software or device driver,
and it does not require that hardware switches be set to simulate
availability of four disk drives.  However, if the environment
contains the 3COM software or switch settings, the PC/IP Ethernet
driver will still operate correctly.]. Since Ethernet addresses do not
map directly into internet host addresses, the Ethernet driver uses
ARP, the IP standard Ethernet-to-Internet address translation
protocol.  If this protocol is not implemented by other hosts, it is
possible, by use of a customization option, to supply manually a
limited number of Ethernet-to-Internet address bindings.

The proNET versions of the PC/IP programs provide a driver for
the Proteon, Inc., proNET ring interface.  

There are four versions of each PC/IP command, one version
for each of kind of network interface supported.

@subsection[Customization]

A customization program, named @b"custom", sets certain parameters
in a DOS device driver that is used by each PC/IP network
program.  Some of these parameters, such as serial line speed,
cannot otherwise be discovered by the software. Others, such as
the preferred modes of operation of the remote login program,
depend on characteristics of the distant host most often used. 
Still others, such as the internet addresses of name servers, 
are site-dependent.  Details of which parameters may be set for 
each program are found in the descriptions of the individual 
programs and in the description of custom.


26 September 1985.  This document is in file overview.mss
