@part[otherdoc, root "manual"]

@string[sectiontitle = "Other Documentation"]
@newpage

@section[Other documentation]


This section provides an annotated list of other documents that
describe or pertain to PC/IP.

1)   Saltzer, J.H., et al., "The Desktop Computer as a Network 
     Participant,"  IEEE Selected Areas in Communications, May,
     1985, pp 468-478.

Discussion of the implementation may be found in:

2)   Romkey, John L., "PC/IP Programmer's Manual"

The following undergraduate thesis describes the first
implementation of a file transfer protocol package.  Although
that package has been superseded, there are still several points
of design strategy that carry over into various PC/IP packages.

3)   Wright, Karl D., "A File Transfer Program for a Personal
     Computer,"  S. B. Thesis, M.I.T. Department of Electrical
     Engineering and Computer Science, April, 1982.  Also
     available as M.I.T. L.C.S. Technical Memorandum TM-217.

The following undergraduate thesis describes the TCP/Telnet
package.  This package is still in use, though the thesis
describes an early implementation.

4)   Konopelski, Louis J., "Implementing Internet Remote
     Login on a Personal Computer,"  S. B. Thesis, M.I.T.
     Department of Electrical Engineering and Computer
     Science, December, 1982.  Also available as M.I.T.
     L.C.S. Technical Memorandum TM-233.

Much of the PC/IP implementation was influenced by the ideas
of David D. Clark documented in the "Internet Protocol
Implementation Guide," August, 1982, SRI International, Menlo
Park, California.  Five parts of this document are of 
particular interest:

@Begin[format]
5)   Window and Acknowledgement Strategy in TCP (RFC 813)
6)   Names, Addresses, Ports and Routes (RFC 814)
7)   IP Datagram Reassembly Algorithms (RFC 815)
8)   Fault Isolation and Recovery (RFC 816)
9)   Modularity and Efficiency in Protocol Implementation (RFC 817)
@End[format]

The protocols used in the PC/IP packages are specified in the
"Internet Protocol Transition Workbook", March, 1982, available
from SRI international.  The particular protocol documents are:

@Begin[format]
10)  Internet Protocol (RFC-791)
11)  Internet Control Message Protocol (RFC-792)
12)  User Datagram Protocol (RFC-768)
13)  Transmission Control Protocol (RFC-793)
14)  Telnet Protocol (RFC-764)
15)  Trivial File Transfer Protocol (RFC-783)
16)  Name Server Protocol (IEN-116)
17)  Time Server Protocol (RFC-868)
18)  Nicname/Whois server (RFC-812)
19)  Echo Protocol (RFC-862)
@End[format]

One other protocol is described in the ARPANET Protocol 
handbook of January, 1978:

20)  Finger protocol (NIC-42758 or RFC-742)

The domain name system and name resolution protocol are described in
the following documents:

21) Domain Names - Concepts and Facilities (RFC-882)

22) Domain Names - Implementation Specification (RFC-883)

The Supdup remote login protocol is described by Mark Crispin in:

23) Supdup (RFC 734)

The 4.2 Unix printer spooling protocol is described in the PC/IP
Programmer's Manual mentioned above, and is also described by Ralph
Campbell in:

24) 4.2BSD Line Printer Spooler Manual (Unix documentation)

The subnet routing scheme used by PC/IP is described by Jeff Mogul and
Jon Postel in:

25) Internet Standard Subnetting Procedure (RFC 950)

The method for encapsulating IP packets on an ethernet is as specified
by Charles Hornig in:

26) A Standard for the Transmission of IP Datagrams over Ethernet
Networks (RFC 894)

The Address Resolution Protocol, used only by the ethernet drivers, is as
specified by David Plummer in:

27) An Ethernet Address Resolution Protocol (RFC 826)

The protocol used to send files to the Imagen print server is
described in:

28)  Imprint-10 Programmer's Manual, Imagen Corp. April, 1984.

The following document describes a transcription of PC/IP into
Pascal, for use on the Apple Macintosh computer and Applebus:

29)  Sherman, Mark, "A Network Package for the Macintosh using 
     DoD Internet Protocols," Department of Mathematics and 
     Computer Science, Dartmouth College, New Hampshire.


29 December 1985.  This document is in file otherdoc.mss
