@part[netname, root "manual"]

@string[sectiontitle = "@b<netname>"]
@newpage

@section[Netname]
PC/@b[netname], version 1.0


A package to look up the internet address that corresponds to a
character string name, using the UDP domain name protocol.

@Begin[format]
Usage:

     @b[netname] [-a] [-t timeout] name [domain-name-server]
@End[format]

Where @i"name" is the character string host name to be resolved. If
no domain name server is specified, @b[netname] sends an inquiry
to each customized domain name server, and displays all responses.
The optional argument -a causes netname to display application trace 
information that may help in discovering obscure problems in name server
tables.  The optional argument -t causes the next argument to be used as 
the timeout, in seconds, before giving up on the name server.  The default
timeout is 20 seconds.

If @i"name" contains at least one period character, @b[netname]
assumes it to be a complete domain name and sends it unchanged to the
domain server.  If @i"name" contains no period characters, !b[netname]
appends to it the customized default domain name for this PC.

There are three possible results of a name inquiry:
@Begin[enumerate]
An internet address.

The response "name not known"

No response.
@End[enumerate]

Each network node has a primary name, and may also have any number of
secondary names.  @b[PC/netname] accepts inquiries for both primary
and secondary names.  If the name requested is a secondary one,
@b[netname] reports the primary name as part of the response.

In the second form, above, @i"domain-name-server" is an optional
argument that identifies a specific domain name server that is to be
invoked to resolve the name @i"name".  @i"domain-name-server" may be
either a character string name (in which case it is resolved using the
customized name servers) or an internet address in standard form.

The section on host names, domain names, and internet addresses
provides more information on the resolution of host names.  This
command is useful primarily for trouble isolation when one suspects
that name tables may be inconsistent or incorrect.

@subsection[Customization]
@Begin[itemize]
Default domain name.  Appended to any name that contains no period
characters.

List of domain name servers.

Application trace.  If the APTRACE debugging flag is on, @b[PC/netname]
displays details of the name server response.

@End[itemize]

22 February 1986.  This document is in file netname.mss
