@part[custom, root "manual"]

@string[sectiontitle = "@b<custom>"]
@newpage

@section[Custom]
PC/@b[custom], version 2.2

A command to customize the PC/IP environment, allowing setting of
parameters that describe the network environment and preferred
option settings.

@Begin[format]
Usage:

     @b[custom] netdev [model]
@End[format]

begins customization of the device description found in the file
named @i"netdev.sys".  When finished customizing, custom rewrites
the file netdev.sys with the new parameters in place.  The
customizer is menu-driven and self-explanatory.  If a second
argument is given, custom reads the values of the customization
parameters of the command found in the file @i"model.sys" and uses
them as initial values.  It then enters the usual starting menu
so that the user can review the result.

For simplicity and uniformity, the one device driver contains the
customization parameters for all network levels and all commands.
For example, one can set serial line parameters even though the
PC/IP commands to be used contain an Ethernet driver.  It is not
necessary to specify values for customization parameters that
will not be used.  For example, if the command PC/@b[setclock] will
not be used, one need not specify the internet addresses of time
servers. 

Note that customizing the file @i[netdev.sys] will have no effect
until the next time DOS is bootloaded.  See the writeup entitled
"software installation" for more details.

@subsection[Standard customization parameters]

There are several customization parameters that are applicable to
all or several different PCIP commands.  Customization parameters
that apply to just one command are described in the writeup of
that command.

Site customization to match network hardware options, switch
settings, and parameters:

@Begin[itemize]
Serial line speed.  Can be set to any baud rate from 110 to 19,200.
(Needs to be set only for serial line use.)

Interrupt vector for network interface.  Should be set to correspond
to the interrupt vector number that the hardware interface will use.
The PC/IP serial line driver ignores this entry.

Receive and transmit DMA channels for network interface.  Should be
set to correspond to the DMA channel that the hardware interface will
use. Most hardware only supports a single DMA channel for both receive
and transmit; if that is the case, both should be set to the same
value. The proNET interface @i[does] support separate channels. The
DMA channel can also be set to 0 if no DMA should be used; a tight
loop will be used instead to copy data to or from the interface. (The
serial line driver does not use DMA at all). Under some circumstances,
using a copy loop can be faster than using DMA (for instance, on the
PC/AT).

Network interface I/O address.  Should be set to match the I/O base
address used by the network hardware.  Default is  0300 (Hex).

@Begin[multiple]
Ethernet address.  One can set the Ethernet address in one of three ways:
@Begin[enumerate]
to the Ethernet address found on the network interface card,

to an Ethernet address derived from the internet address by
concatenating 16 leading zero bits,

to an arbitrary Ethernet address specified to the customizer.
@End[enumerate]

One should normally use the first option; the others are 
available to deal with non-standard Ethernet environments.
@End[multiple]

Number of network interfaces.  This parameter is currently  not used;
it is provided for future implementation of  multi-network attachment.
@End[itemize]

@subsection[Site customization of network level parameters]
@Begin[itemize]
Internet address of this computer.  (Not needed for serial line use.)

Internet address of default IP gateway.  (Not needed for serial line
use.)

Internet addresses of up to two IP non-domain name servers. These are
old-style, IEN-116 name servers.

Internet addresses of up to three IP domain name servers.

The text name of the machine's domain. This name is used by the domain
name resolver. When asked to resolve a name that is not fully
qualified (no domain is specified), the resolver will append this name
to given name.

Internet addresses of up to five time servers.  The servers are polled
at two second intervals in the order they were set by the customizer,
so one may place  preferred services nearer the head of the list.
(Needed only by PC/@b[setclock].)

Internet address of a print server.  (Needed only by  PC/@b[iprint]
and PC/@b[lpr].)

Internet address of an IP log server.  If this address is non-zero,
some PC/IP commands send error-logging or statistics-gathering packets
to this address.  For  privacy, the address may be set to 0,0,0,0, in
which  case all logging is suppressed.

Up to three initial values for Ethernet-to-Internet address cache.
(Needs to be set only for Ethernet use and when the environment does
not provide the proper protocol.)  IP addresses are entered in
standard octal or decimal form.  Ethernet addresses are entered as 6
octal byte values (each between 0 and 377) separated by commas.

TCP window size and low window level.  These two parameters affect the
performance and smoothness of flow of data in  commands such as
Telnet.  The window size is the count,  in bytes, of the maximum
amount of data that another host  should send to the PC without
waiting for authorization to  send more.  If not customized, its
default value is 450  bytes.  One might make this value smaller if
there is a  gateway with limited buffering ability in the pathway
between the PC and a commonly-used host, or if talking to a host on
the same local area network.  The low window  level is the trigger
point at which the PC sends  authorization to send more data to the
other host.  If not  customized, its default value is 200 bytes.  If
there is a  long round-trip delay to a commonly-used host, one might
adjust this value so as to just fill up the pipeline from that host.
The low window level must be less than the  window size, and the
window size must be less than 2000  bytes.

Telnet transmission trigger.  Can be set to send every character as it
is typed (necessary if using a  character-based remote echo system) or
to send a batch of typed characters only when a newline character is
typed  (less demanding on the remote system.)

First RVD drive.  This parameter is provided for a future feature.

Number of subnet bits.  This parameter determines how many bits,
following the network part of an IP address, are used to identify the
attached subnetwork.  PC/@b[custom] displays on octal "subnet mask" that
is derived from the IP address and the number of subnet bits.  This
feature is used in a simple way, as follows: when an IP packet is to
be sent from the PC, its IP destination address is masked with the
subnet mask.  The part of the destination address that is revealed by
the subnet mask is then compared with the corresponding part of the
PC's own IP address.  If the revealed sections of the two addresses are
different, the destination is assumed to be on another subnetwork, and
the routing layer sends the packet to the default gateway.  If the
revealed sections are the same, the destination is assumed to be on
the same local area network as the PC itself, and the concealed
portion of the destination address is used by the network layer to
construct the proper physical address  (perhaps using an Address
Resolution Protocol).  If  subnetwork routing is not in use, an extent
of zero is appropriate.  At M.I.T. the subnetwork routing scheme uses
8 bits for subnetwork identification.
@End[itemize]

@subsection[Personal customization of terminal emulation options]
@Begin[itemize]
Action on lines too long to fit on screen.  Discard mode places all
excess characters in column 80.  Wraparound mode places excess
characters on next line.

Swap interpretation of backspace with control-backspace.  (See telnet
description of emulation conventions for further information.)
@End[itemize]

@subsection[Other parameters]
@Begin[itemize]
User's name. This is a character string that is included in error
logging messages and is placed in headers of files sent to a print
server.  May be set to (or left) blank.

Internet address output radix. This parameter controls whether
numeric internet addresses are printed in decimal (for instance,
18.10.0.65) or octal (22,32,0,101). Numeric addresses can always
be input in either radix.

Debug options.  There are several options that turn on various degrees
of progress reports, tracing, and otherwise suppressed error messages.
These options are of interest primarily to system programmers.  One
normally sets them to "all off". (See the section @i[Debugging
Options] for more details.)

Local standard time offset, in minutes before GMT.  West of GMT the
value is positive, east of GMT the value is negative.  For EST the
value is +300.  For SET the value is -60 in the winter.

Local standard time designation string.  Three letters, such as EST,
EDT, or SET.  (Note that if the middle letter of the time zone
designation string is "s" or "S" PC/@b[setclock] will automatically do
daylight-savings-time conversion.)
@End[itemize]


@subsection[On-the-fly error correction]

Errors in typing names and addresses can be corrected with the
following common editing conventions:  The backspace key discards
the last character typed, while Control-U discards the entire
name or address typed so far, allowing one to start over.


@subsection[Temporary customization]

The command
@Begin[format]
     @b[custom] netcust
@End[format]

will recustomize the currently active device driver, which is 
named @i"netcust:".  Customization of @i[netcust] takes effect 
immediately, rather than at next bootload, and is lost when the 
next bootload takes place.  Temporary customization of the 
active device driver is sometimes useful in debugging, for
example to turn on a tracing option for a while.  Note that for 
temporary customization to work there must be an already-present 
active device driver, previously loaded by DOS.


17 January 1986.  This document is in file custom.mss
