@part[where, root "progman"]

@appendix[Where to get things]
@tag[where-to]

This appendix briefly lists sources for programs and documentation.
All the information presented here is slightly unstable: it may change
in time. The information presented below was valid as of @value[date].

@section[PC/IP]

This section tells where to get different versions of the PC/IP
release itself.

@subsection[MIT PC/IP]

You can order PC/IP from the MIT Microcomputer Center in one of two
forms: a pair of diskettes with executable 3COM ethernet programs, or
a 1600bpi Unix tar tape with full PC/IP sources (@i[not] the cross
compiler). As of this writing, the diskette cost $12 and the tape $55.
Both come with a user's manual and the availability notice; the tape
also comes with this programmer's manual and an article explaining
@i[why] certain things were done certain ways @cite[desktop]. You
should call ahead to verify the prices. The address is:
@Begin[format]
	MIT Microcomputer Center
	Room 11-209
	77 Massachusetts Avenue
	Cambridge, MA  02139

	Telephone (617) 253-6325
@End[format]

The source and binaries are also available via anonymous FTP from
@i[borax.lcs.mit.edu]. If you pick up a copy of them via FTP, please
send mail to @i[pcip-release@@borax.lcs.mit.edu] so that we can keep
track of who has copies (we do this for several reasons - one is to
let you know about bug fixes, updates and new releases - another is to
justify continued work on PC/IP).

Proteon and Interlan both distribute executable programs with drivers for
their network interfaces. Prices for these distributions will vary.
They also distribute the source tape.

@subsection[Proteon]

ProNet binaries are available from Proteon, Inc. You should contact
John Shriver there for more information.
@Begin[format]
	John Shriver
	Proteon, Inc.
	4 Tech. Circle,
	Natick, MA	01760

	Arpanet address: jas@@proteon.arpa (soon to be proteon.com)

	Telephone (617) 655-3340
@End[format]

@subsection[Interlan]

Interlan NI5010 Ethernet binaries are distributed by the MIT
Microcomputer Center along with 3COM ethernet binaries.
For more information on the Interlan NI5010 ethernet interface, you
can contact Bob Ryan there for more information.
@Begin[format]
	Bob Ryan
	Micom-Interlan, Inc.
	155 Swanson Rd.
	Boxborough, MA  01719

	Telephone (617) 263-9929
@End[format]

@subsection[3COM]

We have no contact for PC/IP at 3COM. Their address and telephone
number are:
@Begin[format]
	3COM Corporation
	1365 Shorebird Way
	Mountain View, CA   94039

	Telephone (415) 961-9602
@End[format]

@subsection[FTP Software]

Several of the original authors of PC/IP have formed FTP Software,
Inc. to commercially sell and support PC/IP. FTP sells a package based
the current release, with enhancements (FTP, multiple connection TCP,
better display support, Berkeley utilities, Microsoft C compilation,
etc.). For more information, contact:
@Begin[format]
	FTP Software, Inc.
	PO Box 150
	Kendall Square Branch
	Boston, MA  02142

Phone (617) 868-4878
@End[format]

@subsection[CMU PC/IP]
@i[This section was edited together out of a note Drew Perkins sent
many people about his port of PC/IP.]

Drew Perkins (DP4Q@@TE.CC.CMU.EDU) did a port of PC/IP to Microsoft C.
At last check, his port of the code is somewhere between the January
1985 release and this release. Drew's US Mail address is:
@Begin[format]
Drew Perkins
co Carnegie-Mellon University
4910 Forbes Ave.
Pittsburgh, PA 15213
@End[format]

To get Drew's port, connect to @i[vd.cc.cmu.edu] with FTP.  Login in as
user @i[anonymous], password @i[guest].  Next, GET the following files in
netascii mode: install.msc install.bat

GET the rest of the files in octet/binary mode:
@Begin[format]
tarread.exe
include.tar
srclib1.tar
srclib2.tar
srccmd.tar
@End[format]

Once you have these on your local machine, use TFTP or some other file
transfer program to get them to your PC.  Put the files under a subdirectory
such as \pcip.  Make sure you do the transfers in the proper mode (octet or
ascii, as above).  The file install.msc explains what you have.  Last,
just type 'install' and the batch job will do the rest.  The program
tarread.exe is a very small tar file reading program that I wrote.  It
has very few features, but it serves the purpose here.  The
distribution is broken up so that it can fit it on floppy's for
transfer if necessary.

@subsection[Macintosh PC/IP]

PC/IP has also been ported to the Apple Macintosh@cite[mac]. For more
information, contact Mark Sherman at Dartmouth.

@begin[format]
	Mark Sherman
	Computer Network Laboratory
	Department of Mathematics and Computer Science
	Dartmouth College
	Hanover, NH  03755

	(603) 646-2415
	mss@@Dartmouth.CSNet
@end[format]

@section[PC/IP Mailing List]

There is now an arpanet mailing list for PC/IP users. It's being run
by the University of Delaware. The request address is
@i"pcip-request@@huey.udel.edu"; the mail address is
@i"pcip@@huey.udel.edu".

An archive of the mailing list is available via anonymous FTP
from @i[udel.edu] in the directory @i[/pcip]. Some program source code
might be in this directory, too.

@section[CC86 Cross Compiler]

See the PC/IP availability notice, available from the MIT
Microcomputer Center, for information on getting the cross compiler.

@section[TCP/IP Documents]

@subsection[NIC RFC's]

Many RFC's (Request For Comments) are cited in this document. RFC's
are published by the Network Information Center (the NIC) and often
specify protocols or discuss networking problems, or issues of
interest to the Internet community. They can be ordered via US Mail
from this address:
@Begin[format]
	SRI International (SRI-NIC)
	Telecommunications Sciences Center
	Network Information Center
	333 Ravenswood Avenue
	Menlo Park, California 94025

	Telephone: (415) 859-3695
@End[format]

or you can get them over the Arpanet via anonymous FTP. FTP to host
@i[nic] and look in @i[netinfo:].

@subsection[MIT RFC's]

MIT-LCS-DCS RFC's are distributed locally by the Distributed Computer
Systems research group at the MIT Laboratory for Computer Science.
They are sited in the manual with authors' permission. Copies can be
obtained by contacting Dr. David Clark or his secretary.
@Begin[format]
	Dr. David Clark
	545 Technology Square, Rm 540
	Cambridge, MA	02139

	Dr. Clark's telephone number is (617) 253-6003.
	His secretary's telephone number is (617) 253-6002.
@End[format]
