@part[udpfuns, root "progman"]

@chapter[Name Resolution, Time Service, and Remote Logging]

This chapter describes the implementations of the host name resolution
protocol, the time service protocol, and the remote logging protocol. Almost
all programs make use of the name resolution protocol to allow the user to
specify foreign host names in the command line.

@section[Domain name resolution]

PC/IP includes an implementation of a domain name resolver (see
@cite[domain1, domain2]). This domain name resolver depends on the
foreign server supporting recursion, and suffers from @c[cname]
disease - it fails when a server returns a response providing only a
@c[cname] specification and no address.

The resolver provides a single function:
@Begin[verbatim]
in@us()name dm@us()resolve(name, server)
	char *name;
	in@us()name server;
@End[verbatim]

Using the domain name resolution protocol, this routine requests
@i[server] to resolve hostname @i[name]. Error returns are the same as
those for @i[udp@us()name()].

@section[Name resolution]

The name resolution protocol used is described in @cite[nameuser]. It will
poll up to five name servers as listed in the custom structure.

A problem is corrected from old releases of the system, where only a single
name could be resolved during a program run.

Descriptions of functions in the name resolution code follow.

@b[Note that the @i{nm@us2()init()} call is new.]

@subsection{@i[nm@us2()init()]}

@begin[verbatim]

nm@us()init()

@end[verbatim]

This routine initializes the name user package. It must be called before
@i[udp@us2()name()] or @i[resolve@us2()name()] is called. After it has been
called, up to five UDP connections will be open. The name user code leaves
these connections open until the program terminates.

@subsection{@i[udp@us2()name()]}

@begin[verbatim]

in@us()name udp@us()name(name)
	char *name;

@end[verbatim]

This routine attempts to resolve the textual @i[name] of a host into an
Internet address, which it returns, by polling name servers. The list of
name servers is found in the @i[custom] structure and can be initialized by
using the customizer. If the name cannot be resolved, the routine returns
@c[NAMEUNKNOWN]. If no name servers responded, it returns @c[NAMETMO]. These
values are defined in @i[<udp.h>]. Otherwise, it returns the Internet
address of the host.

The routine @i[nm@us2()init()] must be called before @i[udp@us2()name()] is
called.

@subsection{@i[resolve@us2()name()]}

@begin[verbatim]

in@us()name resolve@us()name(host)
	char *host;

@end[verbatim]

This routine attempts to resolve the textual host name @i[host] into an
Internet address. It checks if the name is an octal address of the form
@i[n,s,r,h] or a decimal address of the form @i[n.s.r.h] or a hexadecimal
address of the form @i[#hex-addr]. If it is, @i[resolve@us2()name()] parses
the name and returns the address. If it is not, @i[udp@us2()name()] is
called and its result is returned.

The routine @i[nm@us2()init()] must be called before @i[resolve@us2()name()]
is called.

@section[Time service]

The time user provides time service as specified in @cite[timeuser]. Up to
five time servers are polled, as specified in the custom structure.

@subsection{@i[udptime()]}

@begin[verbatim]

long udptime(optional@us()server, maxpoll)
	in@us()name optional@us()server;
	int maxpoll;

@end[verbatim]

This function polls name servers and returns the first response it receives,
or 0L if it there is a timeout. If @i[optional@us2()server] is 0, then the
first @i[maxpoll] servers from the custom structure are polled. If
@i[optional@us2()server] is non-zero then it is used as the address of the
server to poll, and @i[maxpoll] is ignored.

@section[Remote Logging]

Not to be confused with @i[remote login](say them aloud). This protocol is
described in @cite[log], although only the logging part of the protocol has
been implemented. Thus far, there only exists one server implementation for
this protocol, but user implementations are in place in the C Gateway, the
MIT Proteon ring network monitoring station, the MIT TFTP spooler, and the
PC code.

The logging code generally allows errors and other useful information to be
logged. The log server is specified in the custom structure. Currently no
programs use the logging functions. They're frequently useful in debugging,
though, especially when the machine will be untended for a long time and a
disk file isn't sufficient or can't be used (in RVD, for instance).

Use of the logging code seems to be a bit troublesome unless there is a
straightforward way to turn off logging (which there is - set the log server
address to 0). Some construe it as an invasion of privacy, and a record of
when and why they used their PC's. Others (myself included) view it as a way
of keeping track of how their programs are functioning, if disastrous
internal errors have occurred which might be indicative of bugs, and where
the code might need a little tuning up. The moral is to think twice before
putting logging code in a program that will be distributed.

Descriptions of functions in the logging code follow.

@subsection{@i[LogInit()]}

@begin[verbatim]

LogInit()

@end[verbatim]

Initializes the logging system. This function should be called before the
logging system is used.

@subsection{@i[log()]}

@begin[verbatim]

log(logname, format)
	char *logname;
	char *format;

@end[verbatim]

This call sends a logging packet to the log server. The packet is for the
log @i[logname] and contains a message specified by @i[format]. This
argument is actually a set of arguments; @i[log()] will accept the same
arguments here that @i[printf()] will. What the logging server actually does
with the request depends on the server.

The packet is sent with the no acknowledgment option on, so all logging is
unreliable.
