@part[udp, root "progman"]

@chapter[UDP]

The UDP code implements the standard DoD UDP protocol@cite[udp]. Checksums
are generated on all outgoing packets and verified on incoming packets.

@section[Include Files and Libraries]

Programs which call UDP functions should include the file @i[<udp.h>].
They should also link in the library @i[udp].

@section[UDP Calls]

Descriptions of functions in UDP follow.

@subsection{@i[udp@us2()init()]}

@begin[verbatim]

UdpInit()

@end[verbatim]

Initialize the UDP layer. This function should be called before any other
function in UDP.

@subsection{@i[udp@us2()open()]}

@begin[verbatim]

UDPCONN udp@us()open(fhost, fsock, lsock, handler, hint)
	in@us()name fhost;
	unsigned fsock;
	unsigned lsock;
	int (*handler)();
	unsigned hint;

@end[verbatim]

Open a UDP connection on local port @i[lsock]. When any packets are received
for this socket, the routine @i[handler] will be called. It will be passed
the following arguments:
@begin[verbatim]
	(*handler)(p, length, host, hint)
		PACKET p;
		unsigned length;
		in@us()name host;
		unsigned hint;

@end[verbatim]
where @i[length] is the size of the contents of the UDP packet which was
received.

No demultiplexing is done on @i[fhost] or @i[fsock] (as per the UDP spec).
They are specified only for convenience when sending packets; it is possible
the implementation should be modified so that the @i[udp@us2()write()] call
takes these as arguments.

The argument @i[hint] can be ignored if desired. It is useful in
code which has multiple UDP connections open, all being serviced by one
routine, such as a server tftp.

@subsection{@i[udp@us2()close()]}

@begin[verbatim]

udp@us()close(con)
	UDPCONN con;

@end[verbatim]

Closes the UDP "connection" named by @i[con]. The port associated with it
will no longer be listened on; any packets received for it will generate
ICMP destination unreachables. The storage allocated for the connection will
be deallocated.

@subsection{@i[udp@us2()socket()]}

@begin[verbatim]

unsigned udp@us()socket()

@end[verbatim]

This function returns a number which is a valid unique local UDP socket.

@subsection{@i[udp@us2()table()]}

@begin[verbatim]

udp@us()table()

@end[verbatim]

This routine dumps information about all the active UDP "connections" to
standard output. It includes the address of the handler and the unsigned
integer value of the hint, both in hex.

@subsection{@i[udp@us2()write()]}

@begin[verbatim]

udp@us()write(udpcon, p, len)
	UDPCONN udpcon;
	PACKET p;
	unsigned len;

@end[verbatim]

This call writes a UDP packet @i[p] to the net. It fills in the UDP header
and passes the packet to internet. The size of the UDP data in the packet is
@i[len] bytes. The destination and foreign socket are found from the
connection @i[udpcon].

@subsection{@i[udp@us2()send@us2()to()]}

@begin[verbatim]

udp@us()send@us()to(host, fport, lport, p, len)
	in@us{}name host;
	unsigned fport;
	unsigned lport;
	PACKET p;
	unsigned len;

@end[verbatim]

This is a more general form of @i[udp@us2()write()]. It allows you to
specify the destination Internet address (@i[host]) and @c[UDP] port
number (@i[fport]), as well as the port number which the packet was sent
from (@i[lport]). This is much more efficient than having to open a new
@c[UDP] connection to send one packet to another host. The application
cannot, however, receive packets on the specified local port unless it
has done a @i[udp@us2()open()] on that port.

@begin[b]
The following functions are actually macros, from the file @i[<udp.h>].
@end[b]

@subsection{@i[udp@us2()alloc()]}

@begin[verbatim]

PACKET udp@us()alloc(size, optsize)
	unsigned size;
	unsigned optsize;

@end[verbatim]

This routine allocates a packet buffer big enough for packet with @i[size]
bytes of UDP data and @i[optsize] bytes of internet options. It returns the
@i[PACKET] or @i[NULL] if no packet could be allocated.

@subsection{@i[udp@us2()free()]}

@begin[verbatim]

udp@us()free(p)
	PACKET p;

@end[verbatim]

This routine frees a packet previously allocated by @i[udp@us2()alloc()].

@subsection{@i[udp@us2()head()]}

@begin[verbatim]

struct udp *udp@us()head(pip)
	struct ip *pip;

@end[verbatim]

This function, when given a pointer to an internet header, returns a pointer
to the UDP header which would immediately follow that internet header. To
get a pointer to the UDP header of a packet, you would have to do this:
@i[udp@us2()head(in@us2()head(p))]. This is slightly damaged, and someday
the macro should be made to take a @i[PACKET] as an argument.

@subsection{@i[udp@us2()data()]}

@begin[verbatim]

char *udp@us()data(pup)
	struct udp *pup;

@end[verbatim]

This macro returns a pointer to the data in a UDP packet. It is damaged in a
way similar to @i[udp@us2()head()] (at least the damage is consistent in
nature!) and can be used with a PACKET in the obvious way.
