@part[tftp, root "progman.mss"]

@chapter[TFTP]

Both the user and server TFTP can be linked into programs and called
explicitly (instead of @b[exec]ed by a program). Telnet has an
internal TFTP server; a local printer spooler program uses a built-in
copy of the TFTP user to transfer files. This chapter documents the
programming interface to the spooler and server.

@section[Include files and libraries]

Programs linking in TFTP should link in the @i[-ltftp] library. C
files should @i[#include <tftp.h>].

@section[TFTP User]

The TFTP user is invoked by calling a single function, which returns
when the file transfer completes or aborts.

@subsection{@i[tftpuse()]}

@Begin[verbatim]

long tftpuse(fhost, name, rname, dir, mode, size, deltat)
	in@us()name fhost;
	char *lname;
	char *rname;
	unsigned dir;
	unsigned mode;
	long size;
	long *deltat;
@End[verbatim]

@i[fhost] is the internet address of the host to transfer the file to.
@i[lname] and @i[rname] are the local and remote file names,
respectively. @i[dir] is one of:
@Begin[format]
@ux[constant	@^use						]
@c[get]@\to copy a file from @i[dest] to the local machine
@c[put]@\to copy a file from the local machine to @i[dest]
@End[format]
@c[GET] and @c[PUT] are defined in @i[<tftp.h>]. @i[mode] is one of:
@Begin[format]
@ux[constant	@^use						]
@c[ascii]@\transfer a text file (in netascii mode)
@c[image]@\transfer a binary file
@c[octet]@\transfer a binary file (implemented the same as @c[image]
@c[test]@\binary transfer, don't write the file to disk. @c[test] puts
are not implemented.
@End[format]

@i[size] is the number of bytes to transfer in a @c[test] mode
@c[put] (which does not yet work). The argument is ignored in
@c[ascii, image] and @c[octet] mode transfers (and since @c[test] mode
doesn't do @c[put] it's ignored then too).

@i[deltat] should be the address of a long variable that @i[tftpuse]
can use to store the number of clock ticks it took to transfer the
file.

@i[tftpuse()] returns the actual number of bytes it transferred (text
file transfers will often send a different number of bytes than are
really in the file), and 0 if the transfer failed.
